/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.renderers.morphs;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.entity.layers.Deadmau5HeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.animations.Animation;
import xyz.pixelatedw.mineminenomi.api.effects.ModEffect;
import xyz.pixelatedw.mineminenomi.api.events.ability.RenderMorphEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.morph.MorphModel;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.init.ModRenderTypes;
import xyz.pixelatedw.mineminenomi.renderers.abilities.EleclawRenderer;
import xyz.pixelatedw.mineminenomi.renderers.layers.AuraLayer;
import xyz.pixelatedw.mineminenomi.renderers.layers.BodyCoatingLayer;

@OnlyIn(value=Dist.CLIENT)
public class ZoanMorphRenderer<T extends AbstractClientPlayerEntity, M extends MorphModel>
extends PlayerRenderer {
    protected MorphInfo info;
    private boolean hasCulling = false;

    public ZoanMorphRenderer(EntityRendererManager rendererManager, MorphInfo info) {
        this(rendererManager, info, false);
    }

    public ZoanMorphRenderer(EntityRendererManager rendererManager, MorphInfo info, boolean smallHands) {
        super(rendererManager, smallHands);
        if (info.getModel() != null && !info.isPartial()) {
            this.field_77045_g = info.getModel();
        }
        this.field_76989_e = info.getShadowSize();
        this.info = info;
        this.func_177094_a(new AuraLayer(this));
        this.func_177094_a(new EleclawRenderer((IEntityRenderer)this));
        this.func_177094_a(new BodyCoatingLayer((IEntityRenderer)this));
        this.removeLayer(BipedArmorLayer.class);
        this.removeLayer(CapeLayer.class);
        this.removeLayer(ElytraLayer.class);
        this.removeLayer(Deadmau5HeadLayer.class);
    }

    public void func_225623_a_(AbstractClientPlayerEntity entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        Object ability;
        Direction direction;
        boolean shouldSit;
        this.setModelVisibilities(entity);
        if (MinecraftForge.EVENT_BUS.post((Event)new RenderMorphEvent.Pre((LivingEntity)entity, this, partialTicks, matrixStack, buffer, packedLight))) {
            return;
        }
        matrixStack.func_227860_a_();
        ((PlayerModel)this.field_77045_g).field_205061_a = this.func_77040_d((LivingEntity)entity, partialTicks);
        ((PlayerModel)this.field_77045_g).field_217113_d = shouldSit = entity.func_184218_aH() && entity.func_184187_bx() != null && entity.func_184187_bx().shouldRiderSit();
        ((PlayerModel)this.field_77045_g).field_217114_e = entity.func_70631_g_();
        float headYawOffset = MathHelper.func_219805_h((float)partialTicks, (float)entity.field_70760_ar, (float)entity.field_70761_aq);
        float headYawRotation = MathHelper.func_219805_h((float)partialTicks, (float)entity.field_70758_at, (float)entity.field_70759_as);
        float netHeadYaw = headYawRotation - headYawOffset;
        if (shouldSit && entity.func_184187_bx() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity.func_184187_bx();
            headYawOffset = MathHelper.func_219805_h((float)partialTicks, (float)livingentity.field_70760_ar, (float)livingentity.field_70761_aq);
            netHeadYaw = headYawRotation - headYawOffset;
            float f3 = MathHelper.func_76142_g((float)netHeadYaw);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            headYawOffset = headYawRotation - f3;
            if (f3 * f3 > 2500.0f) {
                headYawOffset += f3 * 0.2f;
            }
            netHeadYaw = headYawRotation - headYawOffset;
        }
        float headPitch = MathHelper.func_219799_g((float)partialTicks, (float)entity.field_70127_C, (float)entity.field_70125_A);
        if (entity.func_213283_Z() == Pose.SLEEPING && (direction = entity.func_213376_dz()) != null) {
            float eyeHeight = entity.func_213307_e(Pose.STANDING) - 0.1f;
            matrixStack.func_227861_a_((double)((float)(-direction.func_82601_c()) * eyeHeight), 0.0, (double)((float)(-direction.func_82599_e()) * eyeHeight));
        }
        float ageInTicks = this.func_77044_a((LivingEntity)entity, partialTicks);
        this.func_225621_a_(entity, matrixStack, ageInTicks, headYawOffset, partialTicks);
        matrixStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
        this.info.preRenderCallback((LivingEntity)entity, matrixStack, partialTicks);
        this.func_225620_a_(entity, matrixStack, partialTicks);
        matrixStack.func_227861_a_(0.0, (double)-1.501f, 0.0);
        float limbSwingAmount = 0.0f;
        float limbSwing = 0.0f;
        if (!shouldSit && entity.func_70089_S()) {
            limbSwingAmount = MathHelper.func_219799_g((float)partialTicks, (float)entity.field_184618_aE, (float)entity.field_70721_aZ);
            limbSwing = entity.field_184619_aG - entity.field_70721_aZ * (1.0f - partialTicks);
            if (entity.func_70631_g_()) {
                limbSwing *= 3.0f;
            }
            if (limbSwingAmount > 1.0f) {
                limbSwingAmount = 1.0f;
            }
        }
        if (this.func_225622_a_((LivingEntity)entity) && (ability = AbilityHelper.getActiveAnimation((LivingEntity)entity)) != null) {
            ((Animation)((AnimationComponent)ability).getAnimation()).tick((LivingEntity)entity);
            ((Animation)((AnimationComponent)ability).getAnimation()).setupAnimation((AbstractClientPlayerEntity)entity, matrixStack, buffer, packedLight, netHeadYaw, partialTicks);
            ((Animation)((AnimationComponent)ability).getAnimation()).setAnimationAngles((AbstractClientPlayerEntity)entity, (EntityModel)this.field_77045_g, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
        this.renderModel(entity, matrixStack, packedLight, buffer, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        if (!entity.func_175149_v()) {
            for (LayerRenderer layerrenderer : this.field_177097_h) {
                layerrenderer.func_225628_a_(matrixStack, buffer, packedLight, (Entity)entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
            }
        }
        matrixStack.func_227865_b_();
        MinecraftForge.EVENT_BUS.post((Event)new RenderMorphEvent.Post((LivingEntity)entity, this, partialTicks, matrixStack, buffer, packedLight));
        RenderNameplateEvent renderNameplateEvent = new RenderNameplateEvent((Entity)entity, entity.func_145748_c_(), (EntityRenderer)this, matrixStack, buffer, packedLight, partialTicks);
        MinecraftForge.EVENT_BUS.post((Event)renderNameplateEvent);
        if (renderNameplateEvent.getResult() != Event.Result.DENY && (renderNameplateEvent.getResult() == Event.Result.ALLOW || this.func_177070_b((LivingEntity)entity))) {
            this.func_225629_a_(entity, renderNameplateEvent.getContent(), matrixStack, buffer, packedLight);
        }
    }

    public void func_225621_a_(AbstractClientPlayerEntity entity, MatrixStack matrixStack, float ageInTicks, float rotationYaw, float partialTicks) {
        boolean isRotationBlocked = entity.func_70651_bq().stream().anyMatch(instance -> instance.func_188419_a() instanceof ModEffect && ((ModEffect)instance.func_188419_a()).isBlockingRotations());
        if (isRotationBlocked) {
            return;
        }
        if (this.info == ModMorphs.ZOU_GUARD.get()) {
            Pose pose = entity.func_213283_Z();
            if (pose != Pose.SLEEPING) {
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - rotationYaw));
            }
            if (entity.field_70725_aQ > 0) {
                float f = ((float)entity.field_70725_aQ + partialTicks - 1.0f) / 20.0f * 1.6f;
                if ((f = MathHelper.func_76129_c((float)f)) > 1.0f) {
                    f = 1.0f;
                }
                matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(f * this.func_77037_a((LivingEntity)entity)));
            }
        } else {
            super.func_225621_a_(entity, matrixStack, ageInTicks, rotationYaw, partialTicks);
        }
    }

    protected void renderModel(AbstractClientPlayerEntity entity, MatrixStack matrixStack, int packedLight, IRenderTypeBuffer buffer, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean flag;
        ((PlayerModel)this.func_217764_d()).func_212843_a_((LivingEntity)entity, limbSwing, limbSwingAmount, partialTicks);
        boolean isRotationBlocked = entity.func_70651_bq().stream().anyMatch(instance -> instance.func_188419_a() instanceof ModEffect && ((ModEffect)instance.func_188419_a()).isBlockingRotations());
        if (!isRotationBlocked) {
            ((PlayerModel)this.func_217764_d()).func_225597_a_((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
        boolean flag1 = !(flag = this.func_225622_a_((LivingEntity)entity)) && !entity.func_98034_c((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
        RenderType renderType = ModRenderTypes.getZoanRenderType(this.func_110775_a(entity));
        if (this.hasCulling) {
            renderType = ModRenderTypes.getZoanWithCullingRenderType(this.func_110775_a(entity));
        }
        if (renderType != null && flag) {
            IVertexBuilder ivertexbuilder = buffer.getBuffer(renderType);
            int i = ZoanMorphRenderer.func_229117_c_((LivingEntity)entity, (float)this.func_225625_b_((LivingEntity)entity, partialTicks));
            ((PlayerModel)this.field_77045_g).func_225598_a_(matrixStack, ivertexbuilder, packedLight, i, 1.0f, 1.0f, 1.0f, flag1 ? 0.15f : 1.0f);
        }
    }

    private void setModelVisibilities(AbstractClientPlayerEntity clientPlayer) {
        PlayerModel playermodel = (PlayerModel)this.func_217764_d();
        if (clientPlayer.func_175149_v()) {
            playermodel.func_178719_a(false);
            playermodel.field_78116_c.field_78806_j = true;
            playermodel.field_178720_f.field_78806_j = true;
        } else {
            ItemStack itemstack = clientPlayer.func_184614_ca();
            ItemStack itemstack1 = clientPlayer.func_184592_cb();
            playermodel.field_228270_o_ = clientPlayer.func_213453_ef();
            BipedModel.ArmPose bipedmodel$armpose = this.getArmPose(clientPlayer, itemstack, itemstack1, Hand.MAIN_HAND);
            BipedModel.ArmPose bipedmodel$armpose1 = this.getArmPose(clientPlayer, itemstack, itemstack1, Hand.OFF_HAND);
            if (clientPlayer.func_184591_cq() == HandSide.RIGHT) {
                playermodel.field_187076_m = bipedmodel$armpose;
                playermodel.field_187075_l = bipedmodel$armpose1;
            } else {
                playermodel.field_187076_m = bipedmodel$armpose1;
                playermodel.field_187075_l = bipedmodel$armpose;
            }
        }
    }

    protected void removeLayer(Class<? extends LayerRenderer> clz) {
        this.field_177097_h.removeIf(layer -> clz.equals(layer.getClass()));
    }

    private BipedModel.ArmPose getArmPose(AbstractClientPlayerEntity playerIn, ItemStack itemStackMain, ItemStack itemStackOff, Hand handIn) {
        ItemStack itemstack;
        BipedModel.ArmPose bipedmodel$armpose = BipedModel.ArmPose.EMPTY;
        ItemStack itemStack = itemstack = handIn == Hand.MAIN_HAND ? itemStackMain : itemStackOff;
        if (!itemstack.func_190926_b()) {
            bipedmodel$armpose = BipedModel.ArmPose.ITEM;
            if (playerIn.func_184605_cv() > 0) {
                UseAction useaction = itemstack.func_77975_n();
                if (useaction == UseAction.BLOCK) {
                    bipedmodel$armpose = BipedModel.ArmPose.BLOCK;
                } else if (useaction == UseAction.BOW) {
                    bipedmodel$armpose = BipedModel.ArmPose.BOW_AND_ARROW;
                } else if (useaction == UseAction.SPEAR) {
                    bipedmodel$armpose = BipedModel.ArmPose.THROW_SPEAR;
                } else if (useaction == UseAction.CROSSBOW && handIn == playerIn.func_184600_cs()) {
                    bipedmodel$armpose = BipedModel.ArmPose.CROSSBOW_CHARGE;
                }
            } else {
                boolean flag3 = itemStackMain.func_77973_b() == Items.field_222114_py;
                boolean flag = CrossbowItem.func_220012_d((ItemStack)itemStackMain);
                boolean flag1 = itemStackOff.func_77973_b() == Items.field_222114_py;
                boolean flag2 = CrossbowItem.func_220012_d((ItemStack)itemStackOff);
                if (flag3 && flag) {
                    bipedmodel$armpose = BipedModel.ArmPose.CROSSBOW_HOLD;
                }
                if (flag1 && flag2 && itemStackMain.func_77973_b().func_77661_b(itemStackMain) == UseAction.NONE) {
                    bipedmodel$armpose = BipedModel.ArmPose.CROSSBOW_HOLD;
                }
            }
        }
        return bipedmodel$armpose;
    }

    public ResourceLocation func_110775_a(AbstractClientPlayerEntity entity) {
        if (this.info instanceof MorphInfo && this.info.getTexture((LivingEntity)entity) != null && !this.info.isPartial()) {
            return this.info.getTexture((LivingEntity)entity);
        }
        return entity.func_110306_p();
    }

    public void setCullingState(boolean flag) {
        this.hasCulling = flag;
    }

    public static class Factory<T extends PlayerEntity>
    implements IRenderFactory<T> {
        private MorphInfo info;
        private boolean hasCulling;

        public Factory(MorphInfo info) {
            this.info = info;
        }

        public Factory(MorphInfo info, boolean hasCulling) {
            this.info = info;
            this.hasCulling = hasCulling;
        }

        public EntityRenderer<? super T> createRenderFor(EntityRendererManager manager) {
            ZoanMorphRenderer renderer = new ZoanMorphRenderer(manager, this.info);
            renderer.setCullingState(this.hasCulling);
            return renderer;
        }
    }
}

