/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import joptsimple.internal.Strings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.GuiUtils;
import xyz.pixelatedw.mineminenomi.api.IScreenEventReceiver;
import xyz.pixelatedw.mineminenomi.api.challenges.Challenge;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeDifficulty;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeInvitation;
import xyz.pixelatedw.mineminenomi.api.helpers.RendererHelper;
import xyz.pixelatedw.mineminenomi.api.math.EasingFunctionHelper;
import xyz.pixelatedw.mineminenomi.config.ClientConfig;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.packets.client.challenge.CDisbandChallengeGroupPacket;
import xyz.pixelatedw.mineminenomi.packets.client.challenge.CStartChallengePacket;
import xyz.pixelatedw.mineminenomi.packets.client.ui.CScreenEventPacket;
import xyz.pixelatedw.mineminenomi.screens.extra.buttons.GroupMemberButton;
import xyz.pixelatedw.mineminenomi.screens.extra.buttons.PlankButton;
import xyz.pixelatedw.mineminenomi.screens.extra.buttons.TexturedIconButton;
import xyz.pixelatedw.mineminenomi.screens.extra.panels.AvailableChallengesListPanel;
import xyz.pixelatedw.mineminenomi.screens.extra.panels.ChallengeGroupSelectorPanel;
import xyz.pixelatedw.mineminenomi.screens.extra.panels.ChallengeInvitesPanel;
import xyz.pixelatedw.mineminenomi.screens.widgets.NewCheckboxButton;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

@OnlyIn(value=Dist.CLIENT)
public class ChallengesScreen
extends Screen
implements IScreenEventReceiver {
    private static final float MAX_ANIMATION_TICKS = 20.0f;
    private final ClientPlayerEntity player;
    private final List<Challenge> challenges;
    private final List<ChallengeInvitation> invites;
    private final Map<String, List<Challenge>> challengesMap;
    private final List<String> categories = new ArrayList<String>();
    private List<Challenge> displayedChallenges;
    @Nullable
    private Challenge selectedChallenge;
    private String selectedChallengeStars;
    private String selectedCategory;
    private int selectedCategoryId;
    private ITextComponent selectedCategoryLocalizedName;
    @Nullable
    private ResourceLocation selectedCategoryIcon;
    @Nullable
    private LivingEntity[] targets = new LivingEntity[4];
    private int targetsCount;
    private LivingEntity[] group = new LivingEntity[3];
    private GroupMemberButton[] groupMemberButtons = new GroupMemberButton[3];
    private GroupMemberButton groupOwnerButton;
    private AvailableChallengesListPanel challengesListPanel;
    private ChallengeGroupSelectorPanel challengesGroupSelectorPanel;
    private ChallengeInvitesPanel challengeInvitesPanel;
    private LivingEntity dummyBust;
    private int selectedMemberSlot;
    private NewCheckboxButton freeCheckbox;
    private boolean startedChallenge = false;
    private int setupStep;
    private PlankButton startChallengeButton;
    private TexturedIconButton nextStepButton;
    private TexturedIconButton prevStepButton;
    private float renderTick;
    private boolean runInfoPanelAnimation;
    private boolean runCategoryChangeAnimation;
    private float infoPanelAnimationTick = 0.0f;
    private float categoryChangeAnimationTick = 0.0f;

    public ChallengesScreen(List<Challenge> challenges, List<ChallengeInvitation> invites) {
        super(StringTextComponent.field_240750_d_);
        this.player = Minecraft.func_71410_x().field_71439_g;
        this.challenges = challenges;
        this.invites = invites;
        this.challenges.sort((o1, o2) -> o2.getCore().getOrder() - o1.getCore().getOrder());
        this.challengesMap = challenges.stream().collect(Collectors.groupingBy(Challenge::getCategory));
        this.categories.add("");
        this.categories.addAll(this.challengesMap.keySet());
        this.selectedCategoryId = 0;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        int posX = (this.field_230708_k_ - 256) / 2;
        int posY = (this.field_230709_l_ - 256) / 2;
        if (this.runCategoryChangeAnimation && this.categoryChangeAnimationTick < 20.0f) {
            this.categoryChangeAnimationTick += 2.2f * this.field_230706_i_.func_193989_ak();
            this.categoryChangeAnimationTick = Math.min(this.categoryChangeAnimationTick, 20.0f);
        }
        if (this.runInfoPanelAnimation && this.infoPanelAnimationTick < 20.0f) {
            this.infoPanelAnimationTick += 2.0f * this.field_230706_i_.func_193989_ak();
            this.infoPanelAnimationTick = Math.min(this.infoPanelAnimationTick, 20.0f);
        }
        float infoPanelAnimationOffset = EasingFunctionHelper.easeOutBack(Float.valueOf(this.infoPanelAnimationTick / 20.0f));
        float categoryChangeAnimationOffset = EasingFunctionHelper.easeOutCubic(Float.valueOf(this.categoryChangeAnimationTick / 20.0f));
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)(posX - 210), (double)((float)(posY - 122) - categoryChangeAnimationOffset * 4.0f), 0.0);
        matrixStack.func_227861_a_(128.0, 128.0, 0.0);
        WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, this.selectedCategoryLocalizedName, 40, 15, -1);
        if (this.selectedCategoryIcon != null) {
            matrixStack.func_227862_a_(0.15f, 0.15f, 0.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.selectedCategoryIcon);
            GuiUtils.drawTexturedModalRect((MatrixStack)matrixStack, (int)0, (int)0, (int)0, (int)0, (int)256, (int)256, (float)5.0f);
        }
        matrixStack.func_227861_a_(-128.0, -128.0, 0.0);
        matrixStack.func_227865_b_();
        posY += 25;
        if (this.selectedChallenge != null && infoPanelAnimationOffset > 0.0f) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)((float)(posX + 115) - (infoPanelAnimationOffset *= 320.0f)), (double)(posY - 246), 0.0);
            matrixStack.func_227861_a_(256.0, 256.0, 0.0);
            matrixStack.func_227862_a_(1.25f, 1.25f, 0.0f);
            this.field_230706_i_.func_110434_K().func_110577_a(ModResources.BOARD);
            this.func_238474_b_(matrixStack, 0, 0, 0, 0, 256, 256);
            this.field_230706_i_.func_110434_K().func_110577_a(ModResources.BLANK_NEW);
            this.func_238474_b_(matrixStack, 0, 0, 0, 0, 256, 256);
            matrixStack.func_227861_a_(-256.0, -256.0, 0.0);
            matrixStack.func_227865_b_();
            int posX2 = posX + 450 - (int)infoPanelAnimationOffset;
            if (this.setupStep == 0) {
                matrixStack.func_227860_a_();
                if (this.targetsCount == 1) {
                    if (this.targets[0] != null) {
                        RendererHelper.drawLivingBust(this.targets[0], matrixStack, posX2 + 5, posY + 200, 40, -30, 10, false);
                    }
                } else if (this.targetsCount == 2) {
                    if (this.targets[0] != null) {
                        RendererHelper.drawLivingBust(this.targets[0], matrixStack, posX2 - 25, posY + 180, 35, -30, 10, false);
                    }
                    if (this.targets[1] != null) {
                        RendererHelper.drawLivingBust(this.targets[1], matrixStack, posX2 + 25, posY + 180, 35, -30, 10, false);
                    }
                } else {
                    if (this.targets[0] != null) {
                        RendererHelper.drawLivingBust(this.targets[0], matrixStack, posX2 - 25, posY + 150, 30, -30, 10, false);
                    }
                    if (this.targets[1] != null) {
                        RendererHelper.drawLivingBust(this.targets[1], matrixStack, posX2 + 25, posY + 150, 30, -30, 10, false);
                    }
                    if (this.targets[2] != null) {
                        RendererHelper.drawLivingBust(this.targets[2], matrixStack, posX2 - 25, posY + 200, 30, -30, 10, false);
                    }
                    if (this.targets[3] != null) {
                        RendererHelper.drawLivingBust(this.targets[3], matrixStack, posX2 + 25, posY + 200, 30, -30, 10, false);
                    }
                }
                matrixStack.func_227865_b_();
                WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, this.selectedChallenge.getCore().getLocalizedTitle().getString(), posX2 - 30, posY + 35, -1);
                WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, (ITextComponent)this.selectedChallenge.getCore().getLocalizedObjective(), posX2 - 20, posY + 50, -1);
                String timeLimit = WyHelper.formatTimeMMSS(this.selectedChallenge.getCore().getTimeLimit() * 60);
                String timeLimitStr = ModI18n.GUI_TIME_LIMIT.getString() + ": " + timeLimit;
                WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, timeLimitStr, posX2 + 60, posY + 90, -1);
                String pbTime = WyHelper.formatTimeMMSS(this.selectedChallenge.getBestTimeTick());
                String pbTimeStr = ModI18n.GUI_PERSONAL_BEST.getString() + ": " + pbTime;
                WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, pbTimeStr, posX2 + 60, posY + 105, -1);
                String difficultyStr = ModI18n.GUI_DIFFICULTY.getString() + ": " + this.selectedChallengeStars;
                WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, difficultyStr, posX2 + 60, posY + 120, -1);
                if (this.selectedChallenge.getCore().getDifficulty() != ChallengeDifficulty.STANDARD) {
                    WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, (ITextComponent)ModI18n.GUI_RESTRICTIONS, posX2 + 60, posY + 135, -1);
                    WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, "  - \u00a7cNo Food\u00a7r", posX2 + 60, posY + 145, -1);
                    WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, "  - \u00a7cNo Potions\u00a7r", posX2 + 60, posY + 155, -1);
                }
            } else if (this.setupStep == 1) {
                this.groupOwnerButton.field_230690_l_ = posX2 - 30;
                this.groupOwnerButton.field_230691_m_ = posY + 40;
                this.groupMemberButtons[0].field_230690_l_ = posX2 + 40;
                this.groupMemberButtons[0].field_230691_m_ = posY + 40;
                this.groupMemberButtons[1].field_230690_l_ = posX2 - 30;
                this.groupMemberButtons[1].field_230691_m_ = posY + 95;
                this.groupMemberButtons[2].field_230690_l_ = posX2 + 40;
                this.groupMemberButtons[2].field_230691_m_ = posY + 95;
                for (int i = 0; i < this.groupMemberButtons.length; ++i) {
                    if (this.groupMemberButtons[i] == null) continue;
                    this.groupMemberButtons[i].func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
                }
                this.groupOwnerButton.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
                this.freeCheckbox.field_230690_l_ = posX2 - 40;
                this.freeCheckbox.field_230691_m_ = posY + 160;
            } else if (this.setupStep == 2 && this.selectedMemberSlot >= 0 && this.challengesGroupSelectorPanel != null) {
                this.challengesGroupSelectorPanel.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            }
        } else if (this.selectedChallenge == null && infoPanelAnimationOffset > 0.0f) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)((float)(posX + 115) - (infoPanelAnimationOffset *= 320.0f)), (double)(posY - 246), 0.0);
            matrixStack.func_227861_a_(256.0, 256.0, 0.0);
            matrixStack.func_227862_a_(1.25f, 1.25f, 0.0f);
            this.field_230706_i_.func_110434_K().func_110577_a(ModResources.BOARD);
            this.func_238474_b_(matrixStack, 0, 0, 0, 0, 256, 256);
            this.field_230706_i_.func_110434_K().func_110577_a(ModResources.BLANK_NEW);
            this.func_238474_b_(matrixStack, 0, 0, 0, 0, 256, 256);
            matrixStack.func_227861_a_(-256.0, -256.0, 0.0);
            matrixStack.func_227865_b_();
            int posX2 = posX + 450 - (int)infoPanelAnimationOffset;
            if (this.challengeInvitesPanel != null) {
                this.challengeInvitesPanel.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            }
        }
        if (this.challengesListPanel != null) {
            this.challengesListPanel.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
        this.renderTick += 1.0f * this.field_230706_i_.func_193989_ak();
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public void func_231160_c_() {
        int posX = (this.field_230708_k_ - 256) / 2;
        int posY = (this.field_230709_l_ - 256) / 2;
        this.renderTick = 0.0f;
        this.field_230710_m_.clear();
        this.dummyBust = (LivingEntity)EntityType.field_200756_av.func_200721_a((World)this.field_230706_i_.field_71441_e);
        TexturedIconButton prevCategoryButton = new TexturedIconButton(ModResources.WOOD_ARROW_LEFT, posX - 110, posY + 10, 30, 20, StringTextComponent.field_240750_d_, btn -> {
            if (this.selectedCategoryId - 1 >= 0) {
                --this.selectedCategoryId;
                this.updateSelectedCategory();
            } else {
                this.selectedCategoryId = this.categories.size() - 1;
                this.updateSelectedCategory();
            }
        });
        prevCategoryButton = prevCategoryButton.setTextureInfo(posX - 111, posY + 9, 32, 23);
        this.func_230480_a_((Widget)prevCategoryButton);
        TexturedIconButton nextCategoryButton = new TexturedIconButton(ModResources.WOOD_ARROW_RIGHT, posX + 70, posY + 10, 30, 20, StringTextComponent.field_240750_d_, btn -> {
            if (this.selectedCategoryId + 1 < this.categories.size()) {
                ++this.selectedCategoryId;
                this.updateSelectedCategory();
            } else {
                this.selectedCategoryId = 0;
                this.updateSelectedCategory();
            }
        });
        nextCategoryButton = nextCategoryButton.setTextureInfo(posX + 69, posY + 9, 32, 23);
        this.func_230480_a_((Widget)nextCategoryButton);
        if (this.invites.size() > 0) {
            TranslationTextComponent invitesMessage = new TranslationTextComponent(ModI18n.GUI_INVITES_AMOUNT, new Object[]{this.invites.size()});
            PlankButton invitesButton = new PlankButton(posX + 120, posY + 8, 100, 25, (ITextComponent)invitesMessage, btn -> this.showInvitesScreen());
            this.func_230480_a_((Widget)invitesButton);
        }
        this.prevStepButton = new TexturedIconButton(ModResources.WOOD_ARROW_LEFT, posX + 90, posY + 220, 50, 30, StringTextComponent.field_240750_d_, btn -> {
            if (this.setupStep == 1) {
                this.showChallengeInfoStep();
            } else if (this.setupStep == 2) {
                this.showGroupStep();
            }
        });
        this.prevStepButton = this.prevStepButton.setTextureInfo(posX + 90, posY + 220, 50, 30);
        this.prevStepButton.field_230694_p_ = false;
        this.func_230480_a_((Widget)this.prevStepButton);
        this.nextStepButton = new TexturedIconButton(ModResources.WOOD_ARROW_RIGHT, posX + 170, posY + 220, 50, 30, StringTextComponent.field_240750_d_, btn -> {
            if (this.setupStep == 0) {
                this.showGroupStep();
            }
        });
        this.nextStepButton = this.nextStepButton.setTextureInfo(posX + 170, posY + 220, 50, 30);
        this.nextStepButton.field_230694_p_ = false;
        this.func_230480_a_((Widget)this.nextStepButton);
        this.startChallengeButton = new PlankButton(posX + 250, posY + 220, 70, 30, (ITextComponent)ModI18n.GUI_START, btn -> {
            this.startedChallenge = true;
            boolean isFree = this.freeCheckbox != null && this.freeCheckbox.func_212942_a();
            WyNetwork.sendToServer(new CStartChallengePacket(this.selectedChallenge.getCore().getRegistryName(), isFree));
            this.field_230706_i_.func_147108_a(null);
        });
        this.startChallengeButton.field_230694_p_ = false;
        this.func_230480_a_((Widget)this.startChallengeButton);
        this.freeCheckbox = new NewCheckboxButton(posX + 90, posY + 185, 60, 20, (ITextComponent)ModI18n.GUI_TRAINING, false);
        this.freeCheckbox.setTooltip((button, matrixStack, mouseX, mouseY) -> this.func_238654_b_(matrixStack, this.field_230706_i_.field_71466_p.func_238425_b_((ITextProperties)ModI18n.CHALLENGE_MESSAGE_TRAINING_INFO, Math.max(this.field_230708_k_ / 2 - 43, 240)), mouseX, mouseY));
        this.freeCheckbox.field_230694_p_ = false;
        this.func_230480_a_((Widget)this.freeCheckbox);
        this.updateSelectedCategory();
    }

    private void showInvitesScreen() {
        this.startInfoPanelAnimation();
        this.selectedChallenge = null;
        this.nextStepButton.field_230694_p_ = false;
        this.prevStepButton.field_230694_p_ = false;
        this.freeCheckbox.field_230694_p_ = false;
        this.startChallengeButton.field_230694_p_ = false;
        this.removeGroupMemberElements();
        this.field_230705_e_.remove((Object)this.challengeInvitesPanel);
        this.challengeInvitesPanel = new ChallengeInvitesPanel(this, (PlayerEntity)this.player, this.invites);
        this.field_230705_e_.add(this.challengeInvitesPanel);
    }

    private void showChallengeInfoStep() {
        this.startInfoPanelAnimation();
        this.setupStep = 0;
        this.startChallengeButton.field_230694_p_ = false;
        this.nextStepButton.field_230694_p_ = true;
        this.prevStepButton.field_230694_p_ = false;
        this.freeCheckbox.field_230694_p_ = false;
        this.removeGroupMemberElements();
        this.field_230705_e_.remove((Object)this.challengeInvitesPanel);
        this.selectedMemberSlot = -1;
    }

    public void showGroupStep() {
        this.startInfoPanelAnimation();
        this.setupStep = 1;
        this.startChallengeButton.field_230694_p_ = true;
        this.nextStepButton.field_230694_p_ = false;
        this.prevStepButton.field_230694_p_ = true;
        this.freeCheckbox.field_230694_p_ = true;
        this.field_230705_e_.remove((Object)this.challengesGroupSelectorPanel);
        this.createGroupButtons();
    }

    private void showGroupSelectionStep() {
        this.startInfoPanelAnimation();
        this.setupStep = 2;
        this.startChallengeButton.field_230694_p_ = false;
        this.nextStepButton.field_230694_p_ = false;
        this.prevStepButton.field_230694_p_ = true;
        this.freeCheckbox.field_230694_p_ = false;
        for (int i = 0; i < this.groupMemberButtons.length; ++i) {
            this.groupMemberButtons[i] = null;
        }
        this.field_230705_e_.removeIf(obtn -> obtn instanceof GroupMemberButton);
    }

    private void createGroupButtons() {
        GroupMemberButton groupMember3;
        GroupMemberButton groupMember2;
        GroupMemberButton groupMember1;
        int posX = (this.field_230708_k_ - 256) / 2;
        int posY = (this.field_230709_l_ - 256) / 2;
        for (int i = 0; i < this.groupMemberButtons.length; ++i) {
            this.groupMemberButtons[i] = null;
        }
        this.field_230705_e_.removeIf(obtn -> obtn instanceof GroupMemberButton);
        this.selectedMemberSlot = -1;
        this.groupOwnerButton = new GroupMemberButton(posX + 100, posY + 65, 45, 45, (LivingEntity)this.player, this.dummyBust, btn -> {});
        this.groupOwnerButton.field_230693_o_ = false;
        this.func_230481_d_((IGuiEventListener)this.groupOwnerButton);
        this.groupMemberButtons[0] = groupMember1 = new GroupMemberButton(posX + 170, posY + 65, 45, 45, this.group[0], this.dummyBust, btn -> WyNetwork.sendToServer(new CScreenEventPacket(100)));
        this.func_230481_d_((IGuiEventListener)groupMember1);
        this.groupMemberButtons[1] = groupMember2 = new GroupMemberButton(posX + 100, posY + 120, 45, 45, this.group[1], this.dummyBust, btn -> WyNetwork.sendToServer(new CScreenEventPacket(101)));
        this.func_230481_d_((IGuiEventListener)groupMember2);
        this.groupMemberButtons[2] = groupMember3 = new GroupMemberButton(posX + 170, posY + 120, 45, 45, this.group[2], this.dummyBust, btn -> WyNetwork.sendToServer(new CScreenEventPacket(102)));
        this.func_230481_d_((IGuiEventListener)groupMember3);
        this.freeCheckbox.field_230694_p_ = this.selectedChallenge.getCore().getDifficulty() != ChallengeDifficulty.STANDARD;
    }

    public void removeGroupMemberElements() {
        for (int i = 0; i < this.groupMemberButtons.length; ++i) {
            this.groupMemberButtons[i] = null;
        }
        this.field_230705_e_.removeIf(obtn -> obtn instanceof GroupMemberButton);
    }

    public void setGroupMember(int idx, LivingEntity entity) {
        this.group[idx] = entity;
        this.showGroupStep();
    }

    public void setGroupMember(LivingEntity entity) {
        this.group[this.selectedMemberSlot] = entity;
        this.showGroupStep();
    }

    public int getSelectedMemberSlot() {
        return this.selectedMemberSlot;
    }

    public LivingEntity[] getGroup() {
        return this.group;
    }

    @Override
    public void handleEvent(int eventId, @Nullable Object data) {
        switch (eventId) {
            case 100: 
            case 101: 
            case 102: {
                this.openNearbyGroupSelector(eventId - 100, (List)data);
                break;
            }
        }
    }

    private void openNearbyGroupSelector(int id, List<Integer> nearbyIds) {
        this.showGroupSelectionStep();
        this.selectedMemberSlot = id;
        this.field_230705_e_.remove((Object)this.challengesGroupSelectorPanel);
        this.challengesGroupSelectorPanel = new ChallengeGroupSelectorPanel(this, (PlayerEntity)this.player, nearbyIds);
        this.field_230705_e_.add(this.challengesGroupSelectorPanel);
    }

    private String createDifficultyStars() {
        if (this.selectedChallenge == null) {
            return "";
        }
        int difficulty = this.selectedChallenge.getCore().getDifficultyStars();
        boolean showSimpleDifficulty = ClientConfig.INSTANCE.isSimpleDisplaysEnabled();
        StringBuilder sb = new StringBuilder();
        if (showSimpleDifficulty) {
            int layer = difficulty / 10;
            TextFormatting color = TextFormatting.RESET;
            if (layer == 0) {
                color = TextFormatting.YELLOW;
            } else if (layer == 1) {
                color = TextFormatting.RED;
            } else if (layer == 2) {
                color = TextFormatting.DARK_PURPLE;
            }
            sb.append(color.toString() + difficulty + " / " + ModValues.MAX_DIFFICULTY);
        } else {
            String[] starChars = new String[]{"\u2606", "\u2606", "\u2606", "\u2606", "\u2606", "\u2606", "\u2606", "\u2606", "\u2606", "\u2606"};
            int max_layer = (difficulty - 1) / starChars.length;
            for (int i = 0; i < ModValues.MAX_DIFFICULTY; ++i) {
                int starPos = i % starChars.length;
                int layer = i / starChars.length;
                if (i >= difficulty) continue;
                TextFormatting color = TextFormatting.RESET;
                if (layer == 0) {
                    color = TextFormatting.YELLOW;
                } else if (layer == 1) {
                    color = TextFormatting.RED;
                } else if (layer == 2) {
                    color = TextFormatting.DARK_PURPLE;
                }
                starChars[starPos] = color.toString() + (layer < max_layer ? "\u2606" : "\u2605") + "\u00a7r";
            }
            for (String star : starChars) {
                sb.append(star);
            }
        }
        return sb.toString();
    }

    @Nullable
    public Challenge getSelectedChallenge() {
        return this.selectedChallenge;
    }

    public void setSelectedChallenge(@Nullable Challenge ch) {
        this.selectedChallenge = ch;
        this.selectedChallengeStars = this.createDifficultyStars();
        this.setupStep = 0;
        this.updateTargets();
        this.field_230710_m_.removeIf(obtn -> obtn instanceof GroupMemberButton);
        this.startChallengeButton.field_230694_p_ = false;
        this.nextStepButton.field_230694_p_ = this.selectedChallenge != null;
        this.prevStepButton.field_230694_p_ = false;
        this.freeCheckbox.field_230694_p_ = false;
        this.selectedMemberSlot = -1;
        for (int i = 0; i < this.group.length; ++i) {
            this.group[i] = null;
        }
    }

    @Nullable
    private void updateTargets() {
        if (this.selectedChallenge == null) {
            return;
        }
        this.targets = new LivingEntity[4];
        int i = 0;
        for (LivingEntity target : this.selectedChallenge.getCore().getTargetShowcase((World)this.field_230706_i_.field_71441_e)) {
            if (i > 3) break;
            if (target == null) continue;
            this.targets[i] = target;
            ++i;
        }
        this.targetsCount = i;
    }

    public void updateSelectedCategory() {
        this.selectedCategory = this.categories.get(this.selectedCategoryId);
        this.setSelectedChallenge(null);
        this.runInfoPanelAnimation = false;
        this.infoPanelAnimationTick = 0.0f;
        this.runCategoryChangeAnimation = true;
        this.categoryChangeAnimationTick = 0.0f;
        if (Strings.isNullOrEmpty((String)this.selectedCategory)) {
            this.displayedChallenges = this.challenges;
            this.selectedCategoryLocalizedName = ModI18n.GUI_ALL;
            this.selectedCategoryIcon = null;
        } else {
            this.displayedChallenges = this.challengesMap.get(this.selectedCategory);
            this.selectedCategoryLocalizedName = new TranslationTextComponent(this.selectedCategory);
            String categoryId = this.selectedCategory.replace("challenge.category.", "").replace("crew.name.", "");
            this.selectedCategoryIcon = new ResourceLocation("mineminenomi", "textures/gui/challenges/" + WyHelper.getResourceName(categoryId) + ".png");
        }
        this.field_230705_e_.remove((Object)this.challengesListPanel);
        this.challengesListPanel = new AvailableChallengesListPanel(this, this.displayedChallenges);
        this.field_230705_e_.add(this.challengesListPanel);
    }

    public void renderEntityBust(@Nullable LivingEntity entity, MatrixStack matrixStack, int posX, int posY) {
        if (entity != null) {
            RendererHelper.drawLivingBust(entity, matrixStack, posX, posY, 30, -30, 10, false);
            String entityName = this.getEntityName(entity);
            WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, entityName, posX - this.field_230712_o_.func_78256_a(entityName) / 2, posY - 30, -1);
        } else {
            RendererHelper.drawLivingBust(this.dummyBust, matrixStack, posX, posY, 30, -30, 10, true);
            String entityName = "Select One";
            WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, entityName, posX - this.field_230712_o_.func_78256_a(entityName) / 2, posY - 30, -1);
        }
    }

    private String getEntityName(LivingEntity entity) {
        if (entity instanceof PlayerEntity) {
            return ((PlayerEntity)entity).func_146103_bH().getName();
        }
        return entity.func_145748_c_().getString();
    }

    public void startInfoPanelAnimation() {
        this.runInfoPanelAnimation = true;
        this.infoPanelAnimationTick = 0.0f;
    }

    public LivingEntity getDummyBust() {
        return this.dummyBust;
    }

    public boolean isInfoPanelAnimationComplete() {
        return this.selectedChallenge != null && this.runInfoPanelAnimation && this.infoPanelAnimationTick >= 20.0f;
    }

    public void func_231175_as__() {
        if (!this.startedChallenge) {
            WyNetwork.sendToServer(new CDisbandChallengeGroupPacket());
        }
        super.func_231175_as__();
    }

    public boolean func_231177_au__() {
        return false;
    }

    public static void open(List<Challenge> challenges, List<ChallengeInvitation> invites) {
        Minecraft.func_71410_x().func_147108_a((Screen)new ChallengesScreen(challenges, invites));
    }
}

