/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.screens;

import com.google.common.base.Strings;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.ChallengesDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.IChallengesData;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.events.devilfruits.RandomFruitEvents;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.items.AkumaNoMiItem;
import xyz.pixelatedw.mineminenomi.packets.client.CRequestSyncAbilityDataPacket;
import xyz.pixelatedw.mineminenomi.packets.client.CRequestSyncQuestDataPacket;
import xyz.pixelatedw.mineminenomi.packets.client.ui.COpenChallengesScreenPacket;
import xyz.pixelatedw.mineminenomi.packets.client.ui.COpenCrewScreenPacket;
import xyz.pixelatedw.mineminenomi.screens.extra.buttons.PlankButton;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

@OnlyIn(value=Dist.CLIENT)
public class PlayerStatsScreen
extends Screen {
    private final PlayerEntity player;
    private IEntityStats entityStatsProps;
    private IDevilFruit devilFruitProps;
    private IChallengesData challengesProps;
    private final boolean hasQuests;
    private final int questAmount;
    private final boolean hasChallenges;
    private final int challengeAmount;
    private final boolean isInCombat;
    private final boolean isInChallengeDimension;
    private final int invites;
    private final boolean hasCrew;

    public PlayerStatsScreen(boolean hasQuests, int questAmount, boolean hasChallenges, int challengeAmount, boolean isInCombat, boolean isInChallengeDimension, int invites, boolean hasCrew) {
        super(StringTextComponent.field_240750_d_);
        this.player = Minecraft.func_71410_x().field_71439_g;
        this.hasQuests = hasQuests;
        this.questAmount = questAmount;
        this.hasChallenges = hasChallenges;
        this.challengeAmount = challengeAmount;
        this.isInCombat = isInCombat;
        this.isInChallengeDimension = isInChallengeDimension;
        this.invites = invites;
        this.hasCrew = hasCrew;
    }

    public void func_230430_a_(MatrixStack matrixStack, int x, int y, float f) {
        String style;
        String race;
        this.func_230446_a_(matrixStack);
        int posX = (this.field_230708_k_ - 256) / 2;
        int posY = (this.field_230709_l_ - 256) / 2;
        String colaLabel = new TranslationTextComponent(ModI18n.GUI_COLA).getString();
        String dorikiLabel = new TranslationTextComponent(ModI18n.GUI_DORIKI).getString();
        String faction = WyHelper.getResourceName(this.entityStatsProps.getFaction());
        if (Strings.isNullOrEmpty((String)faction)) {
            faction = "empty";
        }
        if (Strings.isNullOrEmpty((String)(race = WyHelper.getResourceName(this.entityStatsProps.getRace().toLowerCase())))) {
            race = "empty";
        }
        if (Strings.isNullOrEmpty((String)(style = WyHelper.getResourceName(this.entityStatsProps.getFightingStyle().toLowerCase())))) {
            style = "empty";
        }
        String actualRank = "";
        if (this.entityStatsProps.isMarine()) {
            FactionHelper.MarineRank marineRank = this.entityStatsProps.getMarineRank();
            actualRank = marineRank != null ? " - " + marineRank.getLocalizedName() : "";
        } else if (this.entityStatsProps.isRevolutionary()) {
            FactionHelper.RevolutionaryRank revoRank = this.entityStatsProps.getRevolutionaryRank();
            actualRank = revoRank != null ? " - " + revoRank.getLocalizedName() : "";
        }
        String factionActual = new TranslationTextComponent("faction." + faction).getString() + actualRank;
        String raceActual = new TranslationTextComponent("race." + race).getString();
        String styleActual = new TranslationTextComponent("style." + style).getString();
        if (this.entityStatsProps.isCyborg()) {
            WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, TextFormatting.BOLD + colaLabel + ": " + TextFormatting.RESET + this.entityStatsProps.getCola() + " / " + this.entityStatsProps.getMaxCola(), posX - 50, posY + 50, -1);
        }
        WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, TextFormatting.BOLD + dorikiLabel + ": " + TextFormatting.RESET + Math.round(this.entityStatsProps.getDoriki()), posX - 50, posY + 70, -1);
        WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, TextFormatting.BOLD + ModI18n.FACTION_NAME.getString() + ": " + TextFormatting.RESET + factionActual, posX - 50, posY + 90, -1);
        WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, TextFormatting.BOLD + ModI18n.RACE_NAME.getString() + ": " + TextFormatting.RESET + raceActual, posX - 50, posY + 110, -1);
        WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, TextFormatting.BOLD + ModI18n.STYLE_NAME.getString() + ": " + TextFormatting.RESET + styleActual, posX - 50, posY + 130, -1);
        if (this.entityStatsProps.getBelly() > 0L) {
            WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, "" + this.entityStatsProps.getBelly(), posX + 215, posY + 72, -1);
            this.field_230706_i_.field_71446_o.func_110577_a(ModResources.CURRENCIES);
            this.func_238474_b_(matrixStack, posX + 190, posY + 60, 0, 32, 32, 64);
        }
        if (this.entityStatsProps.getExtol() > 0L) {
            WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, "" + this.entityStatsProps.getExtol(), posX + 215, posY + 102, -1);
            this.field_230706_i_.field_71446_o.func_110577_a(ModResources.CURRENCIES);
            this.func_238474_b_(matrixStack, posX + 190, posY + 89, 34, 32, 64, 86);
        }
        if (this.devilFruitProps.hasAnyDevilFruit()) {
            ItemStack yamiFruit = new ItemStack((IItemProvider)ModAbilities.YAMI_YAMI_NO_MI);
            if (this.devilFruitProps.hasDevilFruit(ModAbilities.YAMI_YAMI_NO_MI)) {
                ItemStack df = new ItemStack((IItemProvider)this.devilFruitProps.getDevilFruitItem());
                ResourceLocation dfKey = ((AkumaNoMiItem)df.func_77973_b()).getRegistryName();
                boolean dual = this.devilFruitProps.hasYamiPower() && !dfKey.equals((Object)ModAbilities.YAMI_YAMI_NO_MI.getRegistryName());
                int color = -1;
                if (this.devilFruitProps.hasAwakenedFruit()) {
                    color = WyHelper.hexToRGB("#ECA629").getRGB();
                }
                if (dual) {
                    this.field_230706_i_.field_71466_p.func_238405_a_(matrixStack, TextFormatting.BOLD + "" + yamiFruit.func_200301_q().getString() + " + " + df.func_200301_q().getString(), (float)(posX - 28), (float)(posY + 194), color);
                } else {
                    this.field_230706_i_.field_71466_p.func_238405_a_(matrixStack, TextFormatting.BOLD + "" + yamiFruit.func_200301_q().getString(), (float)(posX - 28), (float)(posY + 194), color);
                }
                if (dual) {
                    this.drawItemStack(df, posX - 56, posY + 187, "");
                }
                this.drawItemStack(yamiFruit, posX - 50, posY + 190, "");
            } else {
                ItemStack df = new ItemStack((IItemProvider)this.devilFruitProps.getDevilFruitItem());
                if (!df.func_190926_b()) {
                    String fruitName = df.func_200301_q().getString();
                    if (RandomFruitEvents.Client.HAS_RANDOMIZED_FRUIT) {
                        AkumaNoMiItem item = ((AkumaNoMiItem)df.func_77973_b()).getReverseShiftedFruit(this.player.field_70170_p);
                        df = new ItemStack((IItemProvider)item);
                    }
                    boolean doubleYamiCheck = false;
                    String dfKey = ((AkumaNoMiItem)df.func_77973_b()).getFruitKey();
                    if (dfKey.equalsIgnoreCase("yami_yami") && this.devilFruitProps.hasYamiPower()) {
                        doubleYamiCheck = true;
                    }
                    int color = -1;
                    if (this.devilFruitProps.hasAwakenedFruit()) {
                        color = WyHelper.hexToRGB("#ECA629").getRGB();
                    }
                    if (this.devilFruitProps.hasYamiPower() && !doubleYamiCheck) {
                        this.field_230706_i_.field_71466_p.func_238405_a_(matrixStack, TextFormatting.BOLD + "" + yamiFruit.func_200301_q().getString() + " + " + df.func_200301_q().getString(), (float)(posX - 28), (float)(posY + 194), color);
                    } else {
                        this.field_230706_i_.field_71466_p.func_238405_a_(matrixStack, TextFormatting.BOLD + "" + fruitName, (float)(posX - 28), (float)(posY + 194), color);
                    }
                    if (this.devilFruitProps.hasYamiPower() && !doubleYamiCheck) {
                        this.drawItemStack(yamiFruit, posX - 56, posY + 187, "");
                    }
                    this.drawItemStack(df, posX - 50, posY + 190, "");
                } else {
                    this.field_230706_i_.field_71466_p.func_238405_a_(matrixStack, "\u00a74\u00a7lUnknown Fruit\u00a7r", (float)(posX - 28), (float)(posY + 194), -1);
                }
            }
        }
        super.func_230430_a_(matrixStack, x, y, f);
    }

    public void func_231160_c_() {
        this.entityStatsProps = EntityStatsCapability.get((LivingEntity)this.player);
        this.devilFruitProps = DevilFruitCapability.get((LivingEntity)this.player);
        this.challengesProps = ChallengesDataCapability.get(this.player);
        IQuestData questProps = QuestDataCapability.get(this.player);
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)this.player);
        int posX = (this.field_230708_k_ - 256) / 2 - 110;
        int posY = (this.field_230709_l_ - 256) / 2;
        boolean hasAbilities = abilityProps.countUnlockedAbilities() > 0;
        PlankButton abilitiesButton = new PlankButton(posX += 80, posY + 210, 80, 26, (ITextComponent)new TranslationTextComponent(ModI18n.GUI_ABILITIES), b -> WyNetwork.sendToServer(new CRequestSyncAbilityDataPacket(true)));
        if (!hasAbilities) {
            abilitiesButton.field_230693_o_ = false;
        }
        this.func_230480_a_((Widget)abilitiesButton);
        if (this.hasQuests) {
            boolean hasQuests = this.questAmount > 0;
            PlankButton questsButton = new PlankButton(posX += 80, posY + 210, 80, 26, (ITextComponent)new TranslationTextComponent(ModI18n.GUI_QUESTS), b -> WyNetwork.sendToServer(new CRequestSyncQuestDataPacket(true)));
            if (!hasQuests) {
                questsButton.field_230693_o_ = false;
            }
            this.func_230480_a_((Widget)questsButton);
        }
        if (this.entityStatsProps.isPirate()) {
            PlankButton crewButton = new PlankButton(posX += 80, posY + 210, 80, 26, (ITextComponent)new TranslationTextComponent(ModI18n.GUI_CREW), b -> WyNetwork.sendToServer(new COpenCrewScreenPacket()));
            if (!this.hasCrew) {
                crewButton.field_230693_o_ = false;
            }
            this.func_230480_a_((Widget)crewButton);
        }
        if (this.hasChallenges || this.invites > 0) {
            boolean challengesAmountCheck = this.challengeAmount > 0 || this.invites > 0;
            posX += 80;
            Button.ITooltip tooltip = Button.field_238486_s_;
            if (!challengesAmountCheck) {
                tooltip = (btn, matrix, mouseX, mouseY) -> this.func_238654_b_(matrix, this.field_230706_i_.field_71466_p.func_238425_b_((ITextProperties)ModI18n.GUI_NO_CHALLENGES_AVAILABLE, Math.max(this.field_230708_k_ / 2 - 43, 170)), mouseX, mouseY);
            } else if (this.isInChallengeDimension) {
                tooltip = (btn, matrix, mouseX, mouseY) -> this.func_238654_b_(matrix, this.field_230706_i_.field_71466_p.func_238425_b_((ITextProperties)ModI18n.GUI_CHALLENGE_DIM_ACCESS_MENU, Math.max(this.field_230708_k_ / 2 - 43, 170)), mouseX, mouseY);
            } else if (this.isInCombat) {
                tooltip = (btn, matrix, mouseX, mouseY) -> this.func_238654_b_(matrix, this.field_230706_i_.field_71466_p.func_238425_b_((ITextProperties)ModI18n.GUI_COMBAT_CANNOT_USE, Math.max(this.field_230708_k_ / 2 - 43, 170)), mouseX, mouseY);
            }
            IFormattableTextComponent challengesMessage = ModI18n.GUI_CHALLENGES.func_230532_e_();
            if (this.invites > 0) {
                challengesMessage = challengesMessage.func_230529_a_((ITextComponent)new StringTextComponent(" (" + this.invites + ")"));
            }
            PlankButton challengesButton = new PlankButton(posX, posY + 210, 80, 26, (ITextComponent)challengesMessage, b -> WyNetwork.sendToServer(new COpenChallengesScreenPacket()), tooltip);
            if (!challengesAmountCheck || this.isInCombat || this.isInChallengeDimension) {
                challengesButton.field_230693_o_ = false;
            }
            this.func_230480_a_((Widget)challengesButton);
        }
    }

    public boolean func_231177_au__() {
        return false;
    }

    private void drawItemStack(ItemStack itemStack, int x, int y, String string) {
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_230707_j_.field_77023_b = 200.0f;
        FontRenderer font = null;
        if (itemStack != null) {
            font = itemStack.func_77973_b().getFontRenderer(itemStack);
        }
        if (font == null) {
            font = this.field_230712_o_;
        }
        this.field_230707_j_.func_175042_a(itemStack, x, y);
        this.field_230707_j_.field_77023_b = 0.0f;
    }

    public static void open(boolean hasQuests, int questAmount, boolean hasChallenges, int challengeAmount, boolean isInCombat, boolean isInChallengeDimension, int invites, boolean hasCrew) {
        Minecraft.func_71410_x().func_147108_a((Screen)new PlayerStatsScreen(hasQuests, questAmount, hasChallenges, challengeAmount, isInCombat, isInChallengeDimension, invites, hasCrew));
    }
}

