/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.EnchantmentNameParts;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.GuiUtils;
import xyz.pixelatedw.mineminenomi.api.quests.Quest;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.Objective;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.packets.client.quest.CAbandonQuestPacket;
import xyz.pixelatedw.mineminenomi.packets.client.quest.CStartObjectiveEventPacket;
import xyz.pixelatedw.mineminenomi.screens.extra.buttons.PlankButton;
import xyz.pixelatedw.mineminenomi.screens.extra.buttons.TexturedIconButton;
import xyz.pixelatedw.mineminenomi.wypi.WyDebug;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

@OnlyIn(value=Dist.CLIENT)
public class QuestsTrackerScreen
extends Screen {
    private PlayerEntity player;
    private IQuestData qprops;
    private int questIndex = 0;
    private List<String> hiddenTexts = new ArrayList<String>();
    private Quest currentQuest = null;
    private List<Quest> availableQuests;

    public QuestsTrackerScreen(PlayerEntity player) {
        super((ITextComponent)new StringTextComponent(""));
        this.player = player;
        this.qprops = QuestDataCapability.get(player);
        this.availableQuests = Arrays.asList(this.qprops.getInProgressQuests()).stream().filter(quest -> quest != null).collect(Collectors.toList());
    }

    public void func_230430_a_(MatrixStack matrixStack, int x, int y, float f) {
        double currentQuestProgress;
        this.func_230446_a_(matrixStack);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int posX = this.field_230708_k_ / 2;
        int posY = this.field_230709_l_ / 2;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ModResources.BLANK);
        RenderSystem.pushMatrix();
        double scale = 1.1;
        RenderSystem.translated((double)(posX - 35), (double)(posY + 10), (double)0.0);
        RenderSystem.translated((double)256.0, (double)256.0, (double)0.0);
        RenderSystem.scaled((double)(scale * 1.5), (double)(scale * 1.4), (double)0.0);
        RenderSystem.translated((double)-256.0, (double)-256.0, (double)0.0);
        GuiUtils.drawTexturedModalRect((int)0, (int)0, (int)0, (int)0, (int)256, (int)256, (float)1.0f);
        RenderSystem.translated((double)-30.0, (double)50.0, (double)0.0);
        RenderSystem.translated((double)256.0, (double)256.0, (double)0.0);
        RenderSystem.scaled((double)(scale * 0.7), (double)(scale * 0.9), (double)0.0);
        RenderSystem.translated((double)-256.0, (double)-256.0, (double)0.0);
        RenderSystem.popMatrix();
        String currentQuestName = this.currentQuest != null ? this.currentQuest.getCore().getLocalizedTitle() : "None";
        double d = currentQuestProgress = this.currentQuest != null ? this.currentQuest.getProgress() * 100.0 : -1.0;
        if (this.currentQuest != null) {
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)(posX + 150), (double)(posY - 110), (double)0.0);
            String pageNumber = this.questIndex + 1 + "/" + this.availableQuests.size();
            WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, pageNumber, 0, 0, WyHelper.hexToRGB("#FFFFFF").getRGB());
            RenderSystem.popMatrix();
            RenderSystem.pushMatrix();
            double scale2 = 1.4;
            RenderSystem.translated((double)(posX + 100), (double)(posY + 10), (double)0.0);
            RenderSystem.translated((double)256.0, (double)256.0, (double)0.0);
            RenderSystem.scaled((double)scale2, (double)scale2, (double)0.0);
            RenderSystem.translated((double)-256.0, (double)-256.0, (double)0.0);
            WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, currentQuestName, -this.field_230712_o_.func_78256_a(currentQuestName) / 2, 0, WyHelper.hexToRGB("#FFFFFF").getRGB());
            RenderSystem.popMatrix();
            if (currentQuestProgress != -1.0) {
                String textColor = "#FFFFFF";
                if (this.currentQuest.isComplete()) {
                    textColor = "#00FF55";
                }
                String progress = TextFormatting.BOLD + new TranslationTextComponent(ModI18n.GUI_QUEST_PROGRESS).getString() + " : " + String.format("%.1f", currentQuestProgress) + "%";
                WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, progress, posX - 120, posY - 65, WyHelper.hexToRGB(textColor).getRGB());
            }
            RenderSystem.pushMatrix();
            List avilableObjectives = this.currentQuest.getObjectives().stream().limit(5L).collect(Collectors.toList());
            int yOffset = -20;
            int i = 0;
            for (Objective obj : avilableObjectives) {
                String objectiveName = obj.getLocalizedTitle();
                double objectiveProgress = obj.getProgress() / obj.getMaxProgress() * 100.0;
                String progress = "";
                List hiddenObjs = avilableObjectives.stream().filter(o -> o.isHidden()).collect(Collectors.toList());
                yOffset += 20;
                String textColor = "#FFFFFF";
                if (obj.isComplete()) {
                    textColor = "#00FF00";
                }
                if (obj.isLocked()) {
                    textColor = "#505050";
                } else {
                    progress = "- " + String.format("%.1f", objectiveProgress) + "%";
                }
                if (obj.isHidden()) {
                    WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, "\u2022 ", posX - 130, posY - 45 + yOffset, WyHelper.hexToRGB(textColor).getRGB());
                    if (hiddenObjs.size() > 0) {
                        WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, this.hiddenTexts.get(hiddenObjs.indexOf(obj)), posX - 123, posY - 45 + yOffset, WyHelper.hexToRGB(textColor).getRGB());
                    }
                } else {
                    String optional = obj.isOptional() ? "(Optional) " : "";
                    objectiveName = "\u2022 " + optional + "" + objectiveName + " " + progress;
                    List splitText = this.field_230712_o_.func_238425_b_((ITextProperties)new StringTextComponent(objectiveName), 280);
                    for (int j = 0; j < splitText.size(); ++j) {
                        WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, (IReorderingProcessor)splitText.get(j), posX - 130, posY - 45 + yOffset + j * 12, WyHelper.hexToRGB(textColor).getRGB());
                    }
                    yOffset += splitText.size() * 8;
                }
                ++i;
            }
            if (i == 0) {
                WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, new TranslationTextComponent(ModI18n.TRAINER_NO_OBJECTIVES_LEFT).getString(), posX - 120, posY - 20 + yOffset, WyHelper.hexToRGB("#FFFFFF").getRGB());
            }
            RenderSystem.popMatrix();
        }
        super.func_230430_a_(matrixStack, x, y, f);
    }

    public void func_231160_c_() {
        this.field_230705_e_.clear();
        this.field_230710_m_.clear();
        int posX = (this.field_230708_k_ - 256) / 2;
        int posY = (this.field_230709_l_ - 256) / 2;
        try {
            this.currentQuest = this.qprops.getInProgressQuests()[this.questIndex];
        }
        catch (Exception e) {
            if (this.qprops.getInProgressQuests().length > 0) {
                this.currentQuest = this.qprops.getInProgressQuests()[0];
                WyDebug.debug(String.format("\n[ArrayOutOfBounds] \n Max possible index is : %s \n But the index requested is : %s", this.qprops.getInProgressQuests().length - 1, this.questIndex));
            } else {
                this.currentQuest = null;
            }
            this.questIndex = 0;
            e.printStackTrace();
        }
        if (this.currentQuest == null) {
            return;
        }
        this.hiddenTexts.clear();
        for (Objective obj : this.currentQuest.getObjectives()) {
            if (!obj.isHidden()) continue;
            this.hiddenTexts.add(EnchantmentNameParts.func_178176_a().func_238816_a_(Minecraft.func_71410_x().field_71466_p, obj.getTitle().length() * 2).getString());
        }
        TexturedIconButton nextButton = new TexturedIconButton(ModResources.BIG_WOOD_BUTTON_RIGHT, posX + 285, posY + 80, 24, 100, (ITextComponent)new StringTextComponent(""), btn -> {
            this.questIndex = this.questIndex + 1 < this.availableQuests.size() ? ++this.questIndex : 0;
            this.func_231160_c_();
        });
        nextButton = nextButton.setTextureInfo(posX + 280, posY + 35, 32, 128);
        if (this.availableQuests.size() <= 1) {
            nextButton.field_230694_p_ = false;
        }
        this.func_230480_a_((Widget)nextButton);
        TexturedIconButton prevButton = new TexturedIconButton(ModResources.BIG_WOOD_BUTTON_LEFT, posX - 55, posY + 80, 24, 100, (ITextComponent)new StringTextComponent(""), btn -> {
            this.questIndex = this.questIndex > 0 ? --this.questIndex : this.availableQuests.size() - 1;
            this.func_231160_c_();
        });
        prevButton = prevButton.setTextureInfo(posX - 58, posY + 35, 32, 128);
        if (this.availableQuests.size() <= 1) {
            prevButton.field_230694_p_ = false;
        }
        this.func_230480_a_((Widget)prevButton);
        PlankButton abandonQuestButton = new PlankButton(posX - 40, posY + 190, 80, 30, (ITextComponent)new TranslationTextComponent("Abandon"), btn -> {
            this.player.func_71053_j();
            if (this.currentQuest != null) {
                WyNetwork.sendToServer(new CAbandonQuestPacket(this.currentQuest.getCore()));
            }
        });
        this.func_230480_a_((Widget)abandonQuestButton);
        List avilableObjectives = this.currentQuest.getObjectives().stream().limit(5L).collect(Collectors.toList());
        int yOffset = -20;
        int objId = -1;
        for (Objective obj : avilableObjectives) {
            yOffset += 30;
            ++objId;
            if (!obj.hasEvent()) continue;
            String startText = obj.hasStartedEvent() ? "Restart Event" : "Start Event";
            int objId2 = objId;
            PlankButton startEventButton = new PlankButton(posX + 220, posY + 75 + yOffset, 80, 20, (ITextComponent)new StringTextComponent(startText), btn -> {
                this.player.func_71053_j();
                if (this.currentQuest != null) {
                    WyNetwork.sendToServer(new CStartObjectiveEventPacket(this.qprops.getInProgressQuestSlot(this.currentQuest), objId2));
                }
            });
            if (obj.isLocked()) {
                startEventButton.field_230694_p_ = false;
            }
            this.func_230480_a_((Widget)startEventButton);
        }
    }

    public boolean func_231177_au__() {
        return false;
    }
}

