/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.screens;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.INestedGuiEventHandler;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCoreUnlockWrapper;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PassiveAbility2;
import xyz.pixelatedw.mineminenomi.api.helpers.RendererHelper;
import xyz.pixelatedw.mineminenomi.config.ClientConfig;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.events.CombatModeEvents;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModKeybindings;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.packets.client.ability.CRemoveAbilityPacket;
import xyz.pixelatedw.mineminenomi.screens.extra.buttons.AbilitySlotButton;
import xyz.pixelatedw.mineminenomi.screens.extra.buttons.TexturedIconButton;
import xyz.pixelatedw.mineminenomi.screens.extra.panels.AbilitiesListScreenPanel;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

@OnlyIn(value=Dist.CLIENT)
public class SelectHotbarAbilitiesScreen<A extends IAbility>
extends Screen
implements INestedGuiEventHandler {
    private static final List<ITextComponent> EMPTY_TOOLTIPS = new ArrayList<ITextComponent>();
    protected PlayerEntity player;
    private AbilitiesListScreenPanel abilitiesList;
    public int groupSelected = 0;
    public int slotSelected = -1;
    public boolean isDirty;
    private int tickCount;
    private IAbilityData abilityDataProps;
    protected final List<AbilitySlotButton> abilitySlots = Lists.newArrayList();
    private static final Map<AbilityCore<? extends IAbility>, List<ITextComponent>> TOOLTIPS_CACHE = new HashMap<AbilityCore<? extends IAbility>, List<ITextComponent>>();
    private static final int TOOLTIP_BACKGROUND_START = WyHelper.hexToRGB("#A78342").getRGB();
    private static final int TOOLTIP_BACKGROUND_END = WyHelper.hexToRGB("#AD8F58").getRGB();
    private static final int TOOLTIP_BORDER_START = WyHelper.hexToRGB("#e3b160").getRGB();
    private static final int TOOLTIP_BORDER_END = WyHelper.hexToRGB("#cb7e23").getRGB();
    private static boolean hasStatsShown = false;
    private static boolean clearCache = false;

    public SelectHotbarAbilitiesScreen(PlayerEntity player) {
        super((ITextComponent)new StringTextComponent(""));
        this.player = player;
        this.field_230706_i_ = Minecraft.func_71410_x();
        this.abilityDataProps = AbilityDataCapability.get((LivingEntity)player);
    }

    public void func_230430_a_(MatrixStack matrixStack, int x, int y, float f) {
        this.func_230446_a_(matrixStack);
        int posX = this.field_230708_k_;
        int posY = this.field_230709_l_;
        this.field_230706_i_.func_110434_K().func_110577_a(ModResources.BOARD);
        this.func_230926_e_(this.func_230927_p_() + 100);
        this.func_238474_b_(matrixStack, (posX - 250) / 2, (posY - 230) / 2, 0, 0, 256, 256);
        this.func_238474_b_(matrixStack, (posX - 250) / 2, posY - 60, 0, 0, 256, 256);
        this.func_230926_e_(this.func_230927_p_() - 100);
        this.field_230706_i_.func_110434_K().func_110577_a(ModResources.BLANK_NEW);
        this.func_230926_e_(this.func_230927_p_() + 150);
        for (int i = 0; i < this.field_230710_m_.size(); ++i) {
            ((Widget)this.field_230710_m_.get(i)).func_230430_a_(matrixStack, x, y, f);
        }
        this.func_230926_e_(this.func_230927_p_() - 150);
        this.field_230706_i_.func_110434_K().func_110577_a(ModResources.BLANK_NEW);
        this.func_230926_e_(this.func_230927_p_() + 200);
        this.func_238474_b_(matrixStack, (posX - 250) / 2, (posY - 230) / 2, 0, 0, 256, 256);
        this.func_238474_b_(matrixStack, (posX - 250) / 2, posY - 60, 0, 0, 256, 256);
        this.func_230926_e_(this.func_230927_p_() - 200);
        String barId = 1 + this.groupSelected + "";
        matrixStack.func_227861_a_(0.0, 0.0, 250.0);
        WyHelper.drawStringWithBorder(this.field_230706_i_.field_71466_p, matrixStack, barId, (posX + 8) / 2 - (this.field_230706_i_.field_71466_p.func_78256_a(barId) + 104), posY - 24, 0xFFFFFF);
        matrixStack.func_227861_a_(0.0, 0.0, -250.0);
        if (this.abilitiesList != null) {
            this.abilitiesList.func_230430_a_(matrixStack, x, y, f);
        }
        this.func_230926_e_(this.func_230927_p_() + 150);
        for (int i = 0; i < this.abilitySlots.size(); ++i) {
            AbilitySlotButton slot = this.abilitySlots.get(i);
            slot.func_230430_a_(matrixStack, x, y, f);
        }
        this.func_230926_e_(this.func_230927_p_() - 150);
    }

    public void func_231160_c_() {
        int posX2 = this.field_230708_k_ / 2;
        int posY2 = this.field_230709_l_ / 2;
        TOOLTIPS_CACHE.clear();
        this.groupSelected = this.abilityDataProps.getCombatBarSet();
        this.updateSlots();
        int idx = 0;
        for (AbilityCategory category : AbilityCategory.values()) {
            AbilityCore core;
            if (category == AbilityCategory.ALL || (core = (AbilityCore)this.abilityDataProps.getUnlockedAbilities().stream().map(AbilityCoreUnlockWrapper::getAbilityCore).filter(category.isCorePartofCategory()).filter(AbilityCore::isVisible).findFirst().orElse(null)) == null) continue;
            boolean isFlipped = false;
            int iconOffset = 0;
            if (idx == 4) {
                posX2 += 250;
                posY2 -= 140;
            }
            if (idx >= 4) {
                isFlipped = true;
                iconOffset = 4;
            }
            int posY3 = posY2 - 100 + idx * 70 / 2;
            ResourceLocation icon = category.getIcon(this.player);
            if (icon == null) {
                Object abl = this.abilityDataProps.getEquippedOrPassiveAbility(core);
                icon = abl != null ? abl.getIcon((LivingEntity)this.player) : core.getIcon();
            }
            TexturedIconButton button = new TexturedIconButton(ModResources.BUTTON, posX2 - 145 + iconOffset, posY3, 40, 30, (ITextComponent)new StringTextComponent(""), btn -> this.updateListScreen(category));
            button = button.setTextureInfo(posX2 - 150, posY3 - 6, 55, 40).setFlipped(isFlipped).setIconInfo(icon, posX2 - 136 + iconOffset, posY3 + 2, 1.45);
            this.func_230480_a_((Widget)button);
            ++idx;
        }
        this.updateListScreen(AbilityCategory.DEVIL_FRUITS);
    }

    public void updateSlots() {
        int posX = this.field_230708_k_;
        int posY = this.field_230709_l_;
        this.slotSelected = -1;
        this.field_230710_m_.removeIf(w -> w instanceof AbilitySlotButton && this.abilitySlots.contains(w));
        this.field_230705_e_.removeIf(w -> w instanceof AbilitySlotButton && this.abilitySlots.contains(w));
        this.abilitySlots.clear();
        posX += 10;
        for (int i = 0; i < 8; ++i) {
            RenderSystem.enableBlend();
            int id = i + this.groupSelected * 8;
            Object abl = this.abilityDataProps.getEquippedAbility(id);
            AbilitySlotButton slotButton = new AbilitySlotButton((IAbility)abl, posX / 2 - 101 + i * 25, posY - 31, 22, 21, this.player, btn -> {
                if (this.slotSelected != id) {
                    this.slotSelected = id;
                    for (AbilitySlotButton slotBtn : this.abilitySlots) {
                        slotBtn.setIsPressed(false);
                    }
                    ((AbilitySlotButton)btn).setIsPressed(true);
                } else {
                    Object ability = this.abilityDataProps.getEquippedAbility(this.slotSelected);
                    if (ability == null) {
                        return;
                    }
                    if (ability.hasComponent(ModAbilityKeys.COOLDOWN) && ability.getComponent(ModAbilityKeys.COOLDOWN).get().isOnCooldown()) {
                        return;
                    }
                    if (ability.hasComponent(ModAbilityKeys.DISABLE) && ability.getComponent(ModAbilityKeys.DISABLE).get().isDisabled()) {
                        return;
                    }
                    if (ability.hasComponent(ModAbilityKeys.CONTINUOUS) && ability.getComponent(ModAbilityKeys.CONTINUOUS).get().isContinuous()) {
                        return;
                    }
                    if (ability.hasComponent(ModAbilityKeys.CHARGE) && ability.getComponent(ModAbilityKeys.CHARGE).get().isCharging()) {
                        return;
                    }
                    WyNetwork.sendToServer(new CRemoveAbilityPacket(this.slotSelected));
                    this.abilityDataProps.setEquippedAbility(this.slotSelected, null);
                    ((AbilitySlotButton)btn).setAbility(null);
                }
            });
            this.func_230481_d_((IGuiEventListener)slotButton);
            this.abilitySlots.add(slotButton);
        }
    }

    public void func_231023_e_() {
        if (this.isDirty && this.tickCount++ >= 1) {
            int i = 0;
            for (AbilitySlotButton slotBtn : this.abilitySlots) {
                int id = i + this.groupSelected * 8;
                Object abl = this.abilityDataProps.getEquippedAbility(id);
                slotBtn.setAbility((IAbility)abl);
                ++i;
            }
            this.isDirty = false;
            this.tickCount = 0;
        }
    }

    public boolean func_231046_a_(int key, int pScanCode, int pModifiers) {
        this.checkKeybinding(key);
        return super.func_231046_a_(key, pScanCode, pModifiers);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        this.checkKeybinding(button);
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    private void checkKeybinding(int key) {
        if (key == ModKeybindings.nextCombatBar.getKey().func_197937_c()) {
            this.groupSelected = this.groupSelected < CombatModeEvents.Client.ABILITY_BARS - 1 ? ++this.groupSelected : 0;
            this.updateSlots();
        } else if (key == ModKeybindings.prevCombatBar.getKey().func_197937_c()) {
            this.groupSelected = this.groupSelected > 0 ? --this.groupSelected : CombatModeEvents.Client.ABILITY_BARS - 1;
            this.updateSlots();
        }
    }

    public void updateListScreen(AbilityCategory category) {
        this.field_230705_e_.remove((Object)this.abilitiesList);
        this.abilitiesList = new AbilitiesListScreenPanel(this, this.abilityDataProps, category);
        this.field_230705_e_.add(this.abilitiesList);
        this.func_231035_a_((IGuiEventListener)this.abilitiesList);
    }

    private static List<ITextComponent> generateAbilityTooltip(IAbility ability) {
        boolean canShowAdvancedTooltips = Minecraft.func_71410_x().field_71474_y.field_82882_x;
        boolean canShowStats = !ClientConfig.INSTANCE.hidesAbilityStats() || ModKeybindings.isShiftKeyDown();
        Set<AbilityDescriptionLine> newSet = ability.getCore().getDescription();
        ArrayList<ITextComponent> tooltips = new ArrayList<ITextComponent>();
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        tooltips.add((ITextComponent)new StringTextComponent(ability.getDisplayName().getString() + (newSet != null && !newSet.isEmpty() ? "\n" : "")));
        if (newSet != null) {
            long advancedLines = newSet.stream().filter(line -> line.isAdvanced()).count();
            newSet.stream().filter(line -> !line.isAdvanced() || line.isAdvanced() && canShowStats).map(line -> line.getTextComponent((LivingEntity)player, ability)).map(text -> {
                if (text == null) {
                    return null;
                }
                try {
                    return TextComponentUtils.func_240645_a_(null, (ITextComponent)text, (Entity)player, (int)1);
                }
                catch (CommandSyntaxException e) {
                    e.printStackTrace();
                    return null;
                }
            }).filter(Objects::nonNull).forEach(tooltips::add);
            if (advancedLines > 0L && ClientConfig.INSTANCE.hidesAbilityStats() && !ModKeybindings.isShiftKeyDown()) {
                tooltips.add(AbilityDescriptionLine.NEW_LINE.expand((LivingEntity)player, ability));
                tooltips.add((ITextComponent)ModI18n.GUI_SHOW_ABILITY_STATS.func_230530_a_(Style.field_240709_b_.func_240722_b_(Boolean.valueOf(true)).func_240712_a_(TextFormatting.YELLOW)));
            }
        }
        if (canShowAdvancedTooltips) {
            ResourceLocation key;
            boolean isNew = false;
            if (ability instanceof Ability && ((Ability)ability).isNew) {
                isNew = true;
            } else if (ability instanceof PassiveAbility2) {
                isNew = true;
            }
            String color = "\u00a7c";
            if (isNew) {
                color = "\u00a77";
            }
            if ((key = ability.getCore().getRegistryName()) != null) {
                tooltips.add((ITextComponent)new StringTextComponent("\n" + color + key.toString()));
            }
        }
        return tooltips;
    }

    public static void renderAbilityTooltip(MatrixStack matrixStack, int mouseX, int mouseY, IAbility ability) {
        Minecraft mc = Minecraft.func_71410_x();
        MainWindow window = mc.func_228018_at_();
        if (ClientConfig.INSTANCE.hidesAbilityStats()) {
            if (ModKeybindings.isShiftKeyDown() && !hasStatsShown) {
                clearCache = true;
                hasStatsShown = true;
            } else if (!ModKeybindings.isShiftKeyDown() && hasStatsShown) {
                clearCache = true;
                hasStatsShown = false;
            }
            if (clearCache) {
                TOOLTIPS_CACHE.clear();
                clearCache = false;
            }
        }
        if (!TOOLTIPS_CACHE.containsKey(ability.getCore())) {
            TOOLTIPS_CACHE.putIfAbsent(ability.getCore(), SelectHotbarAbilitiesScreen.generateAbilityTooltip(ability));
        }
        List<ITextComponent> tooltips = TOOLTIPS_CACHE.getOrDefault(ability.getCore(), EMPTY_TOOLTIPS);
        RendererHelper.drawAbilityTooltip(ability, matrixStack, tooltips, mouseX, mouseY, window.func_198107_o(), window.func_198087_p(), 210, TOOLTIP_BACKGROUND_START, TOOLTIP_BACKGROUND_END, TOOLTIP_BORDER_START, TOOLTIP_BORDER_END, mc.field_71466_p);
        RenderSystem.enableBlend();
    }

    public void func_231175_as__() {
        super.func_231175_as__();
    }

    public boolean func_231177_au__() {
        return false;
    }
}

