/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.pixelatedw.mineminenomi.abilities.haki.KenbunshokuHakiAuraAbility;
import xyz.pixelatedw.mineminenomi.api.enums.HakiType;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.api.quests.QuestId;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.entities.mobs.quest.givers.DoctorTrainerEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.quest.givers.IHakiTrainer;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.packets.client.entity.CDoctorHealPacket;
import xyz.pixelatedw.mineminenomi.screens.extra.SequencedString;
import xyz.pixelatedw.mineminenomi.screens.extra.buttons.FactionButton;
import xyz.pixelatedw.mineminenomi.screens.extra.panels.AvailableQuestsListScreenPanel;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

@OnlyIn(value=Dist.CLIENT)
public class TrainerScreen
extends Screen {
    private PlayerEntity player;
    private IQuestData questData;
    private IHakiData hakiData;
    private IAbilityData abilityData;
    private List<QuestId> availableQuests = new ArrayList<QuestId>();
    private LivingEntity trainer;
    private float animationTime = 0.0f;
    private float animationTranslation = 100.0f;
    private int guiState = 0;
    private SequencedString startMessage = new SequencedString("", 0, 0);
    private AvailableQuestsListScreenPanel availableQuestsPanel;
    private boolean isInCombat;

    public TrainerScreen(PlayerEntity player, LivingEntity trainer, List<QuestId> availableQuests, boolean isInCombat) {
        super((ITextComponent)new StringTextComponent(""));
        this.player = player;
        this.questData = QuestDataCapability.get(player);
        this.hakiData = HakiDataCapability.get((LivingEntity)player);
        this.abilityData = AbilityDataCapability.get((LivingEntity)player);
        this.availableQuests = availableQuests;
        this.trainer = trainer;
        this.isInCombat = isInCombat;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        if (this.animationTime < 10.0f) {
            this.animationTime = (float)((double)this.animationTime + 0.2);
        }
        if (this.animationTranslation > 0.0f) {
            this.animationTranslation = 100.0f - this.animationTime * 40.0f;
        }
        int posX = this.field_230708_k_ / 2;
        int posY = this.field_230709_l_ / 2;
        switch (this.guiState) {
            case 0: {
                this.renderMenu(matrixStack, mouseX, mouseY, partialTicks);
                break;
            }
            case 1: {
                this.renderQuestList(matrixStack, mouseX, mouseY, partialTicks);
                break;
            }
            case 2: {
                this.renderMenu(matrixStack, mouseX, mouseY, partialTicks);
            }
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)this.animationTranslation, 0.0, 0.0);
        RenderSystem.enableBlend();
        InventoryScreen.func_228187_a_((int)(posX + 150), (int)(posY + 150), (int)100, (float)40.0f, (float)5.0f, (LivingEntity)this.trainer);
        matrixStack.func_227865_b_();
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public void renderMenu(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int posX = this.field_230708_k_ / 2;
        int posY = this.field_230709_l_ / 2;
        this.startMessage.render(matrixStack, posX - 150, posY - 105, partialTicks);
    }

    public void renderQuestList(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)(-this.animationTranslation), 0.0, 0.0);
        RenderSystem.enableBlend();
        this.availableQuestsPanel.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.availableQuestsPanel.func_231047_b_(mouseX, mouseY);
        matrixStack.func_227865_b_();
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public void func_231158_b_(Minecraft mc, int width, int height) {
        super.func_231158_b_(mc, width, height);
        int posX = this.field_230708_k_ / 2;
        int posY = this.field_230709_l_ / 2;
        if (this.guiState == 0) {
            FactionButton trialsListButton = new FactionButton(posX - 180, posY - 50, 100, 20, (ITextComponent)new TranslationTextComponent("Trials"), btn -> {
                boolean hasQuests = false;
                for (int i = 0; i <= this.availableQuests.size() - 1; ++i) {
                    QuestId quest = this.availableQuests.get(i);
                    if (this.questData.hasFinishedQuest(quest)) continue;
                    hasQuests = true;
                    break;
                }
                if (hasQuests) {
                    this.guiState = 1;
                    this.func_231158_b_(this.getMinecraft(), this.field_230708_k_, this.field_230709_l_);
                } else {
                    String message = new TranslationTextComponent(ModI18n.TRAINER_NO_TRIALS_AVAILABLE).getString();
                    this.startMessage = new SequencedString(message, 250, this.field_230712_o_.func_78256_a(message) / 2);
                }
            });
            this.func_230480_a_((Widget)trialsListButton);
            if (this.trainer instanceof IHakiTrainer) {
                FactionButton hakiTrainingButton = new FactionButton(posX - 180, posY - 20, 100, 20, (ITextComponent)new TranslationTextComponent("Haki Training"), btn -> {
                    boolean canLearnHaki;
                    boolean bl = canLearnHaki = EntityStatsCapability.get((LivingEntity)this.player).getDoriki() > 2000.0;
                    if (canLearnHaki) {
                        this.guiState = 2;
                        this.func_231158_b_(this.getMinecraft(), this.field_230708_k_, this.field_230709_l_);
                    } else {
                        String message = new TranslationTextComponent(ModI18n.TRAINER_CANT_LEARN_HAKI).getString();
                        this.startMessage = new SequencedString(message, 250, this.field_230712_o_.func_78256_a(message) / 2);
                    }
                });
                this.func_230480_a_((Widget)hakiTrainingButton);
            }
            if (this.trainer instanceof DoctorTrainerEntity) {
                int payment = (int)(this.player.func_110138_aP() - this.player.func_110143_aJ()) * 10;
                if (this.player.func_110138_aP() == this.player.func_110143_aJ()) {
                    payment = 0;
                }
                Button.ITooltip tooltip = Button.field_238486_s_;
                if (this.isInCombat) {
                    tooltip = (btn, matrix, mouseX, mouseY) -> this.func_238654_b_(matrix, this.field_230706_i_.field_71466_p.func_238425_b_((ITextProperties)ModI18n.GUI_COMBAT_CANNOT_USE, Math.max(this.field_230708_k_ / 2 - 43, 170)), mouseX, mouseY);
                }
                FactionButton healButton = new FactionButton(posX - 180, posY + 10, 100, 20, (ITextComponent)new TranslationTextComponent("Heal (%s belly)", new Object[]{payment}), btn -> {
                    if (this.player.func_110138_aP() != this.player.func_110143_aJ()) {
                        WyNetwork.sendToServer(new CDoctorHealPacket(this.player.func_145782_y()));
                        this.field_230706_i_.func_147108_a(null);
                    }
                }, tooltip);
                if (this.isInCombat) {
                    healButton.field_230693_o_ = false;
                }
                this.func_230480_a_((Widget)healButton);
            }
        } else if (this.guiState == 1) {
            this.availableQuestsPanel = new AvailableQuestsListScreenPanel(this, this.questData, this.availableQuests);
            this.field_230705_e_.add(this.availableQuestsPanel);
            this.func_231035_a_((IGuiEventListener)this.availableQuestsPanel);
            FactionButton backButton = new FactionButton(posX - 180, posY + 80, 200, 20, (ITextComponent)new TranslationTextComponent("gui.cancel"), btn -> {
                this.guiState = 0;
                this.func_231158_b_(this.getMinecraft(), this.field_230708_k_, this.field_230709_l_);
            });
            this.func_230480_a_((Widget)backButton);
        } else if (this.guiState == 2) {
            if (this.trainer instanceof IHakiTrainer) {
                String info = "";
                String tempMessage = "";
                HakiType type = ((IHakiTrainer)this.trainer).getTrainingHaki();
                if (type == HakiType.BUSOSHOKU) {
                    info = ModI18n.TRAINER_HOW_TO_BUSOSHOKU;
                    tempMessage = ModI18n.TRAINER_HOW_TO_BUSOSHOKU_MESSAGE;
                } else {
                    info = ModI18n.TRAINER_HOW_TO_OBSERVATION;
                    tempMessage = ModI18n.TRAINER_HOW_TO_OBSERVATION_MESSAGE;
                    if (this.abilityData.hasUnlockedAbility(KenbunshokuHakiAuraAbility.INSTANCE)) {
                        tempMessage = ModI18n.TRAINER_HOW_TO_OBSERVATION_MESSAGE_2;
                    }
                }
                String hakiTrainingMessage = tempMessage;
                FactionButton hakiInfoButton = new FactionButton(posX - 180, posY - 50, 200, 20, (ITextComponent)new TranslationTextComponent(info), btn -> {
                    String formattedMessage = new TranslationTextComponent(hakiTrainingMessage).getString();
                    this.startMessage = new SequencedString(formattedMessage, 250, this.field_230712_o_.func_78256_a(formattedMessage) / 3, 650);
                });
                this.func_230480_a_((Widget)hakiInfoButton);
                info = ModI18n.TRAINER_MY_HAKI;
                FactionButton checkHakiButton = new FactionButton(posX - 180, posY - 20, 200, 20, (ITextComponent)new TranslationTextComponent(info), btn -> {
                    String formattedMessage = new TranslationTextComponent(ModI18n.TRAINER_HAKI_RANK, new Object[]{HakiHelper.getHakiRank(type, (LivingEntity)this.player)}).getString();
                    this.startMessage = new SequencedString(formattedMessage, 250, this.field_230712_o_.func_78256_a(formattedMessage) / 3, 650);
                });
                this.func_230480_a_((Widget)checkHakiButton);
            }
            FactionButton backButton = new FactionButton(posX - 180, posY + 80, 200, 20, (ITextComponent)new TranslationTextComponent("gui.cancel"), btn -> {
                this.guiState = 0;
                this.func_231158_b_(this.getMinecraft(), this.field_230708_k_, this.field_230709_l_);
            });
            this.func_230480_a_((Widget)backButton);
        }
    }

    public boolean isAnimationComplete() {
        return this.animationTime >= 5.0f;
    }
}

