/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.screens.extra;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import xyz.pixelatedw.mineminenomi.abilities.CommandAbility;
import xyz.pixelatedw.mineminenomi.abilities.DummyAbility;
import xyz.pixelatedw.mineminenomi.abilities.artofweather.GustSwordAbility;
import xyz.pixelatedw.mineminenomi.abilities.artofweather.WeatherEggAbility;
import xyz.pixelatedw.mineminenomi.abilities.artofweather.tempos.CycloneTempo;
import xyz.pixelatedw.mineminenomi.abilities.artofweather.tempos.MirageTempo;
import xyz.pixelatedw.mineminenomi.abilities.artofweather.tempos.ThunderLanceTempo;
import xyz.pixelatedw.mineminenomi.abilities.artofweather.tempos.ThunderstormTempo;
import xyz.pixelatedw.mineminenomi.abilities.blackleg.AntiMannerKickCourseAbility;
import xyz.pixelatedw.mineminenomi.abilities.blackleg.BienCuitGrillShotAbility;
import xyz.pixelatedw.mineminenomi.abilities.blackleg.ConcasseAbility;
import xyz.pixelatedw.mineminenomi.abilities.blackleg.DiableJambeAbility;
import xyz.pixelatedw.mineminenomi.abilities.blackleg.PartyTableKickCourseAbility;
import xyz.pixelatedw.mineminenomi.abilities.blackleg.SkywalkAbility;
import xyz.pixelatedw.mineminenomi.abilities.brawler.GenkotsuMeteorAbility;
import xyz.pixelatedw.mineminenomi.abilities.brawler.HakaiHoAbility;
import xyz.pixelatedw.mineminenomi.abilities.brawler.JishinHoAbility;
import xyz.pixelatedw.mineminenomi.abilities.brawler.KingPunchAbility;
import xyz.pixelatedw.mineminenomi.abilities.brawler.SpinningBrawlAbility;
import xyz.pixelatedw.mineminenomi.abilities.brawler.SuplexAbility;
import xyz.pixelatedw.mineminenomi.abilities.cyborg.ColaOverdriveAbility;
import xyz.pixelatedw.mineminenomi.abilities.cyborg.CoupDeBooAbility;
import xyz.pixelatedw.mineminenomi.abilities.cyborg.CoupDeVentAbility;
import xyz.pixelatedw.mineminenomi.abilities.cyborg.FreshFireAbility;
import xyz.pixelatedw.mineminenomi.abilities.cyborg.RadicalBeamAbility;
import xyz.pixelatedw.mineminenomi.abilities.cyborg.StrongRightAbility;
import xyz.pixelatedw.mineminenomi.abilities.doctor.AntidoteShotAbility;
import xyz.pixelatedw.mineminenomi.abilities.doctor.DopingAbility;
import xyz.pixelatedw.mineminenomi.abilities.doctor.FailedExperimentAbility;
import xyz.pixelatedw.mineminenomi.abilities.doctor.FirstAidAbility;
import xyz.pixelatedw.mineminenomi.abilities.doctor.MedicBagExplosionAbility;
import xyz.pixelatedw.mineminenomi.abilities.doctor.VirusZoneAbility;
import xyz.pixelatedw.mineminenomi.abilities.electro.EleclawAbility;
import xyz.pixelatedw.mineminenomi.abilities.electro.ElectricalLunaAbility;
import xyz.pixelatedw.mineminenomi.abilities.electro.ElectricalMissileAbility;
import xyz.pixelatedw.mineminenomi.abilities.electro.ElectricalShowerAbility;
import xyz.pixelatedw.mineminenomi.abilities.electro.SulongAbility;
import xyz.pixelatedw.mineminenomi.abilities.fishmankarate.KachiageHaisokuAbility;
import xyz.pixelatedw.mineminenomi.abilities.fishmankarate.KarakusagawaraSeikenAbility;
import xyz.pixelatedw.mineminenomi.abilities.fishmankarate.SamehadaShoteiAbility;
import xyz.pixelatedw.mineminenomi.abilities.fishmankarate.TwoFishEngineAbility;
import xyz.pixelatedw.mineminenomi.abilities.fishmankarate.UchimizuAbility;
import xyz.pixelatedw.mineminenomi.abilities.fishmankarate.YarinamiAbility;
import xyz.pixelatedw.mineminenomi.abilities.marineloyalty.MusterAbility;
import xyz.pixelatedw.mineminenomi.abilities.marineloyalty.SmallMusterAbility;
import xyz.pixelatedw.mineminenomi.abilities.rokushiki.GeppoAbility;
import xyz.pixelatedw.mineminenomi.abilities.rokushiki.KamieAbility;
import xyz.pixelatedw.mineminenomi.abilities.rokushiki.RankyakuAbility;
import xyz.pixelatedw.mineminenomi.abilities.rokushiki.RokuoganAbility;
import xyz.pixelatedw.mineminenomi.abilities.rokushiki.SoruAbility;
import xyz.pixelatedw.mineminenomi.abilities.rokushiki.TekkaiAbility;
import xyz.pixelatedw.mineminenomi.abilities.sniper.HiNoToriBoshiAbility;
import xyz.pixelatedw.mineminenomi.abilities.sniper.KemuriBoshiAbility;
import xyz.pixelatedw.mineminenomi.abilities.sniper.NemuriBoshiAbility;
import xyz.pixelatedw.mineminenomi.abilities.sniper.SakuretsuSabotenBoshiAbility;
import xyz.pixelatedw.mineminenomi.abilities.sniper.TetsuBoshiAbility;
import xyz.pixelatedw.mineminenomi.abilities.sniper.TokuyoAburaBoshiAbility;
import xyz.pixelatedw.mineminenomi.abilities.swordsman.HiryuKaenAbility;
import xyz.pixelatedw.mineminenomi.abilities.swordsman.OTatsumakiAbility;
import xyz.pixelatedw.mineminenomi.abilities.swordsman.SanbyakurokujuPoundHoAbility;
import xyz.pixelatedw.mineminenomi.abilities.swordsman.ShiShishiSonsonAbility;
import xyz.pixelatedw.mineminenomi.abilities.swordsman.YakkodoriAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModResources;

public class CharacterCreatorSelectionMap {
    private static final AbilityCore<DummyAbility> CYBORG_ARMOR_PERK = new AbilityCore.Builder<DummyAbility>("Cyborg Armor", AbilityCategory.STYLE, AbilityType.PASSIVE, DummyAbility::new).setPhantomKey(new ResourceLocation("mineminenomi", "cyborg_armor")).setIcon(ModResources.PERK_ICON).addDescriptionLine(new ITextComponent[]{ModI18n.PERK_CYBORG_ARMOR_BONUS}).build();
    private static final AbilityCore<DummyAbility> FISHMAN_SWIM_SPEED_PERK = new AbilityCore.Builder<DummyAbility>("Fishman Swim Speed", AbilityCategory.STYLE, AbilityType.PASSIVE, DummyAbility::new).setPhantomKey(new ResourceLocation("mineminenomi", "fishman_swim_speed")).setIcon(ModResources.PERK_ICON).addDescriptionLine(new ITextComponent[]{ModI18n.PERK_FISHMAN_SWIM_SPEED_BONUS}).build();
    private static final AbilityCore<DummyAbility> MINK_SPEED_PERK = new AbilityCore.Builder<DummyAbility>("Mink Speed", AbilityCategory.STYLE, AbilityType.PASSIVE, DummyAbility::new).setPhantomKey(new ResourceLocation("mineminenomi", "mink_speed")).setIcon(ModResources.PERK_ICON).addDescriptionLine(new ITextComponent[]{ModI18n.PERK_MINK_SPEED_BONUS}).build();
    private static final AbilityCore<DummyAbility> MINK_JUMP_PERK = new AbilityCore.Builder<DummyAbility>("Mink Jump", AbilityCategory.STYLE, AbilityType.PASSIVE, DummyAbility::new).setPhantomKey(new ResourceLocation("mineminenomi", "mink_jump")).setIcon(ModResources.PERK_ICON).addDescriptionLine(new ITextComponent[]{ModI18n.PERK_MINK_JUMP_BONUS}).build();
    private static final AbilityCore<DummyAbility> SWORDSMAN_DAMAGE_PERK = new AbilityCore.Builder<DummyAbility>("Swordsman Damage", AbilityCategory.STYLE, AbilityType.PASSIVE, DummyAbility::new).setPhantomKey(new ResourceLocation("mineminenomi", "swordsman_damage")).setIcon(ModResources.PERK_ICON).addDescriptionLine(new ITextComponent[]{ModI18n.PERK_SWORDSMAN_DAMAGE_BONUS}).build();
    private static final AbilityCore<DummyAbility> SNIPER_ACCURACY_PERK = new AbilityCore.Builder<DummyAbility>("Sniper Accuracy", AbilityCategory.STYLE, AbilityType.PASSIVE, DummyAbility::new).setPhantomKey(new ResourceLocation("mineminenomi", "sniper_accuracy")).setIcon(ModResources.PERK_ICON).addDescriptionLine(new ITextComponent[]{ModI18n.PERK_SNIPER_ACCURACY_BONUS}).build();
    private static final AbilityCore<DummyAbility> SNIPER_GOGGLES_PERK = new AbilityCore.Builder<DummyAbility>("Sniper Goggles", AbilityCategory.STYLE, AbilityType.PASSIVE, DummyAbility::new).setPhantomKey(new ResourceLocation("mineminenomi", "sniper_goggles")).setIcon(ModResources.PERK_ICON).addDescriptionLine(new ITextComponent[]{ModI18n.PERK_SNIPER_GOGGLES_BONUS}).build();
    private static final AbilityCore<DummyAbility> BLACK_LEG_DAMAGE_PERK = new AbilityCore.Builder<DummyAbility>("Black Leg Damage", AbilityCategory.STYLE, AbilityType.PASSIVE, DummyAbility::new).setPhantomKey(new ResourceLocation("mineminenomi", "black_leg_damage")).setIcon(ModResources.PERK_ICON).addDescriptionLine(new ITextComponent[]{ModI18n.PERK_BLACK_LEG_DAMAGE_BONUS}).build();
    private static final AbilityCore<DummyAbility> BLACK_LEG_SPEED_PERK = new AbilityCore.Builder<DummyAbility>("Black Leg Attack Speed", AbilityCategory.STYLE, AbilityType.PASSIVE, DummyAbility::new).setPhantomKey(new ResourceLocation("mineminenomi", "black_leg_attack_speed")).setIcon(ModResources.PERK_ICON).addDescriptionLine(new ITextComponent[]{ModI18n.PERK_BLACK_LEG_ATTACK_SPEED_BONUS}).build();
    private static final AbilityCore<DummyAbility> BRAWLER_DAMAGE_PERK = new AbilityCore.Builder<DummyAbility>("Brawler Damage", AbilityCategory.STYLE, AbilityType.PASSIVE, DummyAbility::new).setPhantomKey(new ResourceLocation("mineminenomi", "brawler_damage")).setIcon(ModResources.PERK_ICON).addDescriptionLine(new ITextComponent[]{ModI18n.PERK_BRAWLER_DAMAGE_BONUS}).build();

    public static HashMap<String, SelectionInfo> createSelectionMap() {
        HashMap<String, SelectionInfo> map = new HashMap<String, SelectionInfo>();
        map.put("random", new SelectionInfo(ModResources.RANDOM, (ITextComponent)ModI18n.GUI_RANDOM));
        SelectionInfo pirateInfo = new SelectionInfo(ModResources.PIRATE_ICON, (ITextComponent)ModI18n.FACTION_PIRATE);
        SelectionInfo marineInfo = new SelectionInfo(ModResources.MARINE_ICON, (ITextComponent)ModI18n.FACTION_MARINE);
        marineInfo.addTopAbilities(SmallMusterAbility.INSTANCE, MusterAbility.INSTANCE, CommandAbility.INSTANCE);
        SelectionInfo bountyHunterInfo = new SelectionInfo(ModResources.BOUNTY_HUNTER_ICON, (ITextComponent)ModI18n.FACTION_BOUNTY_HUNTER);
        SelectionInfo revoInfo = new SelectionInfo(ModResources.REVOLUTIONARY_ARMY_ICON, (ITextComponent)ModI18n.FACTION_REVOLUTIONARY);
        map.put("pirate", pirateInfo);
        map.put("marine", marineInfo);
        map.put("bounty_hunter", bountyHunterInfo);
        map.put("revolutionary", revoInfo);
        SelectionInfo humanInfo = new SelectionInfo(ModResources.HUMAN, (ITextComponent)ModI18n.RACE_HUMAN);
        humanInfo.addTopAbilities(SoruAbility.INSTANCE, TekkaiAbility.INSTANCE, GeppoAbility.INSTANCE, KamieAbility.INSTANCE, RankyakuAbility.INSTANCE, RokuoganAbility.INSTANCE);
        SelectionInfo fishmanInfo = new SelectionInfo(ModResources.FISHMAN, (ITextComponent)ModI18n.RACE_FISHMAN);
        fishmanInfo.addTopAbilities(UchimizuAbility.INSTANCE, SamehadaShoteiAbility.INSTANCE, KachiageHaisokuAbility.INSTANCE, TwoFishEngineAbility.INSTANCE, YarinamiAbility.INSTANCE, KarakusagawaraSeikenAbility.INSTANCE);
        fishmanInfo.addBottomAbilities(FISHMAN_SWIM_SPEED_PERK);
        SelectionInfo cyborgInfo = new SelectionInfo(ModResources.CYBORG, (ITextComponent)ModI18n.RACE_CYBORG);
        cyborgInfo.addTopAbilities(StrongRightAbility.INSTANCE, RadicalBeamAbility.INSTANCE, CoupDeVentAbility.INSTANCE, FreshFireAbility.INSTANCE, CoupDeBooAbility.INSTANCE, ColaOverdriveAbility.INSTANCE);
        cyborgInfo.addBottomAbilities(CYBORG_ARMOR_PERK);
        SelectionInfo minkInfo = new SelectionInfo(ModResources.MINK1, (ITextComponent)ModI18n.RACE_MINK);
        minkInfo.addTopAbilities(EleclawAbility.INSTANCE, ElectricalShowerAbility.INSTANCE, ElectricalLunaAbility.INSTANCE, ElectricalMissileAbility.INSTANCE, SulongAbility.INSTANCE);
        minkInfo.addBottomAbilities(MINK_SPEED_PERK, MINK_JUMP_PERK);
        map.put("human", humanInfo);
        map.put("fishman", fishmanInfo);
        map.put("cyborg", cyborgInfo);
        map.put("mink", minkInfo);
        SelectionInfo swordsmanInfo = new SelectionInfo(ModResources.SWORDSMAN, (ITextComponent)ModI18n.STYLE_SWORDSMAN);
        swordsmanInfo.addTopAbilities(ShiShishiSonsonAbility.INSTANCE, YakkodoriAbility.INSTANCE, SanbyakurokujuPoundHoAbility.INSTANCE, OTatsumakiAbility.INSTANCE, HiryuKaenAbility.INSTANCE);
        swordsmanInfo.addBottomAbilities(SWORDSMAN_DAMAGE_PERK);
        SelectionInfo sniperInfo = new SelectionInfo(ModResources.SNIPER, (ITextComponent)ModI18n.STYLE_SNIPER);
        sniperInfo.addTopAbilities(HiNoToriBoshiAbility.INSTANCE, KemuriBoshiAbility.INSTANCE, NemuriBoshiAbility.INSTANCE, TokuyoAburaBoshiAbility.INSTANCE, TetsuBoshiAbility.INSTANCE, SakuretsuSabotenBoshiAbility.INSTANCE);
        sniperInfo.addBottomAbilities(SNIPER_ACCURACY_PERK, SNIPER_GOGGLES_PERK);
        SelectionInfo doctorInfo = new SelectionInfo(ModResources.DOCTOR, (ITextComponent)ModI18n.STYLE_DOCTOR);
        doctorInfo.addTopAbilities(FirstAidAbility.INSTANCE, FailedExperimentAbility.INSTANCE, DopingAbility.INSTANCE, VirusZoneAbility.INSTANCE, AntidoteShotAbility.INSTANCE, MedicBagExplosionAbility.INSTANCE);
        SelectionInfo artOfWeatherInfo = new SelectionInfo(ModResources.ART_OF_WEATHER, (ITextComponent)ModI18n.STYLE_ART_OF_WEATHER);
        artOfWeatherInfo.addTopAbilities(WeatherEggAbility.INSTANCE, ThunderstormTempo.INSTANCE, GustSwordAbility.INSTANCE, CycloneTempo.INSTANCE, MirageTempo.INSTANCE, ThunderLanceTempo.INSTANCE);
        SelectionInfo brawlerInfo = new SelectionInfo(ModResources.BRAWLER, (ITextComponent)ModI18n.STYLE_BRAWLER);
        brawlerInfo.addTopAbilities(SuplexAbility.INSTANCE, GenkotsuMeteorAbility.INSTANCE, SpinningBrawlAbility.INSTANCE, HakaiHoAbility.INSTANCE, JishinHoAbility.INSTANCE, KingPunchAbility.INSTANCE);
        brawlerInfo.addBottomAbilities(BRAWLER_DAMAGE_PERK);
        SelectionInfo blackLegInfo = new SelectionInfo(ModResources.BLACK_LEG, (ITextComponent)ModI18n.STYLE_BLACK_LEG);
        blackLegInfo.addTopAbilities(ConcasseAbility.INSTANCE, AntiMannerKickCourseAbility.INSTANCE, PartyTableKickCourseAbility.INSTANCE, SkywalkAbility.INSTANCE, DiableJambeAbility.INSTANCE, BienCuitGrillShotAbility.INSTANCE);
        blackLegInfo.addBottomAbilities(BLACK_LEG_DAMAGE_PERK, BLACK_LEG_SPEED_PERK);
        map.put("swordsman", swordsmanInfo);
        map.put("sniper", sniperInfo);
        map.put("doctor", doctorInfo);
        map.put("art_of_weather", artOfWeatherInfo);
        map.put("brawler", brawlerInfo);
        map.put("black_leg", blackLegInfo);
        return map;
    }

    public static class SelectionInfo {
        private ResourceLocation icon;
        private ITextComponent label;
        private List<AbilityCore<?>> topAbilities = new ArrayList();
        private List<AbilityCore<?>> bottomAbilities = new ArrayList();

        public SelectionInfo(ResourceLocation icon, ITextComponent label) {
            this.icon = icon;
            this.label = label;
        }

        public void addTopAbilities(AbilityCore<?> ... cores) {
            this.topAbilities.addAll(Lists.newArrayList((Object[])cores));
        }

        public void addBottomAbilities(AbilityCore<?> ... cores) {
            this.bottomAbilities.addAll(Lists.newArrayList((Object[])cores));
        }

        public ResourceLocation getIcon() {
            return this.icon;
        }

        public ITextComponent getLabel() {
            return this.label;
        }

        public List<AbilityCore<?>> getTopAbilities() {
            return this.topAbilities;
        }

        public List<AbilityCore<?>> getBottomAbilities() {
            return this.bottomAbilities;
        }
    }
}

