/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.screens.extra;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SequencedString {
    public String string;
    public int maxLength;
    public int color = Color.WHITE.getRGB();
    public char[] chars;
    public int maxTicks;
    public int tickCount;
    public Minecraft mc;
    public int delayTicks = this.maxTicks;

    public SequencedString(String str, int maxLength, int maxTicks) {
        this(str, maxLength, maxTicks, maxTicks + 100);
    }

    public SequencedString(String str, int maxLength, int maxTicks, int delay) {
        this.mc = Minecraft.func_71410_x();
        this.string = str;
        this.maxLength = maxLength;
        this.chars = new char[this.string.length()];
        for (int i = 0; i < this.string.length(); ++i) {
            this.chars[i] = this.string.charAt(i);
        }
        this.maxTicks = maxTicks;
        this.tickCount = 0;
        this.delayTicks = delay;
    }

    public void render(MatrixStack matrixStack, int posX, int posY, float partialTicks) {
        String tempStr = "";
        for (int i = 0; i < this.chars.length; ++i) {
            if (this.tickCount < this.calculateTicksNeeded(i) || !((float)this.tickCount * partialTicks < (float)this.delayTicks)) continue;
            tempStr = tempStr + this.chars[i];
        }
        List strings = this.mc.field_71466_p.func_238425_b_((ITextProperties)new StringTextComponent(tempStr), this.maxLength);
        for (int b = 0; b < strings.size(); ++b) {
            WyHelper.drawStringWithBorder(this.mc.field_71466_p, matrixStack, (IReorderingProcessor)strings.get(b), posX, posY + 10 * b, this.color);
        }
        ++this.tickCount;
    }

    public int calculateTicksNeeded(int index) {
        int oldRange = this.string.length();
        int newRange = this.maxTicks;
        int newValue = index * newRange / oldRange;
        return newValue;
    }
}

