/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.screens.extra.panels;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.client.gui.ScrollPanel;
import xyz.pixelatedw.mineminenomi.api.challenges.Challenge;
import xyz.pixelatedw.mineminenomi.screens.ChallengesScreen;
import xyz.pixelatedw.mineminenomi.screens.extra.buttons.PlankButton;

public class AvailableChallengesListPanel
extends ScrollPanel {
    private static final int ENTRY_HEIGHT = 36;
    private final ChallengesScreen parent;
    private final List<Challenge> displayedChallenges;

    public AvailableChallengesListPanel(ChallengesScreen parent, List<Challenge> list) {
        super(parent.getMinecraft(), 170, 210, parent.field_230709_l_ / 2 - 90, parent.field_230708_k_ / 2 - 245);
        this.parent = parent;
        this.displayedChallenges = list;
    }

    public boolean func_231048_c_(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        return false;
    }

    protected int getContentHeight() {
        return this.displayedChallenges.size() * 36 - 2;
    }

    protected int getScrollAmount() {
        return 12;
    }

    protected void drawGradientRect(MatrixStack matrixStack, int left, int top, int right, int bottom, int color1, int color2) {
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    protected void drawPanel(MatrixStack matrixStack, int entryRight, int relativeY, Tessellator tess, int mouseX, int mouseY) {
        int y = relativeY;
        int x = this.parent.field_230708_k_ / 2 - 280 + 40;
        int yOffset = 0;
        for (Challenge ch : this.displayedChallenges) {
            PlankButton challengeButton = new PlankButton(x, y + yOffset, 160, 31, (ITextComponent)ch.getCore().getLocalizedTitle(), btn -> {});
            if (this.parent.getSelectedChallenge() != null && this.parent.getSelectedChallenge().equals(ch)) {
                challengeButton.field_230693_o_ = false;
            }
            if (ch.isComplete()) {
                challengeButton.setFGColor(Color.YELLOW.getRGB());
            }
            challengeButton.func_230430_a_(matrixStack, mouseX, mouseY, 0.0f);
            yOffset += 36;
        }
    }

    private Challenge findEntry(int mouseX, int mouseY) {
        double offset = (float)(mouseY - this.top) + this.scrollDistance;
        if (offset <= 0.0) {
            return null;
        }
        int lineIdx = (int)(offset / 36.0);
        if (lineIdx >= this.displayedChallenges.size()) {
            return null;
        }
        Challenge entry = this.displayedChallenges.get(lineIdx);
        if (entry != null) {
            return entry;
        }
        return null;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        Challenge ch = this.findEntry((int)mouseX, (int)mouseY);
        if (ch != null && this.func_231047_b_(mouseX, mouseY) && button == 0) {
            boolean isAlreadySelected;
            boolean bl = isAlreadySelected = this.parent.getSelectedChallenge() != null && this.parent.getSelectedChallenge().equals(ch);
            if (!isAlreadySelected) {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                this.parent.startInfoPanelAnimation();
                this.parent.setSelectedChallenge(ch);
            }
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231047_b_(double mouseX, double mouseY) {
        return mouseX >= (double)this.left && mouseY >= (double)this.top && mouseX < (double)(this.left + this.width - 5) && mouseY < (double)(this.top + this.height);
    }
}

