/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.screens.extra.panels;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.gui.ScrollPanel;
import org.lwjgl.opengl.GL11;
import xyz.pixelatedw.mineminenomi.api.quests.Quest;
import xyz.pixelatedw.mineminenomi.api.quests.QuestId;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.packets.client.quest.CUpdateQuestStatePacket;
import xyz.pixelatedw.mineminenomi.screens.TrainerScreen;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class AvailableQuestsListScreenPanel
extends ScrollPanel {
    private TrainerScreen parent;
    private IQuestData props;
    private List<QuestId> availableQuests = new ArrayList<QuestId>();
    private static final int ENTRY_HEIGHT = 20;
    private FontRenderer font;

    public AvailableQuestsListScreenPanel(TrainerScreen parent, IQuestData abilityProps, List<QuestId> quests) {
        super(parent.getMinecraft(), 200, 180, parent.field_230709_l_ / 2 - 110, parent.field_230708_k_ / 2 - 190);
        this.parent = parent;
        this.props = abilityProps;
        Minecraft parentMinecraft = parent.getMinecraft();
        this.font = parentMinecraft.field_71466_p;
        this.updateAvailableQuests(quests);
        this.scrollDistance = -10.0f;
    }

    public void updateAvailableQuests(List<QuestId> quests) {
        ArrayList<QuestId> prevQuests = new ArrayList<QuestId>();
        prevQuests.addAll(quests);
        this.availableQuests.clear();
        for (int i = 0; i <= prevQuests.size() - 1; ++i) {
            boolean isNotInProgress;
            QuestId quest = (QuestId)((Object)prevQuests.get(i));
            boolean exists = quest != null;
            boolean isNotFinished = exists && !this.props.hasFinishedQuest(quest);
            boolean bl = isNotInProgress = exists && (this.props.getInProgressQuest(quest) == null || this.props.getInProgressQuest(quest) != null && ((Quest)((Object)this.props.getInProgressQuest(quest))).isComplete());
            if (!isNotFinished || !isNotInProgress) continue;
            this.availableQuests.add(quest);
        }
    }

    public boolean func_231048_c_(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        return true;
    }

    protected int getContentHeight() {
        return (int)((double)this.availableQuests.size() * 55.0 - 2.0);
    }

    protected int getScrollAmount() {
        return 12;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Tessellator tess = Tessellator.func_178181_a();
        double scale = this.parent.getMinecraft().func_228018_at_().func_198100_s();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)((double)this.left * scale)), (int)((int)((double)this.parent.getMinecraft().func_228018_at_().func_198091_l() - (double)this.bottom * scale)), (int)((int)((double)this.width * scale)), (int)((int)((double)this.height * scale)));
        int baseY = this.top + 4 - (int)this.scrollDistance;
        this.drawPanel(matrixStack, this.right, baseY, tess, mouseX, mouseY);
        GL11.glDisable((int)3089);
    }

    protected void drawPanel(MatrixStack matrixStack, int entryRight, int relativeY, Tessellator tess, int mouseX, int mouseY) {
        for (QuestId quest : this.availableQuests) {
            if (quest == null) continue;
            float y = relativeY;
            float x = this.parent.field_230708_k_ / 2 - 109 + 40;
            String formattedQuestName = quest.getLocalizedTitle();
            String questColor = "#FFFFFF";
            QuestId inProgressQuest = this.props.getInProgressQuest(quest);
            if (inProgressQuest != null) {
                if (this.isMouseOverQuest(mouseX, mouseY, quest) && !((Quest)((Object)inProgressQuest)).isComplete()) {
                    formattedQuestName = new TranslationTextComponent(ModI18n.TRAINER_NO_QUESTS_AVAILABLE).getString();
                }
                if (((Quest)((Object)inProgressQuest)).isComplete()) {
                    questColor = "#00FF55";
                }
            }
            if (quest.isLocked(this.props)) {
                questColor = "#505050";
            }
            if (this.parent.isAnimationComplete() && this.isMouseOverQuest(mouseX, mouseY, quest)) {
                RenderSystem.color3f((float)0.8f, (float)0.8f, (float)0.8f);
            }
            RenderSystem.pushMatrix();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(ModResources.SCROLL);
            double scale = 0.5;
            RenderSystem.translated((double)(x - 180.0f), (double)(y - 196.0f), (double)0.0);
            RenderSystem.translated((double)256.0, (double)256.0, (double)0.0);
            RenderSystem.scaled((double)(scale * 1.5), (double)(scale * 0.6), (double)0.0);
            RenderSystem.translated((double)-256.0, (double)-256.0, (double)0.0);
            this.func_238474_b_(matrixStack, 0, 0, 0, 0, 256, 256);
            RenderSystem.popMatrix();
            if (this.parent.isAnimationComplete()) {
                RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (this.font.func_78256_a(formattedQuestName) > 140) {
                RenderSystem.pushMatrix();
                List splittedText = this.font.func_238425_b_((ITextProperties)new StringTextComponent(formattedQuestName), 140);
                RenderSystem.translated((double)0.0, (double)(-((splittedText.size() - 1) * 5)), (double)0.0);
                for (IReorderingProcessor string : splittedText) {
                    WyHelper.drawStringWithBorder(this.font, matrixStack, string, (int)x - 80, (int)y + 16, WyHelper.hexToRGB(questColor).getRGB());
                    y += 10.0f;
                }
                RenderSystem.popMatrix();
            } else {
                WyHelper.drawStringWithBorder(this.font, matrixStack, formattedQuestName, (int)x - 80, (int)y + 16, WyHelper.hexToRGB(questColor).getRGB());
            }
            relativeY = (int)((double)relativeY + 55.0);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        QuestId quest = this.findQuestEntry((int)mouseX, (int)mouseY);
        if (button != 0) {
            return false;
        }
        QuestId inprogressQuest = this.props.getInProgressQuest(quest);
        if (quest != null && inprogressQuest != null && ((Quest)((Object)inprogressQuest)).isComplete()) {
            WyNetwork.sendToServer(new CUpdateQuestStatePacket(quest));
            this.availableQuests.remove((Object)quest);
        } else if (quest != null && !quest.isLocked(this.props)) {
            WyNetwork.sendToServer(new CUpdateQuestStatePacket(quest));
            this.availableQuests.remove((Object)quest);
        }
        this.updateAvailableQuests(this.availableQuests);
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean isMouseOverQuest(double mouseX, double mouseY, QuestId overQuest) {
        QuestId quest = this.findQuestEntry((int)mouseX, (int)mouseY);
        if (quest != null && ((Object)((Object)quest)).equals((Object)overQuest)) {
            return super.func_231047_b_(mouseX, mouseY);
        }
        return false;
    }

    @Nullable
    private QuestId findQuestEntry(int mouseX, int mouseY) {
        boolean isHovered;
        double offset = (float)(mouseY - this.top) + this.scrollDistance;
        boolean bl = isHovered = mouseX >= this.left && mouseY >= this.top && mouseX < this.left + this.width - 5 && mouseY < this.top + this.height;
        if (offset <= 0.0 || !isHovered) {
            return null;
        }
        int lineIdx = (int)(offset / 55.0);
        if (lineIdx >= this.availableQuests.size()) {
            return null;
        }
        QuestId quest = this.availableQuests.get(lineIdx);
        if (quest != null) {
            return quest;
        }
        return null;
    }
}

