/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.world.features.structures.battleship.marine;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import xyz.pixelatedw.mineminenomi.api.enums.CanvasSize;
import xyz.pixelatedw.mineminenomi.api.helpers.StructuresHelper;
import xyz.pixelatedw.mineminenomi.blocks.FlagBlock;
import xyz.pixelatedw.mineminenomi.blocks.WantedPosterBlock;
import xyz.pixelatedw.mineminenomi.blocks.tileentities.FlagTileEntity;
import xyz.pixelatedw.mineminenomi.blocks.tileentities.WantedPosterTileEntity;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModLootTables;
import xyz.pixelatedw.mineminenomi.init.ModStructures;

public class MarineBattleshipPiece
extends TemplateStructurePiece {
    private ResourceLocation resourceLocation;
    private Rotation rotation;
    private Set<String> posters = new HashSet<String>();

    public MarineBattleshipPiece(TemplateManager template, CompoundNBT nbt) {
        super(ModStructures.Pieces.MARINE_BATTLESHIP_PIECE, nbt);
        this.resourceLocation = new ResourceLocation(nbt.func_74779_i("Template"));
        this.rotation = Rotation.valueOf((String)nbt.func_74779_i("Rot"));
        this.build(template);
    }

    public MarineBattleshipPiece(TemplateManager template, BlockPos pos, Rotation rot) {
        super(ModStructures.Pieces.MARINE_BATTLESHIP_PIECE, 0);
        this.rotation = rot;
        this.field_186178_c = pos;
        this.resourceLocation = new ResourceLocation("mineminenomi", "marine/battle_ship");
        this.build(template);
    }

    protected void func_143011_b(CompoundNBT nbt) {
        super.func_143011_b(nbt);
        nbt.func_74778_a("Template", this.resourceLocation.toString());
        nbt.func_74778_a("Rot", this.rotation.name());
    }

    private void build(TemplateManager templateManager) {
        Template template = templateManager.func_200220_a(this.resourceLocation);
        PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215206_c);
        this.func_186173_a(template, this.field_186178_c, placementsettings);
    }

    protected void func_186175_a(String function, BlockPos pos, IServerWorld world, Random rand, MutableBoundingBox sbb) {
        TileEntity flagTile;
        BlockState state;
        if (function.equals("supplies_chest")) {
            StructuresHelper.spawnLoot((IWorld)world, pos, ModLootTables.LARGE_MARINE_SHIP_SUPPLIES_CHEST);
        }
        if (function.equals("captain_chest")) {
            StructuresHelper.spawnLoot((IWorld)world, pos, ModLootTables.LARGE_MARINE_SHIP_CAPTAIN_CHEST);
        }
        if (function.equals("rum_chest")) {
            StructuresHelper.spawnLoot((IWorld)world, pos, ModLootTables.LARGE_MARINE_SHIP_RUM_CHEST);
        }
        if (function.equals("deck_spawn")) {
            StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.MARINE, StructuresHelper.StructureSpawnType.GRUNT, 15);
        }
        if (function.equals("back_deck_spawn")) {
            StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.MARINE, StructuresHelper.StructureSpawnType.BRUTE, 5);
        }
        if (function.equals("tower_spawn")) {
            StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.MARINE, StructuresHelper.StructureSpawnType.SNIPER, 2);
        }
        if (function.equals("cannons_spawn_1")) {
            StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.MARINE, StructuresHelper.StructureSpawnType.GRUNT, 7);
        }
        if (function.equals("cannons_spawn_2")) {
            StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.MARINE, StructuresHelper.StructureSpawnType.BRUTE, 3);
        }
        if (function.equals("captain_room_spawn")) {
            StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.MARINE, StructuresHelper.StructureSpawnType.CAPTAIN, 1);
        }
        Rotation rot = this.field_186177_b.func_186215_c();
        if (function.startsWith("wanted_poster_")) {
            ExtendedWorldData worldData = ExtendedWorldData.get();
            Optional<Map.Entry<String, Long>> bounty = worldData.getAllBounties().entrySet().stream().findAny();
            this.generateWantedPoster(world, pos, rot, Direction.SOUTH, bounty);
        }
        if (function.equals("flag")) {
            state = ((Block)ModBlocks.FLAG.get()).func_176223_P();
            state = (BlockState)state.func_206870_a((Property)WantedPosterBlock.FACING, (Comparable)rot.func_185831_a(Direction.SOUTH));
            state = (BlockState)state.func_206870_a(FlagBlock.SIZE, (Comparable)((Object)CanvasSize.HUGE));
            world.func_180501_a(pos, state, 3);
            FlagBlock.placeSubs((IWorld)world, pos, state, false);
            flagTile = world.func_175625_s(pos);
            if (flagTile != null && flagTile instanceof FlagTileEntity) {
                ((FlagTileEntity)flagTile).setFaction("marine");
            }
        }
        if (function.equals("flag2")) {
            state = ((Block)ModBlocks.FLAG.get()).func_176223_P();
            state = (BlockState)state.func_206870_a((Property)WantedPosterBlock.FACING, (Comparable)rot.func_185831_a(Direction.SOUTH));
            state = (BlockState)state.func_206870_a(FlagBlock.SIZE, (Comparable)((Object)CanvasSize.LARGE));
            world.func_180501_a(pos, state, 3);
            FlagBlock.placeSubs((IWorld)world, pos, state, false);
            flagTile = world.func_175625_s(pos);
            if (flagTile != null && flagTile instanceof FlagTileEntity) {
                ((FlagTileEntity)flagTile).setFaction("marine");
            }
        }
    }

    private void generateWantedPoster(IServerWorld world, BlockPos pos, Rotation rot, Direction dir, Optional<Map.Entry<String, Long>> bounty) {
        if (world.func_201670_d()) {
            return;
        }
        if (!world.func_201674_k().nextBoolean()) {
            return;
        }
        if (bounty.isPresent()) {
            String key = bounty.get().getKey();
            if (this.posters.contains(key)) {
                world.func_180501_a(pos, ((Block)ModBlocks.STRUCTURE_AIR.get()).func_176223_P(), 3);
                return;
            }
            BlockState state = ((Block)ModBlocks.WANTED_POSTER.get()).func_176223_P();
            state = (BlockState)state.func_206870_a((Property)WantedPosterBlock.FACING, (Comparable)rot.func_185831_a(dir));
            world.func_180501_a(pos, state, 2);
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof WantedPosterTileEntity) {
                ((WantedPosterTileEntity)tile).setUUID(key);
                ((WantedPosterTileEntity)tile).setPosterBounty(bounty.get().getValue() + "");
                ((WantedPosterTileEntity)tile).func_70296_d();
            }
            this.posters.add(key);
        } else {
            world.func_180501_a(pos, ((Block)ModBlocks.STRUCTURE_AIR.get()).func_176223_P(), 3);
        }
    }
}

