/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.world.features.structures.largebase.bandit;

import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import xyz.pixelatedw.mineminenomi.api.helpers.StructuresHelper;
import xyz.pixelatedw.mineminenomi.init.ModLootTables;
import xyz.pixelatedw.mineminenomi.init.ModStructures;

public class BanditLargeBasePiece
extends TemplateStructurePiece {
    private ResourceLocation resourceLocation;
    private Rotation rotation;

    public BanditLargeBasePiece(TemplateManager template, CompoundNBT nbt) {
        super(ModStructures.Pieces.BANDIT_LARGE_BASE_PIECE, nbt);
        this.resourceLocation = new ResourceLocation(nbt.func_74779_i("Template"));
        this.rotation = Rotation.valueOf((String)nbt.func_74779_i("Rot"));
        this.build(template);
    }

    public BanditLargeBasePiece(TemplateManager template, BlockPos pos, Rotation rot) {
        super(ModStructures.Pieces.BANDIT_LARGE_BASE_PIECE, 0);
        this.field_186178_c = pos;
        this.rotation = rot;
        this.resourceLocation = new ResourceLocation("mineminenomi", "bandit/large_base");
        this.build(template);
    }

    protected void func_143011_b(CompoundNBT nbt) {
        super.func_143011_b(nbt);
        nbt.func_74778_a("Template", this.resourceLocation.toString());
        nbt.func_74778_a("Rot", this.rotation.name());
    }

    private void build(TemplateManager templateManager) {
        Template template = templateManager.func_200220_a(this.resourceLocation);
        PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
        this.func_186173_a(template, this.field_186178_c, placementsettings);
    }

    protected void func_186175_a(String function, BlockPos pos, IServerWorld world, Random rand, MutableBoundingBox sbb) {
        if (function.equals("tower_supplies")) {
            StructuresHelper.spawnLoot((IWorld)world, pos, ModLootTables.LARGE_BANDIT_BASE_TOWER_CHEST);
        }
        if (function.equals("tent_supplies")) {
            StructuresHelper.spawnLoot((IWorld)world, pos, ModLootTables.LARGE_BANDIT_BASE_TENT_CHEST);
        }
        if (function.equals("secret_stash")) {
            StructuresHelper.spawnLoot((IWorld)world, pos, ModLootTables.LARGE_BANDIT_BASE_SECRET_STASH_CHEST);
        }
        if (function.equals("kitchen_supplies")) {
            StructuresHelper.spawnLoot((IWorld)world, pos, ModLootTables.LARGE_BANDIT_BASE_FOOD_CHEST);
        }
        if (function.equals("dorm_supplies")) {
            StructuresHelper.spawnLoot((IWorld)world, pos, ModLootTables.LARGE_BANDIT_BASE_DORM_CHEST);
        }
        if (function.equals("tent_spawn")) {
            StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.BANDIT, StructuresHelper.StructureSpawnType.GRUNT, 2);
        }
        if (function.equals("back_spawn")) {
            StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.BANDIT, StructuresHelper.StructureSpawnType.GRUNT, 6);
        }
        if (function.equals("tower_spawn")) {
            StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.BANDIT, StructuresHelper.StructureSpawnType.SNIPER, 1);
        }
        if (function.equals("main_tower_spawn")) {
            StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.BANDIT, StructuresHelper.StructureSpawnType.SNIPER, 3);
        }
        if (function.equals("court_spawn")) {
            StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.BANDIT, StructuresHelper.StructureSpawnType.GRUNT, 10);
        }
        if (function.equals("storage_spawn")) {
            StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.BANDIT, StructuresHelper.StructureSpawnType.CAPTAIN, 3);
        }
        if (function.equals("kitchen_spawn")) {
            StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.BANDIT, StructuresHelper.StructureSpawnType.BRUTE, 3);
        }
        if (function.equals("bedroom_spawn")) {
            StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.BANDIT, StructuresHelper.StructureSpawnType.BRUTE, 3);
        }
    }

    public boolean func_230383_a_(ISeedReader world, StructureManager pStructureManager, ChunkGenerator pChunkGenerator, Random pRandom, MutableBoundingBox pBox, ChunkPos pChunkPos, BlockPos pPos) {
        BlockPos ogPos = this.field_186178_c;
        this.field_186178_c = this.field_186178_c.func_177982_a(0, -1, 0);
        boolean flag = super.func_230383_a_(world, pStructureManager, pChunkGenerator, pRandom, pBox, pChunkPos, pPos);
        this.field_186178_c = ogPos;
        return flag;
    }
}

