/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.world.features.structures.largebase.marine;

import net.minecraft.block.BlockState;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.StructuresHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.world.features.structures.OPStructure;
import xyz.pixelatedw.mineminenomi.world.features.structures.largebase.marine.MarineLargeBasePieces;
import xyz.pixelatedw.mineminenomi.wypi.WyDebug;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class MarineLargeBaseStructure
extends OPStructure<NoFeatureConfig> {
    public MarineLargeBaseStructure() {
        super(NoFeatureConfig.field_236558_a_);
    }

    @Override
    public boolean biomeCheck(BiomeLoadingEvent event) {
        boolean canSpawn = CommonConfig.INSTANCE.canSpawnLargeBases();
        return event.getCategory() != Biome.Category.OCEAN && canSpawn;
    }

    @Override
    public StructuresHelper.StructureFaction getFaction() {
        return StructuresHelper.StructureFaction.MARINE;
    }

    protected boolean isFeatureChunk(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig featureConfig) {
        boolean isChance;
        boolean superFlag = super.func_230363_a_(chunkGenerator, biomeSource, seed, chunkRandom, chunkX, chunkZ, biome, chunkPos, featureConfig);
        boolean bl = isChance = MathHelper.func_151237_a((double)(WyHelper.randomWithRange(0, 100) + WyHelper.randomDouble()), (double)0.0, (double)100.0) < CommonConfig.INSTANCE.getChanceForLargeBasesSpawn();
        if (!superFlag || !isChance) {
            return false;
        }
        boolean isSolidGround = true;
        int minY = 0;
        int maxY = 0;
        block0: for (int i = 0; i < 3 && isSolidGround; ++i) {
            for (int j = 0; j < 3; ++j) {
                BlockPos centerOfChunk = new BlockPos((chunkX + i << 4) + 7, 0, (chunkZ + j << 4) + 7);
                int landHeight = chunkGenerator.func_222531_c(centerOfChunk.func_177958_n(), centerOfChunk.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
                IBlockReader columnOfBlocks = chunkGenerator.func_230348_a_(centerOfChunk.func_177958_n(), centerOfChunk.func_177952_p());
                BlockState state = columnOfBlocks.func_180495_p(centerOfChunk.func_177981_b(landHeight));
                if (state.func_196958_f() || !state.func_204520_s().func_206888_e() || !state.func_185904_a().func_76220_a()) {
                    isSolidGround = false;
                    continue block0;
                }
                if (minY == 0) {
                    minY = landHeight;
                }
                if (maxY == 0) {
                    maxY = landHeight;
                }
                minY = Math.min(minY, landHeight);
                maxY = Math.max(maxY, landHeight);
            }
        }
        boolean isFlatGround = true;
        return isFlatGround && isSolidGround;
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structure, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int reference, long seed) {
            super(structure, chunkX, chunkZ, mutableBoundingBox, reference, seed);
        }

        public void generatePieces(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager templateManager, int chunkX, int chunkZ, Biome biomeIn, NoFeatureConfig config) {
            BlockPos blockpos = null;
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    BlockPos centerOfChunk = new BlockPos((chunkX + i << 4) - 7, 0, (chunkZ + j << 4) - 7);
                    int landHeight = chunkGenerator.func_222529_a(centerOfChunk.func_177958_n(), centerOfChunk.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
                    if (blockpos != null && (blockpos == null || blockpos.func_177956_o() <= landHeight)) continue;
                    blockpos = new BlockPos(centerOfChunk.func_177958_n(), landHeight, centerOfChunk.func_177952_p());
                }
            }
            MarineLargeBasePieces.addComponents(templateManager, blockpos, this.field_75075_a);
            this.field_75075_a.forEach(piece -> piece.func_181138_a(0, -6, 0));
            this.func_202500_a();
            BlockPos structSize = new BlockPos(this.func_75071_a().field_78893_d - this.func_75071_a().field_78897_a, 0, this.func_75071_a().field_78892_f - this.func_75071_a().field_78896_c);
            StructuresHelper.SPAWNED_STRUCTURES.add(blockpos);
            WyDebug.debug("Start of Marine Large Base spawned at: /tp " + this.func_75071_a().field_78897_a + " ~ " + this.func_75071_a().field_78896_c);
            WyDebug.debug("End of Marine Large Base spawned at: /tp " + this.func_75071_a().field_78893_d + " ~ " + this.func_75071_a().field_78892_f);
            WyDebug.debug("Size of Marine Large Base: " + structSize.func_177958_n() + ", " + structSize.func_177956_o() + ", " + structSize.func_177952_p());
        }
    }
}

