/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.world.features.structures.mediumship.pirate;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import xyz.pixelatedw.mineminenomi.api.enums.CanvasSize;
import xyz.pixelatedw.mineminenomi.api.helpers.StructuresHelper;
import xyz.pixelatedw.mineminenomi.blocks.FlagBlock;
import xyz.pixelatedw.mineminenomi.blocks.WantedPosterBlock;
import xyz.pixelatedw.mineminenomi.blocks.tileentities.FlagTileEntity;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModLootTables;
import xyz.pixelatedw.mineminenomi.init.ModStructures;

public class PirateMediumShipPiece
extends TemplateStructurePiece {
    private ResourceLocation resourceLocation;
    private Rotation rotation;

    public PirateMediumShipPiece(TemplateManager template, CompoundNBT nbt) {
        super(ModStructures.Pieces.PIRATE_MEDIUM_SHIP_PIECE, nbt);
        this.resourceLocation = new ResourceLocation(nbt.func_74779_i("Template"));
        this.rotation = Rotation.valueOf((String)nbt.func_74779_i("Rot"));
        this.build(template);
    }

    public PirateMediumShipPiece(TemplateManager template, BlockPos pos, Rotation rot) {
        super(ModStructures.Pieces.PIRATE_MEDIUM_SHIP_PIECE, 0);
        this.rotation = rot;
        this.field_186178_c = pos;
        this.resourceLocation = new ResourceLocation("mineminenomi", "pirate/medium_ship");
        this.build(template);
    }

    protected void func_143011_b(CompoundNBT nbt) {
        super.func_143011_b(nbt);
        nbt.func_74778_a("Template", this.resourceLocation.toString());
        nbt.func_74778_a("Rot", this.rotation.name());
    }

    private void build(TemplateManager templateManager) {
        Template template = templateManager.func_200220_a(this.resourceLocation);
        PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215206_c);
        this.func_186173_a(template, this.field_186178_c, placementsettings);
    }

    protected void func_186175_a(String function, BlockPos pos, IServerWorld world, Random rand, MutableBoundingBox sbb) {
        TileEntity flagTile;
        BlockState state;
        if (function.equals("supplies_chest")) {
            StructuresHelper.spawnLoot((IWorld)world, pos, ModLootTables.MEDIUM_PIRATE_SHIP_SUPPLIES_CHEST);
        }
        if (function.equals("food_chest")) {
            StructuresHelper.spawnLoot((IWorld)world, pos, ModLootTables.MEDIUM_PIRATE_SHIP_FOOD_CHEST);
        }
        if (function.equals("captain_chest")) {
            StructuresHelper.spawnLoot((IWorld)world, pos, ModLootTables.MEDIUM_PIRATE_SHIP_CAPTAIN_CHEST);
        }
        if (function.equals("deck_spawn")) {
            StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.PIRATE, StructuresHelper.StructureSpawnType.GRUNT, 3);
        }
        if (function.equals("captain_room_spawn")) {
            StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.PIRATE, StructuresHelper.StructureSpawnType.CAPTAIN, 1);
        }
        if (function.equals("cannons_spawn")) {
            StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.PIRATE, StructuresHelper.StructureSpawnType.GRUNT, 5);
        }
        if (function.equals("wheel_spawn")) {
            StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.PIRATE, StructuresHelper.StructureSpawnType.BRUTE, 2);
        }
        Rotation rot = this.field_186177_b.func_186215_c();
        if (function.equals("flag")) {
            state = ((Block)ModBlocks.FLAG.get()).func_176223_P();
            state = (BlockState)state.func_206870_a((Property)WantedPosterBlock.FACING, (Comparable)rot.func_185831_a(Direction.SOUTH));
            state = (BlockState)state.func_206870_a(FlagBlock.SIZE, (Comparable)((Object)CanvasSize.LARGE));
            world.func_180501_a(pos, state, 3);
            FlagBlock.placeSubs((IWorld)world, pos, state, false);
            flagTile = world.func_175625_s(pos);
            if (flagTile != null && flagTile instanceof FlagTileEntity) {
                ((FlagTileEntity)flagTile).setFaction("pirate");
            }
        }
        if (function.equals("flag_2")) {
            state = ((Block)ModBlocks.FLAG.get()).func_176223_P();
            state = (BlockState)state.func_206870_a((Property)WantedPosterBlock.FACING, (Comparable)rot.func_185831_a(Direction.SOUTH));
            state = (BlockState)state.func_206870_a(FlagBlock.SIZE, (Comparable)((Object)CanvasSize.MEDIUM));
            world.func_180501_a(pos, state, 3);
            FlagBlock.placeSubs((IWorld)world, pos, state, false);
            flagTile = world.func_175625_s(pos);
            if (flagTile != null && flagTile instanceof FlagTileEntity) {
                ((FlagTileEntity)flagTile).setFaction("pirate");
            }
        }
    }

    public boolean func_230383_a_(ISeedReader world, StructureManager pStructureManager, ChunkGenerator pChunkGenerator, Random pRandom, MutableBoundingBox pBox, ChunkPos pChunkPos, BlockPos pPos) {
        boolean flag = super.func_230383_a_(world, pStructureManager, pChunkGenerator, pRandom, pBox, pChunkPos, pPos);
        ArrayList infos = new ArrayList();
        infos.addAll(this.field_186176_a.func_215381_a(this.field_186178_c, this.field_186177_b, Blocks.field_150486_ae));
        infos.addAll(this.field_186176_a.func_215381_a(this.field_186178_c, this.field_186177_b, Blocks.field_150485_bF));
        infos.addAll(this.field_186176_a.func_215381_a(this.field_186178_c, this.field_186177_b, Blocks.field_196624_br));
        infos.addAll(this.field_186176_a.func_215381_a(this.field_186178_c, this.field_186177_b, Blocks.field_196638_cX));
        infos.addAll(this.field_186176_a.func_215381_a(this.field_186178_c, this.field_186177_b, Blocks.field_222432_lU));
        for (Template.BlockInfo info : infos) {
            world.func_180501_a(info.field_186242_a, (BlockState)info.field_186243_b.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)), 3);
        }
        return flag;
    }
}

