/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.world.features.structures.watchtower.marine;

import java.util.Random;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.StructuresHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.world.features.structures.OPStructure;
import xyz.pixelatedw.mineminenomi.world.features.structures.watchtower.marine.MarineWatchTowerPiece;
import xyz.pixelatedw.mineminenomi.wypi.WyDebug;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class MarineWatchTowerStructure
extends OPStructure<NoFeatureConfig> {
    public MarineWatchTowerStructure() {
        super(NoFeatureConfig.field_236558_a_);
    }

    @Override
    public boolean biomeCheck(BiomeLoadingEvent event) {
        boolean canSpawn = CommonConfig.INSTANCE.canSpawnWatchTowers();
        return event.getCategory() != Biome.Category.NONE && event.getCategory() != Biome.Category.OCEAN && (double)event.getClimate().field_242461_c > 0.3 && (double)event.getClimate().field_242461_c < 1.5 && canSpawn;
    }

    @Override
    public StructuresHelper.StructureFaction getFaction() {
        return StructuresHelper.StructureFaction.MARINE;
    }

    protected boolean isFeatureChunk(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig featureConfig) {
        BlockPos centerOfChunk = new BlockPos((chunkX << 4) + 7, 0, (chunkZ << 4) + 7);
        int landHeight = chunkGenerator.func_222531_c(centerOfChunk.func_177958_n(), centerOfChunk.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
        IBlockReader columnOfBlocks = chunkGenerator.func_230348_a_(centerOfChunk.func_177958_n(), centerOfChunk.func_177952_p());
        boolean superFlag = super.func_230363_a_(chunkGenerator, biomeSource, seed, chunkRandom, chunkX, chunkZ, biome, chunkPos, featureConfig);
        boolean isNotUnderwater = columnOfBlocks.func_180495_p(centerOfChunk.func_177981_b(landHeight)).func_204520_s().func_206888_e();
        boolean isChance = MathHelper.func_151237_a((double)(WyHelper.randomWithRange(0, 100) + WyHelper.randomDouble()), (double)0.0, (double)100.0) < CommonConfig.INSTANCE.getChanceForWatchTowersSpawn();
        return superFlag && isNotUnderwater && isChance;
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structure, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int reference, long seed) {
            super(structure, chunkX, chunkZ, mutableBoundingBox, reference, seed);
        }

        public void generatePieces(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager templateManager, int chunkX, int chunkZ, Biome biomeIn, NoFeatureConfig config) {
            Rotation rotation = Rotation.func_222466_a((Random)this.field_214631_d);
            int x = (chunkX << 4) + 7;
            int z = (chunkZ << 4) + 7;
            int surfaceY = chunkGenerator.func_222529_a(x, z, Heightmap.Type.WORLD_SURFACE_WG);
            BlockPos blockpos = new BlockPos(x, surfaceY, z);
            this.field_75075_a.add(new MarineWatchTowerPiece(templateManager, blockpos, rotation));
            this.func_202500_a();
            StructuresHelper.SPAWNED_STRUCTURES.add(blockpos);
            WyDebug.debug("Marine Watch Tower spawned at: /tp " + ((StructurePiece)this.field_75075_a.get((int)0)).func_74874_b().field_78897_a + " ~ " + ((StructurePiece)this.field_75075_a.get((int)0)).func_74874_b().field_78896_c);
        }
    }
}

