/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.world.spawners;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.entities.TrainerEntity;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.wypi.WyDebug;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class TrainerSpawner {
    private Random random = new Random();
    private int cooldown;

    public void tick(ServerWorld world) {
        world.func_217381_Z().func_76320_a("traderSpawnerTick");
        if (--this.cooldown <= 0) {
            this.cooldown = CommonConfig.INSTANCE.getTimeBetweenTrainerSpawns();
            if (this.random.nextInt(100) <= CommonConfig.INSTANCE.getChanceForTrainerSpawn()) {
                this.spawn(world);
            }
        }
        world.func_217381_Z().func_76319_b();
    }

    private void spawn(ServerWorld world) {
        world.func_217381_Z().func_76320_a("trainerSpawnerSpawn");
        ServerPlayerEntity player = world.func_217472_l_();
        if (player == null) {
            return;
        }
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        EntityType entityType = null;
        if (props.isSwordsman()) {
            entityType = (EntityType)ModEntities.SWORDSMAN_TRAINER.get();
        } else if (props.isSniper()) {
            entityType = (EntityType)ModEntities.SNIPER_TRAINER.get();
        } else if (props.isWeatherWizard()) {
            entityType = (EntityType)ModEntities.ART_OF_WEATHER_TRAINER.get();
        } else if (props.isDoctor()) {
            entityType = (EntityType)ModEntities.DOCTOR_TRAINER.get();
        } else if (props.isBrawler()) {
            entityType = (EntityType)ModEntities.BRAWLER_TRAINER.get();
        } else if (props.isBlackLeg()) {
            entityType = (EntityType)ModEntities.BLACK_LEG_TRAINER.get();
        }
        if (entityType == null) {
            return;
        }
        BlockPos targetPos = player.func_233580_cy_();
        BlockPos spawnPos = WyHelper.findOnGroundSpawnLocation((World)world, entityType, targetPos, 20);
        if (spawnPos == null) {
            return;
        }
        List trainers = WyHelper.getNearbyEntities(new Vector3d((double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p()), (IWorld)world, 100.0, null, TrainerEntity.class);
        if (spawnPos != null) {
            boolean canSpawnInBiome;
            boolean bl = canSpawnInBiome = world.func_226691_t_(targetPos).func_201856_r() != Biome.Category.OCEAN;
            if (trainers.size() < 2 && canSpawnInBiome) {
                entityType.func_220342_a(world, (CompoundNBT)null, (ITextComponent)null, (PlayerEntity)null, spawnPos, SpawnReason.EVENT, false, false);
                WyDebug.debug("Trainer spawned at: " + spawnPos);
            }
        }
        world.func_217381_Z().func_76319_b();
    }
}

