/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.attributefix;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import net.darkhax.attributefix.AttributeFix;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;

public class ConfigHandler {
    public static final DecimalFormat FORMAT = new DecimalFormat("#.##");
    private final Map<RangedAttribute, AttributeData> attributes = new HashMap<RangedAttribute, AttributeData>();
    private final ForgeConfigSpec spec;

    public ConfigHandler() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        for (Attribute attribute : ForgeRegistries.ATTRIBUTES) {
            if (attribute instanceof RangedAttribute) {
                RangedAttribute ranged = (RangedAttribute)attribute;
                AttributeData data = new AttributeData(ranged, builder);
                this.attributes.put(ranged, data);
                continue;
            }
            AttributeFix.LOG.debug("Skipping attribute {}, not a ranged attribute.", (Object)attribute.getRegistryName());
        }
        this.spec = builder.build();
    }

    public ForgeConfigSpec getSpec() {
        return this.spec;
    }

    public void applyChanges() {
        for (Map.Entry<RangedAttribute, AttributeData> entry : this.attributes.entrySet()) {
            RangedAttribute ranged = entry.getKey();
            AttributeData data = entry.getValue();
            if (((Boolean)data.enabled.get()).booleanValue()) {
                AttributeFix.LOG.debug("Changing range for {} from {}-{} to {}-{}", (Object)ranged.getRegistryName(), (Object)FORMAT.format(ranged.field_111120_a), (Object)FORMAT.format(ranged.field_111118_b), (Object)FORMAT.format(data.min.get()), (Object)FORMAT.format(data.max.get()));
                ranged.field_111120_a = (Double)data.min.get();
                ranged.field_111118_b = (Double)data.max.get();
                continue;
            }
            AttributeFix.LOG.debug("Skipping attribute {}. Disabled by config.", (Object)ranged.getRegistryName());
        }
    }

    private class AttributeData {
        private final ForgeConfigSpec.BooleanValue enabled;
        private final ForgeConfigSpec.DoubleValue min;
        private final ForgeConfigSpec.DoubleValue max;

        public AttributeData(RangedAttribute attribute, ForgeConfigSpec.Builder builder) {
            ResourceLocation id = attribute.getRegistryName();
            String group = id.func_110624_b().replace(".", "_") + "_" + id.func_110623_a().toString().replace(".", "_");
            builder.comment("Values for the " + attribute.getRegistryName().toString() + " attribute.");
            builder.push(group);
            builder.comment("Whether or not this attribute should be modified.");
            this.enabled = builder.define("enabled", true);
            builder.comment("The minimum vallue for the attribute. Changing this may have unforseen consequences.");
            this.min = builder.defineInRange("min", attribute.field_111120_a, -1.7976931348623157E308, Double.MAX_VALUE);
            builder.comment("The maximum value for the attribute.");
            this.max = builder.defineInRange("max", Math.max(attribute.field_111118_b, 65536.0), -1.7976931348623157E308, Double.MAX_VALUE);
            builder.pop();
        }
    }
}

