/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.ai;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import noppes.npcs.CustomNpcs;
import noppes.npcs.ai.selector.NPCInteractSelector;
import noppes.npcs.controllers.data.Line;
import noppes.npcs.entity.EntityNPCInterface;

public class EntityAIWander
extends Goal {
    private EntityNPCInterface entity;
    public final NPCInteractSelector selector;
    private double x;
    private double y;
    private double zPosition;
    private EntityNPCInterface nearbyNPC;

    public EntityAIWander(EntityNPCInterface npc) {
        this.entity = npc;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        this.selector = new NPCInteractSelector(npc);
    }

    public boolean func_75250_a() {
        if (this.entity.func_70654_ax() >= 100 || !this.entity.func_70661_as().func_75500_f() || this.entity.isInteracting() || this.entity.func_184218_aH() || this.entity.ais.movingPause && this.entity.func_70681_au().nextInt(80) != 0) {
            return false;
        }
        if (this.entity.ais.npcInteracting && this.entity.func_70681_au().nextInt(this.entity.ais.movingPause ? 6 : 16) == 1) {
            this.nearbyNPC = this.getNearbyNPC();
        }
        if (this.nearbyNPC != null) {
            this.x = MathHelper.func_76128_c((double)this.nearbyNPC.func_226277_ct_());
            this.y = MathHelper.func_76128_c((double)this.nearbyNPC.func_226278_cu_());
            this.zPosition = MathHelper.func_76128_c((double)this.nearbyNPC.func_226281_cx_());
            this.nearbyNPC.addInteract((LivingEntity)this.entity);
        } else {
            Vector3d vec = this.getVec();
            if (vec == null) {
                return false;
            }
            this.x = vec.field_72450_a;
            this.y = vec.field_72448_b;
            if (this.entity.ais.movementType == 1) {
                this.y = this.entity.getStartYPos() + (double)this.entity.func_70681_au().nextFloat() * 0.75 * (double)this.entity.ais.walkingRange;
            }
            this.zPosition = vec.field_72449_c;
        }
        return true;
    }

    public void func_75246_d() {
        if (this.nearbyNPC != null) {
            this.nearbyNPC.func_70661_as().func_75499_g();
        }
    }

    private EntityNPCInterface getNearbyNPC() {
        List list = this.entity.field_70170_p.func_175674_a((Entity)this.entity, this.entity.func_174813_aQ().func_72314_b((double)this.entity.ais.walkingRange, this.entity.ais.walkingRange > 7 ? 7.0 : (double)this.entity.ais.walkingRange, (double)this.entity.ais.walkingRange), (Predicate)((Object)this.selector));
        Iterator ita = list.iterator();
        while (ita.hasNext()) {
            EntityNPCInterface npc = (EntityNPCInterface)((Object)ita.next());
            if (npc.ais.stopAndInteract && !npc.isAttacking() && npc.func_70089_S() && !this.entity.faction.isAggressiveToNpc(npc)) continue;
            ita.remove();
        }
        if (list.isEmpty()) {
            return null;
        }
        return (EntityNPCInterface)((Object)list.get(this.entity.func_70681_au().nextInt(list.size())));
    }

    private Vector3d getVec() {
        if (this.entity.ais.walkingRange > 0) {
            BlockPos start = new BlockPos((double)this.entity.getStartXPos(), this.entity.getStartYPos(), (double)this.entity.getStartZPos());
            int distance = (int)MathHelper.func_76133_a((double)this.entity.func_233580_cy_().func_177951_i((Vector3i)start));
            int range = Math.min(this.entity.ais.walkingRange, CustomNpcs.NpcNavRange);
            if (range - distance < 4) {
                Vector3d pos2 = new Vector3d((this.entity.func_226277_ct_() + (double)start.func_177958_n()) / 2.0, (this.entity.func_226278_cu_() + (double)start.func_177956_o()) / 2.0, (this.entity.func_226281_cx_() + (double)start.func_177952_p()) / 2.0);
                return RandomPositionGenerator.func_75464_a((CreatureEntity)this.entity, (int)(range / 2), (int)Math.min(range / 2, 7), (Vector3d)pos2);
            }
            return RandomPositionGenerator.func_191377_b((CreatureEntity)this.entity, (int)(range / 2), (int)Math.min(range / 2, 7));
        }
        return RandomPositionGenerator.func_191377_b((CreatureEntity)this.entity, (int)CustomNpcs.NpcNavRange, (int)7);
    }

    public boolean func_75253_b() {
        if (this.nearbyNPC != null && (!this.selector.apply((Object)this.nearbyNPC) || this.entity.isInRange((Entity)this.nearbyNPC, this.entity.func_213311_cf()))) {
            return false;
        }
        return !this.entity.func_70661_as().func_75500_f() && this.entity.func_70089_S() && !this.entity.isInteracting();
    }

    public void func_75249_e() {
        this.entity.func_70661_as().func_75484_a(this.entity.func_70661_as().func_225466_a(this.x, this.y, this.zPosition, 0), 1.0);
    }

    public void func_75251_c() {
        if (this.nearbyNPC != null && this.entity.isInRange((Entity)this.nearbyNPC, 3.5)) {
            Line line;
            EntityNPCInterface talk = this.entity;
            if (this.entity.func_70681_au().nextBoolean()) {
                talk = this.nearbyNPC;
            }
            if ((line = talk.advanced.getNPCInteractLine()) == null) {
                line = new Line(".........");
            }
            line.setShowText(false);
            talk.saySurrounding(line);
            this.entity.addInteract((LivingEntity)this.nearbyNPC);
            this.nearbyNPC.addInteract((LivingEntity)this.entity);
        }
        this.nearbyNPC = null;
    }
}

