/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.eventbus.api.Event;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.event.CustomGuiEvent;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.WrapperNpcAPI;
import noppes.npcs.api.wrapper.gui.CustomGuiWrapper;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.containers.ContainerCustomGui;

public class CustomGuiController {
    static boolean checkGui(CustomGuiEvent event) {
        Object player = event.player.getMCEntity();
        if (!(((PlayerEntity)player).field_71070_bA instanceof ContainerCustomGui)) {
            return false;
        }
        return ((ContainerCustomGui)((PlayerEntity)player).field_71070_bA).customGui.getID() == event.gui.getID();
    }

    public static IItemStack[] getSlotContents(PlayerEntity player) {
        IItemStack[] slotContents = new IItemStack[]{};
        if (player.field_71070_bA instanceof ContainerCustomGui) {
            ContainerCustomGui container = (ContainerCustomGui)player.field_71070_bA;
            slotContents = new IItemStack[container.guiInventory.func_70302_i_()];
            for (int i = 0; i < container.guiInventory.func_70302_i_(); ++i) {
                slotContents[i] = NpcAPI.Instance().getIItemStack(container.guiInventory.func_70301_a(i));
            }
        }
        return slotContents;
    }

    public static void onButton(CustomGuiEvent.ButtonEvent event) {
        Object player = event.player.getMCEntity();
        if (CustomGuiController.checkGui(event) && CustomGuiController.getOpenGui(player).getScriptHandler() != null) {
            CustomGuiController.getOpenGui(player).getScriptHandler().run(EnumScriptType.CUSTOM_GUI_BUTTON, event);
        }
        WrapperNpcAPI.EVENT_BUS.post((Event)event);
    }

    public static void onQuickCraft(CustomGuiEvent.SlotEvent event) {
        Object player = event.player.getMCEntity();
        if (CustomGuiController.checkGui(event) && CustomGuiController.getOpenGui(player).getScriptHandler() != null) {
            CustomGuiController.getOpenGui(player).getScriptHandler().run(EnumScriptType.CUSTOM_GUI_SLOT, event);
        }
        WrapperNpcAPI.EVENT_BUS.post((Event)event);
    }

    public static void onScrollClick(CustomGuiEvent.ScrollEvent event) {
        Object player = event.player.getMCEntity();
        if (CustomGuiController.checkGui(event) && CustomGuiController.getOpenGui(player).getScriptHandler() != null) {
            CustomGuiController.getOpenGui(player).getScriptHandler().run(EnumScriptType.CUSTOM_GUI_SCROLL, event);
        }
        WrapperNpcAPI.EVENT_BUS.post((Event)event);
    }

    public static boolean onSlotClick(CustomGuiEvent.SlotClickEvent event) {
        Object player = event.player.getMCEntity();
        if (CustomGuiController.checkGui(event) && CustomGuiController.getOpenGui(player).getScriptHandler() != null) {
            CustomGuiController.getOpenGui(player).getScriptHandler().run(EnumScriptType.CUSTOM_GUI_SLOT_CLICKED, event);
        }
        return WrapperNpcAPI.EVENT_BUS.post((Event)event);
    }

    public static void onClose(CustomGuiEvent.CloseEvent event) {
        Object player = event.player.getMCEntity();
        CustomGuiController.getOpenGui(player).getScriptHandler().run(EnumScriptType.CUSTOM_GUI_CLOSED, event);
        WrapperNpcAPI.EVENT_BUS.post((Event)event);
    }

    public static CustomGuiWrapper getOpenGui(PlayerEntity player) {
        if (player.field_71070_bA instanceof ContainerCustomGui) {
            return ((ContainerCustomGui)player.field_71070_bA).customGui;
        }
        return null;
    }
}

