/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.items;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.RoleCompanion;
import noppes.npcs.roles.RoleFollower;

public class ItemSoulstoneFilled
extends Item {
    public ItemSoulstoneFilled() {
        super(new Item.Properties().func_200917_a(1));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World level, List<ITextComponent> list, ITooltipFlag flag) {
        CompoundNBT compound = stack.func_77978_p();
        if (compound == null || !compound.func_150297_b("Entity", 10)) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.RED + "Error"));
            return;
        }
        TranslationTextComponent name = new TranslationTextComponent(compound.func_74779_i("Name"));
        if (compound.func_74764_b("DisplayName")) {
            name = new TranslationTextComponent(compound.func_74779_i("DisplayName")).func_240702_b_(" (").func_230529_a_((ITextComponent)name).func_240702_b_(")");
        }
        list.add((ITextComponent)new StringTextComponent(TextFormatting.BLUE + "").func_230529_a_((ITextComponent)name));
        if (stack.func_77978_p().func_74764_b("ExtraText")) {
            String[] split;
            StringTextComponent text = new StringTextComponent("");
            for (String s : split = compound.func_74779_i("ExtraText").split(",")) {
                text.func_230529_a_((ITextComponent)new TranslationTextComponent(s));
            }
            list.add((ITextComponent)text);
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_195991_k().field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        ItemStack stack = context.func_195996_i();
        if (ItemSoulstoneFilled.Spawn(context.func_195999_j(), stack, context.func_195991_k(), context.func_195995_a()) == null) {
            return ActionResultType.FAIL;
        }
        if (!context.func_195999_j().field_71075_bZ.field_75098_d) {
            stack.func_77979_a(1);
        }
        return ActionResultType.SUCCESS;
    }

    public static Entity Spawn(PlayerEntity player, ItemStack stack, World level, BlockPos pos) {
        if (level.field_72995_K) {
            return null;
        }
        if (stack.func_77978_p() == null || !stack.func_77978_p().func_150297_b("Entity", 10)) {
            return null;
        }
        CompoundNBT compound = stack.func_77978_p().func_74775_l("Entity");
        Entity entity = EntityType.func_220330_a((CompoundNBT)compound, (World)level).orElse(null);
        if (entity == null) {
            return null;
        }
        entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)((float)(pos.func_177956_o() + 1) + 0.2f), (double)pos.func_177952_p() + 0.5);
        if (entity instanceof EntityNPCInterface) {
            EntityNPCInterface npc = (EntityNPCInterface)entity;
            npc.ais.setStartPos(pos);
            npc.func_70606_j(npc.func_110138_aP());
            npc.func_70107_b((float)pos.func_177958_n() + 0.5f, npc.getStartYPos(), (float)pos.func_177952_p() + 0.5f);
            if (npc.role.getType() == 6 && player != null) {
                PlayerData data = PlayerData.get(player);
                if (data.hasCompanion()) {
                    return null;
                }
                ((RoleCompanion)npc.role).setOwner(player);
                data.setCompanion(npc);
            }
            if (npc.role.getType() == 2 && player != null) {
                ((RoleFollower)npc.role).setOwner(player);
            }
        }
        if (!level.func_217376_c(entity)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("error.failedToSpawn"), Util.field_240973_b_);
            return null;
        }
        return entity;
    }
}

