/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.network;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.chaosthedude.explorerscompass.items.ExplorersCompassItem;
import com.chaosthedude.explorerscompass.util.ItemUtils;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class CompassSearchPacket {
    private ResourceLocation structureKey;
    private int x;
    private int y;
    private int z;

    public CompassSearchPacket() {
    }

    public CompassSearchPacket(ResourceLocation structureKey, BlockPos pos) {
        this.structureKey = structureKey;
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
    }

    public CompassSearchPacket(PacketBuffer buf) {
        this.structureKey = buf.func_192575_l();
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_192572_a(this.structureKey);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ItemStack stack = ItemUtils.getHeldItem((PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender(), ExplorersCompass.explorersCompass);
            if (!stack.func_190926_b()) {
                ExplorersCompassItem explorersCompass = (ExplorersCompassItem)stack.func_77973_b();
                World world = ((NetworkEvent.Context)ctx.get()).getSender().field_70170_p;
                explorersCompass.searchForStructure(world, (PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender(), this.structureKey, new BlockPos(this.x, this.y, this.z), stack);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

