/*
 * Decompiled with CFR 0.152.
 */
package malte0811.nbtedit.api;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import malte0811.nbtedit.api.IEditHandler;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class API {
    private static final Map<EntityType<?>, IEditHandler> entityHandlers = new ConcurrentHashMap();
    private static final Map<Class<? extends TileEntity>, IEditHandler> tileHandlers = new ConcurrentHashMap<Class<? extends TileEntity>, IEditHandler>();

    private API() {
    }

    public static void registerTileHandler(Class<? extends TileEntity> c, IEditHandler e) {
        if (tileHandlers.containsKey(c)) {
            throw new IllegalArgumentException(c + "is already registered!");
        }
        tileHandlers.put(c, e);
    }

    public static void registerEntityHandler(EntityType<?> c, IEditHandler e) {
        if (entityHandlers.containsKey(c)) {
            throw new IllegalArgumentException(c + "is already registered!");
        }
        entityHandlers.put(c, e);
    }

    public static IEditHandler getEntityHandler(String e) {
        EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(e));
        if (type == null) {
            return null;
        }
        return entityHandlers.get(type);
    }

    public static IEditHandler getTileHandler(String s) {
        TileEntityType d = (TileEntityType)ForgeRegistries.TILE_ENTITIES.getValue(new ResourceLocation(s));
        if (d == null) {
            return null;
        }
        Class<?> clazz = d.func_200968_a().getClass();
        IEditHandler forClass = null;
        while (TileEntity.class.isAssignableFrom(clazz) && forClass == null) {
            forClass = tileHandlers.get(clazz);
            if (forClass != null) continue;
            clazz = clazz.getSuperclass();
        }
        return forClass;
    }

    public static IEditHandler get(CompoundNBT nbt) {
        if (nbt.func_74764_b("id")) {
            IEditHandler h = API.getTileHandler(nbt.func_74779_i("id"));
            if (h != null) {
                return h;
            }
            return API.getEntityHandler(nbt.func_74779_i("id"));
        }
        return null;
    }
}

