/*
 * Decompiled with CFR 0.152.
 */
package malte0811.nbtedit.command;

import com.google.common.collect.BiMap;
import com.google.common.collect.EnumHashBiMap;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import malte0811.nbtedit.NBTEdit;
import malte0811.nbtedit.nbt.EditPosKey;
import malte0811.nbtedit.network.MessageOpenWindow;
import malte0811.nbtedit.util.Utils;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.ArgumentSerializer;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;

public class CommandNbtEdit {
    private static final String SELF = "self";
    private static final String HAND = "hand";
    private static final String HAND_MAIN = "main";
    private static final String HAND_OFF = "off";
    private static final Message NO_OBJECT_MSG = new TranslationTextComponent("nbtedit.no_object");
    private static final CommandExceptionType NO_OBJECT_TYPE = new DynamicCommandExceptionType(obj -> NO_OBJECT_MSG);
    private static final CommandExceptionType NO_TILE_TYPE = new DynamicCommandExceptionType(obj -> NO_OBJECT_MSG);

    public static void register(CommandDispatcher<CommandSource> disp) {
        disp.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"nbtedit").requires(sender -> sender.func_197034_c(2))).executes(data -> CommandNbtEdit.editRaytrace((CommandSource)data.getSource()))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"pos", (ArgumentType)BlockPosArgument.func_197276_a()).executes(data -> CommandNbtEdit.editPos((CommandSource)data.getSource(), BlockPosArgument.func_197273_a((CommandContext)data, (String)"pos")))).then(Commands.func_197056_a((String)"dim", (ArgumentType)ResourceLocationArgument.func_197197_a()).executes(data -> {
            ResourceLocation dimensionName = ResourceLocationArgument.func_197195_e((CommandContext)data, (String)"dim");
            RegistryKey dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)dimensionName);
            return CommandNbtEdit.editPos((CommandSource)data.getSource(), BlockPosArgument.func_197273_a((CommandContext)data, (String)"pos"), (RegistryKey<World>)dimension);
        })))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)HAND).executes(data -> CommandNbtEdit.editHand((CommandSource)data.getSource(), Hand.MAIN_HAND))).then(Commands.func_197056_a((String)HAND, (ArgumentType)new HandArgument()).executes(data -> CommandNbtEdit.editHand((CommandSource)data.getSource(), (Hand)data.getArgument(HAND, Hand.class))))));
    }

    public static void registerSerializers() {
        ArgumentTypes.func_218136_a((String)"nbtedit:hand", HandArgument.class, (IArgumentSerializer)new ArgumentSerializer(() -> new HandArgument()));
    }

    private static int editHand(CommandSource source, Hand hand) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        CommandNbtEdit.openEditWindow(player, new EditPosKey(player.func_110124_au(), hand));
        return 0;
    }

    public static int editRaytrace(CommandSource src) throws CommandSyntaxException {
        ServerPlayerEntity player = src.func_197035_h();
        RayTraceResult mop = Utils.rayTrace((Entity)player);
        if (mop != null && mop.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockPos bPos = ((BlockRayTraceResult)mop).func_216350_a();
            return CommandNbtEdit.editPos(src, bPos);
        }
        if (mop != null && mop.func_216346_c() == RayTraceResult.Type.ENTITY) {
            Entity e = ((EntityRayTraceResult)mop).func_216348_a();
            return CommandNbtEdit.editEntity(src, e);
        }
        throw new CommandSyntaxException(NO_OBJECT_TYPE, NO_OBJECT_MSG);
    }

    private static void openEditWindow(ServerPlayerEntity player, EditPosKey pos) throws CommandSyntaxException {
        NBTEdit.packetHandler.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MessageOpenWindow(pos));
    }

    public static int editPos(CommandSource src, BlockPos pos) throws CommandSyntaxException {
        return CommandNbtEdit.editPos(src, pos, (RegistryKey<World>)src.func_197035_h().field_70170_p.func_234923_W_());
    }

    public static int editPos(CommandSource src, BlockPos pos, RegistryKey<World> dim) throws CommandSyntaxException {
        ServerPlayerEntity player = src.func_197035_h();
        CommandNbtEdit.openEditWindow(player, CommandNbtEdit.keyFromPos(pos, (PlayerEntity)player, dim));
        return 0;
    }

    private static EditPosKey keyFromPos(BlockPos p, PlayerEntity player, RegistryKey<World> dimension) throws CommandSyntaxException {
        if (player.field_70170_p.func_175625_s(p) == null) {
            throw new CommandSyntaxException(NO_TILE_TYPE, (Message)new TranslationTextComponent("nbtedit.no_te", new Object[]{p.func_177958_n(), p.func_177956_o(), p.func_177952_p()}));
        }
        return new EditPosKey(player.func_110124_au(), dimension, p);
    }

    private static int editEntity(CommandSource src, Entity e) throws CommandSyntaxException {
        ServerPlayerEntity player = src.func_197035_h();
        EditPosKey pos = new EditPosKey(player.func_110124_au(), (RegistryKey<World>)e.field_70170_p.func_234923_W_(), e.func_110124_au());
        CommandNbtEdit.openEditWindow(player, pos);
        return 0;
    }

    private static class HandArgument
    implements ArgumentType<Hand> {
        private static final BiMap<Hand, String> hands = EnumHashBiMap.create(Hand.class);

        private HandArgument() {
        }

        public Hand parse(StringReader reader) throws CommandSyntaxException {
            String name = reader.readString().toLowerCase();
            if (!hands.inverse().containsKey((Object)name)) {
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().createWithContext((ImmutableStringReader)new StringReader(name));
            }
            return (Hand)hands.inverse().get((Object)name);
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            for (String s : hands.values()) {
                builder.suggest(s);
            }
            return builder.buildFuture();
        }

        public Collection<String> getExamples() {
            return hands.values();
        }

        static {
            hands.put((Object)Hand.MAIN_HAND, (Object)CommandNbtEdit.HAND_MAIN);
            hands.put((Object)Hand.OFF_HAND, (Object)CommandNbtEdit.HAND_OFF);
        }
    }
}

