/*
 * Decompiled with CFR 0.152.
 */
package malte0811.nbtedit.gui;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import malte0811.nbtedit.NBTEdit;
import malte0811.nbtedit.api.API;
import malte0811.nbtedit.api.IEditHandler;
import malte0811.nbtedit.api.INBTEditingProvider;
import malte0811.nbtedit.client.NBTClipboard;
import malte0811.nbtedit.gui.NBTTreeCellRenderer;
import malte0811.nbtedit.nbt.AutoPullConfig;
import malte0811.nbtedit.nbt.EditPosKey;
import malte0811.nbtedit.nbt.NBTUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class NBTFrame
extends JFrame {
    private static final long serialVersionUID = -8001779180003715111L;
    public final EditPosKey editPos;
    private CompoundNBT nbtRoot;
    private CompoundNBT lastSynced;
    private JTree tree;
    private JScrollPane scroll;
    private final JButton push = new JButton("Push NBT to world");
    private final JButton pull = new JButton("Pull NBT from world");
    private final JButton autoPull = new JButton("Enable auto pulling");
    private final JPanel panel = new JPanel();
    private JMenuBar bar;
    private INBTEditingProvider provider = NBTEdit.proxy;

    public NBTFrame(EditPosKey pos) {
        super("NBTEdit");
        this.editPos = pos;
        this.add(this.panel);
        this.initGUI();
        this.pullNbt();
        this.push.addActionListener(e -> this.pushNbt());
        this.pull.addActionListener(e -> this.pullNbt());
        this.autoPull.addActionListener(e -> this.setupAutoPull());
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new CloseListener());
        this.setSize(500, 500);
        this.setVisible(true);
    }

    public void pullNbt() {
        this.provider.requestNBT(this.editPos, nbt -> {
            this.nbtRoot = nbt;
            this.lastSynced = this.nbtRoot != null ? this.nbtRoot.func_74737_b() : null;
            SwingUtilities.invokeLater(this::updateNbt);
        });
    }

    private void initGUI() {
        this.tree = new JTree(new DefaultMutableTreeNode(new ImmutablePair((Object)"nbtroot", (Object)new CompoundNBT())));
        this.tree.setCellRenderer(new NBTTreeCellRenderer());
        GroupLayout gl = new GroupLayout(this.panel);
        GroupLayout.ParallelGroup hor = gl.createParallelGroup();
        GroupLayout.SequentialGroup vert = gl.createSequentialGroup();
        this.scroll = new JScrollPane(this.tree);
        hor.addComponent(this.scroll);
        vert.addComponent(this.scroll);
        GroupLayout.ParallelGroup vertInner = gl.createParallelGroup();
        GroupLayout.SequentialGroup horInner = gl.createSequentialGroup();
        vertInner.addComponent(this.pull);
        horInner.addComponent(this.pull);
        vertInner.addComponent(this.push);
        horInner.addComponent(this.push);
        vertInner.addComponent(this.autoPull);
        horInner.addComponent(this.autoPull);
        hor.addGroup(horInner);
        vert.addGroup(vertInner);
        gl.setHorizontalGroup(hor);
        gl.setVerticalGroup(vert);
        this.tree.addMouseListener(new NBTMouseListener());
        this.tree.addKeyListener(new NBTKeyListener());
        this.panel.setLayout(gl);
        this.bar = new JMenuBar();
        JMenu menu = new JMenu("Clipboard");
        JMenuItem i = new JMenuItem("Load");
        i.setToolTipText("Load .nbt file to internal clipboard");
        i.addActionListener(a -> this.loadFileToClipboard());
        menu.add(i);
        i = new JMenuItem("Save");
        i.setToolTipText("Save internal clipboard to .nbt file");
        i.addActionListener(a -> this.saveClipboardToFile());
        menu.add(i);
        i = new JMenuItem("Delete");
        i.setToolTipText("Delete entry in the internal clipboard");
        i.addActionListener(a -> this.deleteClipboardEntry());
        menu.add(i);
        this.bar.add(menu);
        this.setJMenuBar(this.bar);
    }

    private void updateNbt() {
        if (this.nbtRoot == null) {
            new Thread(() -> {
                AutoPullConfig tmp;
                Set<AutoPullConfig> configs = NBTEdit.proxy.getAutoPulls();
                if (configs.contains(tmp = new AutoPullConfig(this, 0))) {
                    configs.remove(tmp);
                    this.autoPull.setText("Enable auto pulling");
                }
                JOptionPane.showMessageDialog(this, "The object being edited was removed.");
            }).start();
            return;
        }
        DefaultMutableTreeNode node = this.genTreeFromNbt(this.nbtRoot);
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        Enumeration<TreePath> expanded = this.tree.getExpandedDescendants(new TreePath(model.getRoot()));
        TreePath selected = this.tree.getSelectionPath();
        model.setRoot(node);
        this.updateExpansionAndSelection(expanded, selected, this.tree, this.scroll);
        IEditHandler h = API.get(this.nbtRoot);
        if (h != null) {
            JMenu menu = new JMenu("Extra");
            h.addMenuItems(this.nbtRoot, menu, this);
            if (menu.getItemCount() > 0) {
                for (int i = 0; i < this.bar.getMenuCount(); ++i) {
                    if (!this.bar.getMenu(i).getText().equals("Extra")) continue;
                    this.bar.remove(i);
                    --i;
                }
                this.bar.add(menu);
                this.setJMenuBar(this.bar);
            }
        }
        this.repaint();
    }

    private void updateExpansionAndSelection(@Nullable Enumeration<TreePath> expanded, TreePath selected, JTree dest, JScrollPane scroll) {
        HashMap<String, TreePath> destMap = new HashMap<String, TreePath>();
        this.buildMap((TreeNode)dest.getModel().getRoot(), null, destMap);
        if (expanded != null) {
            while (expanded.hasMoreElements()) {
                TreePath curr = expanded.nextElement();
                TreePath dstVersion = (TreePath)destMap.get(this.stringFromPath(curr));
                if (dstVersion == null) continue;
                dest.expandPath(dstVersion);
            }
        }
        if (selected != null) {
            Rectangle rect;
            dest.setSelectionPath((TreePath)destMap.get(this.stringFromPath(selected)));
            dest.makeVisible(dest.getSelectionPath());
            if (dest.getSelectionPath() != null && dest.getPathBounds(dest.getSelectionPath()) != null && (rect = dest.getPathBounds(dest.getSelectionPath())) != null && !scroll.getViewport().getViewRect().contains(rect)) {
                scroll.getViewport().setViewPosition(new Point(0, 0));
                scroll.getViewport().scrollRectToVisible(rect);
            }
        }
    }

    private void buildMap(TreeNode node, TreePath base, Map<String, TreePath> l) {
        base = base != null ? base.pathByAddingChild(node) : new TreePath(node);
        l.put(this.stringFromPath(base), base);
        if (node.getAllowsChildren()) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.buildMap(node.getChildAt(i), base, l);
            }
        }
    }

    private String stringFromPath(TreePath t) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < t.getPathCount(); ++i) {
            ret.append(this.stringFromObject(t.getPathComponent(i))).append(";");
        }
        return ret.toString();
    }

    private DefaultMutableTreeNode genTreeFromNbt(CompoundNBT nbt) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(new ImmutablePair((Object)"nbtroot", (Object)nbt));
        for (String k : nbt.func_150296_c()) {
            INBT b = nbt.func_74781_a(k);
            root.add(this.getNodeForBase(b, k));
        }
        return root;
    }

    private MutableTreeNode getNodeForBase(INBT nbt, String key) {
        String type;
        switch (type = NBTUtils.NBT_TYPES[nbt.func_74732_a()]) {
            case "COMPOUND": {
                DefaultMutableTreeNode sub = this.genTreeFromNbt((CompoundNBT)nbt);
                sub.setUserObject(new ImmutablePair((Object)key, (Object)nbt));
                return sub;
            }
            case "LIST": {
                DefaultMutableTreeNode list = new DefaultMutableTreeNode(new ImmutablePair((Object)key, (Object)nbt));
                ListNBT l = (ListNBT)nbt;
                for (int i = 0; i < l.size(); ++i) {
                    list.add(this.getNodeForBase(l.get(i), Integer.toString(i)));
                }
                return list;
            }
        }
        return new DefaultMutableTreeNode(new ImmutablePair((Object)key, (Object)nbt));
    }

    private void setupAutoPull() {
        AutoPullConfig tmp;
        Set<AutoPullConfig> configs = NBTEdit.proxy.getAutoPulls();
        if (configs.contains(tmp = new AutoPullConfig(this, 0))) {
            configs.remove(tmp);
            this.autoPull.setText("Enable auto pulling");
        } else {
            String in = JOptionPane.showInputDialog(this, "Ticks to wait between automatic pulls:", "10");
            if (in != null) {
                try {
                    int delay = Integer.parseInt(in);
                    if (delay <= 0) {
                        throw new IllegalArgumentException("Delay must be greater than zero");
                    }
                    AutoPullConfig real = new AutoPullConfig(this, delay);
                    configs.add(real);
                    this.autoPull.setText("Disable auto pulling");
                }
                catch (Exception x) {
                    JOptionPane.showMessageDialog(this, "Failed to set up auto pulling. Check the log for details.");
                    x.printStackTrace();
                }
            }
        }
    }

    private void edit(TreePath path) {
        if (path == null) {
            return;
        }
        INBT[] state = new INBT[]{this.nbtRoot, null};
        String key = this.findNbtInTree(path, state);
        INBT end = state[0];
        INBT parent = state[1];
        String init = NBTUtils.nbtToString(end);
        if (init != null) {
            String ret = JOptionPane.showInputDialog(this, "Please enter the new value", init);
            INBT nbtNew = NBTUtils.stringToNbt(ret, end);
            if (nbtNew != null) {
                if (parent instanceof CompoundNBT) {
                    ((CompoundNBT)parent).func_218657_a(key, nbtNew);
                } else if (parent != null) {
                    ((ListNBT)parent).set(Integer.parseInt(key), nbtNew);
                }
                this.updateNbt();
            } else {
                JOptionPane.showMessageDialog(this, "The given input is invalid", "Invalid input!", 0);
            }
        }
    }

    private String findNbtInTree(TreePath path, INBT[] state) {
        String key = null;
        for (int i = 1; i < path.getPathCount(); ++i) {
            key = this.stringFromObject(path.getPathComponent(i));
            if (state[0] instanceof CompoundNBT) {
                state[1] = state[0];
                state[0] = ((CompoundNBT)state[0]).func_74781_a(key);
                continue;
            }
            if (!(state[0] instanceof ListNBT)) continue;
            state[1] = state[0];
            state[0] = ((ListNBT)state[0]).get(Integer.parseInt(key));
        }
        return key;
    }

    private INBT get(TreePath t) {
        if (t == null) {
            return null;
        }
        CompoundNBT curr = this.nbtRoot;
        for (int i = 1; i < t.getPathCount(); ++i) {
            String key = this.stringFromObject(t.getPathComponent(i));
            if (curr instanceof CompoundNBT) {
                curr = curr.func_74781_a(key);
                continue;
            }
            if (!(curr instanceof ListNBT)) continue;
            curr = ((ListNBT)curr).get(Integer.parseInt(key));
        }
        return curr;
    }

    private void delete(TreePath path) {
        INBT[] state = new INBT[]{this.nbtRoot, null};
        String key = this.findNbtInTree(path, state);
        INBT parent = state[1];
        if (parent instanceof CompoundNBT) {
            ((CompoundNBT)parent).func_82580_o(key);
        } else if (parent instanceof ListNBT) {
            ((ListNBT)parent).remove(Integer.parseInt(key));
        }
        this.updateNbt();
    }

    private void copy(TreePath t) {
        INBT nbt = this.get(t);
        String name = JOptionPane.showInputDialog(this, (Object)"Name for this tag: ");
        if (name != null) {
            NBTClipboard.saveToClipboard(nbt, name);
        }
    }

    private void paste(TreePath t) {
        Map<String, INBT> map = NBTClipboard.getContent();
        if (map.size() == 0) {
            JOptionPane.showMessageDialog(this, "No clipboard entries found!");
        } else {
            Object[] keys = map.keySet().toArray(new String[0]);
            String sel = (String)JOptionPane.showInputDialog(this, "Select which tag to paste: ", "", 1, null, keys, keys[0]);
            INBT nbt = map.get(sel).func_74737_b();
            INBT base = this.get(t);
            if (base instanceof CompoundNBT) {
                CompoundNBT into = (CompoundNBT)base;
                String name = JOptionPane.showInputDialog(this, (Object)"Select the name for the new tag: ");
                if (name != null) {
                    into.func_218657_a(name, nbt);
                }
            } else if (base instanceof ListNBT) {
                ((ListNBT)base).add((Object)nbt);
            }
            this.updateNbt();
        }
    }

    private void loadFileToClipboard() {
        JFileChooser choose = new JFileChooser(Minecraft.func_71410_x().field_71412_D);
        choose.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "*.nbt";
            }

            @Override
            public boolean accept(File f) {
                return f.isFile() && f.getName().endsWith(".nbt");
            }
        });
        int val = choose.showOpenDialog(this);
        if (val == 0) {
            File in = choose.getSelectedFile();
            try {
                CompoundNBT nbt = NBTUtils.readNBT(new FileInputStream(in));
                String name = JOptionPane.showInputDialog(this, (Object)"Name of the clipboard: ");
                if (name != null) {
                    NBTClipboard.saveToClipboard(nbt.func_74781_a("content"), name);
                }
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "Failed to load file. Check the log for details.");
                e.printStackTrace();
            }
        }
    }

    private void saveClipboardToFile() {
        Map<String, INBT> map = NBTClipboard.getContent();
        if (map.size() == 0) {
            JOptionPane.showMessageDialog(this, "No clipboard entries found!");
        } else {
            Object[] keys = map.keySet().toArray(new String[0]);
            String sel = (String)JOptionPane.showInputDialog(this, "Select which tag to save: ", "", 1, null, keys, keys[0]);
            INBT nbtTmp = map.get(sel);
            String name = JOptionPane.showInputDialog(this, (Object)"Name of the file: ");
            if (name != null) {
                if (!name.endsWith(".nbt")) {
                    name = name + ".nbt";
                }
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_218657_a("content", nbtTmp);
                File out = new File(Minecraft.func_71410_x().field_71412_D, name);
                try {
                    NBTUtils.writeNBT(nbt, new FileOutputStream(out));
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this, "Failed to save to file. Check the log for details.");
                    e.printStackTrace();
                }
            }
        }
    }

    private void deleteClipboardEntry() {
        Map<String, INBT> map = NBTClipboard.getContent();
        if (map.size() == 0) {
            JOptionPane.showMessageDialog(this, "No clipboard entries found!");
        } else {
            Object[] keys = map.keySet().toArray(new String[0]);
            String sel = (String)JOptionPane.showInputDialog(this, "Select which tag to delete: ", "", 1, null, keys, keys[0]);
            if (sel != null) {
                NBTClipboard.deleteEntry(sel);
            }
        }
    }

    private void writeTag(CompoundNBT nbt) {
        String name = JOptionPane.showInputDialog(this, (Object)"Name of the file: ");
        if (name != null) {
            if (!name.endsWith(".nbt")) {
                name = name + ".nbt";
            }
            File out = new File(Minecraft.func_71410_x().field_71412_D, name);
            try {
                NBTUtils.writeNBT(nbt, new FileOutputStream(out));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private JPopupMenu createMenu(TreePath tp) {
        INBT nbt = this.get(tp);
        if (nbt == null) {
            return null;
        }
        JPopupMenu ret = new JPopupMenu();
        JMenuItem m = ret.add("Delete tag");
        m.addActionListener(a -> this.delete(tp));
        m = ret.add("Copy tag");
        m.addActionListener(a -> this.copy(tp));
        if (nbt instanceof CompoundNBT || nbt instanceof ListNBT) {
            m = ret.add("Paste tag");
            m.addActionListener(a -> this.paste(tp));
        }
        if (nbt instanceof CompoundNBT) {
            m = ret.add("Write tag to file");
            m.addActionListener(a -> this.writeTag((CompoundNBT)nbt));
            ret.addSeparator();
            for (int i = 1; i < NBTUtils.NBT_TYPES.length; ++i) {
                this.addAddOption(ret, i, nbt);
            }
        } else if (nbt instanceof ListNBT) {
            ret.addSeparator();
            byte type = ((ListNBT)nbt).func_230528_d__();
            if (type == 0) {
                for (int i = 1; i < NBTUtils.NBT_TYPES.length; ++i) {
                    this.addAddOption(ret, i, nbt);
                }
            } else {
                this.addAddOption(ret, type, nbt);
            }
        }
        return ret;
    }

    private void addAddOption(JPopupMenu ret, int id, INBT nbt) {
        Consumer<INBT> set = element -> {
            if (nbt instanceof CompoundNBT) {
                String name = JOptionPane.showInputDialog(this, (Object)"Name of the new entry:");
                if (name != null) {
                    ((CompoundNBT)nbt).func_218657_a(name, element);
                }
            } else {
                assert (nbt instanceof ListNBT) : "nbt has to be a compound or a list";
                ((ListNBT)nbt).add(element);
            }
            this.updateNbt();
        };
        switch (id) {
            case 1: {
                JMenuItem m = ret.add("Add byte");
                m.addActionListener(a -> set.accept((INBT)ByteNBT.func_229671_a_((byte)0)));
                break;
            }
            case 2: {
                JMenuItem m = ret.add("Add short");
                m.addActionListener(a -> set.accept((INBT)ShortNBT.func_229701_a_((short)0)));
                break;
            }
            case 3: {
                JMenuItem m = ret.add("Add int");
                m.addActionListener(a -> set.accept((INBT)IntNBT.func_229692_a_((int)0)));
                break;
            }
            case 4: {
                JMenuItem m = ret.add("Add long");
                m.addActionListener(a -> set.accept((INBT)LongNBT.func_229698_a_((long)0L)));
                break;
            }
            case 5: {
                JMenuItem m = ret.add("Add float");
                m.addActionListener(a -> set.accept((INBT)FloatNBT.func_229689_a_((float)0.0f)));
                break;
            }
            case 6: {
                JMenuItem m = ret.add("Add double");
                m.addActionListener(a -> set.accept((INBT)DoubleNBT.func_229684_a_((double)0.0)));
                break;
            }
            case 7: {
                JMenuItem m = ret.add("Add byte[]");
                m.addActionListener(a -> set.accept((INBT)new ByteArrayNBT(new byte[]{1, 1, 2, 3, 5, 8})));
                break;
            }
            case 8: {
                JMenuItem m = ret.add("Add String");
                m.addActionListener(a -> set.accept((INBT)StringNBT.func_229705_a_((String)"")));
                break;
            }
            case 9: {
                JMenuItem m = ret.add("Add ListNBT");
                m.addActionListener(a -> set.accept((INBT)new ListNBT()));
                break;
            }
            case 10: {
                JMenuItem m = ret.add("Add CompoundNBT");
                m.addActionListener(a -> set.accept((INBT)new CompoundNBT()));
                break;
            }
            case 11: {
                JMenuItem m = ret.add("Add int[]");
                m.addActionListener(a -> set.accept((INBT)new IntArrayNBT(new int[]{1, 2, 3, 4, 5, 6})));
                break;
            }
            case 12: {
                JMenuItem m = ret.add("Add long[]");
                m.addActionListener(a -> set.accept((INBT)new LongArrayNBT(new long[]{1L, 2L, 3L, 4L, 5L, 6L})));
            }
        }
    }

    private String stringFromObject(Object o) {
        if (o instanceof DefaultMutableTreeNode) {
            o = ((DefaultMutableTreeNode)o).getUserObject();
        }
        if (o instanceof Pair) {
            o = ((Pair)o).getLeft();
        }
        return o.toString();
    }

    private void pushNbt() {
        try {
            this.provider.setNBT(this.editPos, this.nbtRoot, this.lastSynced);
        }
        catch (RuntimeException x) {
            x.printStackTrace();
            JOptionPane.showMessageDialog(this, x.getMessage(), "Exception!", 0);
        }
    }

    private class CloseListener
    extends WindowAdapter {
        private CloseListener() {
        }

        @Override
        public void windowClosed(WindowEvent e) {
            AutoPullConfig toRemove = new AutoPullConfig(NBTFrame.this, 0);
            NBTEdit.proxy.getAutoPulls().remove(toRemove);
        }
    }

    private class NBTMouseListener
    extends MouseAdapter {
        private NBTMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JPopupMenu menu;
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                NBTFrame.this.edit(NBTFrame.this.tree.getSelectionPath());
            } else if (e.getButton() == 3 && (menu = NBTFrame.this.createMenu(NBTFrame.this.tree.getSelectionPath())) != null) {
                menu.show(NBTFrame.this, e.getX(), e.getY());
            }
        }
    }

    private class NBTKeyListener
    extends KeyAdapter {
        private NBTKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                NBTFrame.this.edit(NBTFrame.this.tree.getSelectionPath());
            } else if (e.getKeyCode() == 127) {
                NBTFrame.this.delete(NBTFrame.this.tree.getSelectionPath());
            }
        }
    }
}

