/*
 * Decompiled with CFR 0.152.
 */
package malte0811.nbtedit.gui;

import java.awt.Component;
import java.io.InputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import malte0811.nbtedit.nbt.NBTUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.INBT;
import net.minecraft.resources.IResource;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;

class NBTTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final Icon[] nbtIcons = new Icon[NBTUtils.NBT_TYPES.length];
    private static final long serialVersionUID = 1L;
    private Icon curr;

    NBTTreeCellRenderer() {
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.curr = null;
        if (value instanceof DefaultMutableTreeNode) {
            value = ((DefaultMutableTreeNode)value).getUserObject();
        }
        if (value instanceof Pair) {
            Pair p = (Pair)value;
            String nbtVal = NBTUtils.nbtToString((INBT)p.getRight());
            value = (String)p.getLeft() + (nbtVal == null ? "" : ": " + nbtVal);
            this.curr = nbtIcons[((INBT)p.getRight()).func_74732_a()];
        }
        return super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
    }

    @Override
    public Icon getIcon() {
        return this.curr;
    }

    static {
        for (int i = 1; i < nbtIcons.length; ++i) {
            try {
                IResource r = Minecraft.func_71410_x().func_195551_G().func_199002_a(new ResourceLocation("nbtedit", "icons/" + NBTUtils.NBT_TYPES[i].toLowerCase().replace("[]", "_array") + ".png"));
                byte[] imageData = IOUtils.toByteArray((InputStream)r.func_199027_b());
                NBTTreeCellRenderer.nbtIcons[i] = new ImageIcon(imageData);
                continue;
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }
}

