/*
 * Decompiled with CFR 0.152.
 */
package malte0811.nbtedit.nbt;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import malte0811.nbtedit.NBTEdit;
import malte0811.nbtedit.nbt.AutoPullConfig;
import malte0811.nbtedit.nbt.CommonProxy;
import malte0811.nbtedit.nbt.EditPosKey;
import malte0811.nbtedit.nbt.VanillaNBTProvider;
import malte0811.nbtedit.network.MessagePushNBT;
import malte0811.nbtedit.network.MessageRequestNBT;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.MinecraftForge;

public class ClientProxy
extends CommonProxy {
    private final Set<AutoPullConfig> autoPulls = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<EditPosKey, Consumer<CompoundNBT>> WAITING = new HashMap<EditPosKey, Consumer<CompoundNBT>>();

    public ClientProxy() {
        MinecraftForge.EVENT_BUS.addListener(VanillaNBTProvider::clientChatEvent);
    }

    @Override
    public void requestNBT(EditPosKey k, @Nonnull Consumer<CompoundNBT> out) {
        NBTEdit.packetHandler.sendToServer((Object)new MessageRequestNBT(k));
        this.WAITING.put(k, out);
    }

    @Override
    public void setNBT(EditPosKey k, CompoundNBT newNbt, CompoundNBT lastKnown) {
        NBTEdit.packetHandler.sendToServer((Object)new MessagePushNBT(k, newNbt));
    }

    @Override
    public void cache(EditPosKey pos, CompoundNBT nbt) {
        if (this.WAITING.containsKey(pos)) {
            this.WAITING.remove(pos).accept(nbt);
        }
    }

    @Override
    public Set<AutoPullConfig> getAutoPulls() {
        return this.autoPulls;
    }

    @Override
    public void openNBTWindow() {
        Minecraft.func_71410_x().func_147108_a((Screen)new ChatScreen(""));
    }
}

