/*
 * Decompiled with CFR 0.152.
 */
package malte0811.nbtedit.nbt;

import java.util.UUID;
import javax.annotation.Nonnull;
import malte0811.nbtedit.api.ObjectType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class EditPosKey {
    @Nonnull
    public final UUID player;
    @Nonnull
    public final ObjectType type;
    public final RegistryKey<World> dim;
    @Nonnull
    public final UUID entity;
    @Nonnull
    public final BlockPos tilePos;
    @Nonnull
    public final Hand hand;
    private static final Hand[] HANDS = Hand.values();

    public EditPosKey(@Nonnull UUID p, RegistryKey<World> dim, @Nonnull UUID eId) {
        this.player = p;
        this.entity = eId;
        this.dim = dim;
        this.tilePos = BlockPos.field_177992_a;
        this.type = ObjectType.ENTITY;
        this.hand = Hand.MAIN_HAND;
    }

    public EditPosKey(@Nonnull UUID player, RegistryKey<World> dim) {
        this.player = player;
        this.entity = player;
        this.dim = dim;
        this.tilePos = BlockPos.field_177992_a;
        this.type = ObjectType.PLAYER;
        this.hand = Hand.MAIN_HAND;
    }

    public EditPosKey(@Nonnull UUID p, RegistryKey<World> dim, @Nonnull BlockPos pos) {
        this.player = p;
        this.tilePos = pos;
        this.dim = dim;
        this.entity = UUID.fromString("00000000-0000-0000-0000-000000000000");
        this.type = ObjectType.TILEENTITY;
        this.hand = Hand.MAIN_HAND;
    }

    public EditPosKey(@Nonnull UUID p, @Nonnull Hand h) {
        this.player = p;
        this.tilePos = BlockPos.field_177992_a;
        this.dim = World.field_234918_g_;
        this.entity = UUID.fromString("00000000-0000-0000-0000-000000000000");
        this.type = ObjectType.HAND;
        this.hand = h;
    }

    public static EditPosKey fromBytes(PacketBuffer pBuf) {
        UUID user = UUID.fromString(pBuf.func_150789_c(36));
        ResourceLocation dimensionName = new ResourceLocation(pBuf.func_150789_c(512));
        RegistryKey dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)dimensionName);
        byte typeId = pBuf.readByte();
        ObjectType type = ObjectType.VALUES[typeId];
        switch (type) {
            case ENTITY: 
            case PLAYER: {
                UUID e = pBuf.func_179253_g();
                return new EditPosKey(user, (RegistryKey<World>)dimension, e);
            }
            case TILEENTITY: {
                BlockPos pos = pBuf.func_179259_c();
                return new EditPosKey(user, (RegistryKey<World>)dimension, pos);
            }
            case HAND: {
                byte h = pBuf.readByte();
                return new EditPosKey(user, HANDS[h]);
            }
        }
        return null;
    }

    public void toBytes(PacketBuffer pBuf) {
        pBuf.func_180714_a(this.player.toString());
        pBuf.func_180714_a(this.dim.func_240901_a_().toString());
        pBuf.writeByte(this.type.ordinal());
        switch (this.type) {
            case ENTITY: {
                pBuf.func_179252_a(this.entity);
                break;
            }
            case TILEENTITY: {
                pBuf.func_179255_a(this.tilePos);
                break;
            }
            case HAND: {
                pBuf.writeByte(this.hand.ordinal());
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dim.hashCode();
        result = 31 * result + this.type.ordinal();
        result = 31 * result + this.entity.hashCode();
        result = 31 * result + this.player.hashCode();
        result = 31 * result + this.tilePos.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EditPosKey other = (EditPosKey)obj;
        if (this.type != other.type) {
            return false;
        }
        if (this.dim != other.dim) {
            return false;
        }
        if (!this.entity.equals(other.entity)) {
            return false;
        }
        if (!this.player.equals(other.player)) {
            return false;
        }
        return this.tilePos.equals((Object)other.tilePos);
    }
}

