/*
 * Decompiled with CFR 0.152.
 */
package malte0811.nbtedit.nbt;

import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import malte0811.nbtedit.NBTEdit;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.NBTTypes;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;
import org.apache.logging.log4j.Level;

public class NBTUtils {
    public static final String[] NBT_TYPES;

    public static String nbtToString(INBT nbt) {
        String ret = null;
        switch (nbt.func_74732_a()) {
            case 9: 
            case 10: {
                break;
            }
            case 1: {
                ret = Byte.toString(((ByteNBT)nbt).func_150290_f());
                break;
            }
            case 2: {
                ret = Short.toString(((ShortNBT)nbt).func_150289_e());
                break;
            }
            case 3: {
                ret = Integer.toString(((IntNBT)nbt).func_150287_d());
                break;
            }
            case 4: {
                ret = Long.toString(((LongNBT)nbt).func_150291_c());
                break;
            }
            case 5: {
                ret = Float.toString(((FloatNBT)nbt).func_150288_h());
                break;
            }
            case 6: {
                ret = Double.toString(((DoubleNBT)nbt).func_150286_g());
                break;
            }
            case 7: {
                ret = Arrays.toString(((ByteArrayNBT)nbt).func_150292_c());
                break;
            }
            case 8: {
                ret = nbt.func_150285_a_();
                break;
            }
            case 11: {
                ret = Arrays.toString(((IntArrayNBT)nbt).func_150302_c());
                break;
            }
            case 12: {
                ret = Arrays.toString(((LongArrayNBT)nbt).func_197652_h());
            }
        }
        return ret;
    }

    public static INBT stringToNbt(String in, INBT curr) {
        if (in == null) {
            return curr;
        }
        StringNBT ret = null;
        try {
            switch (curr.func_74732_a()) {
                case 9: 
                case 10: {
                    break;
                }
                case 1: {
                    ret = ByteNBT.func_229671_a_((byte)Byte.parseByte(in));
                    break;
                }
                case 2: {
                    ret = ShortNBT.func_229701_a_((short)Short.parseShort(in));
                    break;
                }
                case 3: {
                    ret = IntNBT.func_229692_a_((int)Integer.parseInt(in));
                    break;
                }
                case 4: {
                    ret = LongNBT.func_229698_a_((long)Long.parseLong(in));
                    break;
                }
                case 5: {
                    ret = FloatNBT.func_229689_a_((float)Float.parseFloat(in));
                    break;
                }
                case 6: {
                    ret = DoubleNBT.func_229684_a_((double)Double.parseDouble(in));
                    break;
                }
                case 7: {
                    ret = new ByteArrayNBT(NBTUtils.stringToArray(in, Byte::parseByte));
                    break;
                }
                case 8: {
                    ret = StringNBT.func_229705_a_((String)in);
                    break;
                }
                case 11: {
                    ret = new IntArrayNBT(NBTUtils.stringToArray(in, Integer::parseInt));
                    break;
                }
                case 12: {
                    ret = new LongArrayNBT(NBTUtils.stringToArray(in, Long::parseLong));
                }
            }
        }
        catch (Exception x) {
            ret = null;
            NBTEdit.logger.catching(Level.WARN, (Throwable)x);
        }
        return ret;
    }

    private static <T> List<T> stringToArray(String in, Function<String, T> parse) {
        String[] data = in.split(", ");
        ArrayList<T> ret = new ArrayList<T>(data.length);
        for (String aData : data) {
            ret.add(parse.apply(aData));
        }
        return ret;
    }

    public static void writeNBT(CompoundNBT nbt, OutputStream out) throws IOException {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        buffer.func_150786_a(nbt);
        out.write(buffer.array());
        out.flush();
    }

    public static CompoundNBT readNBT(InputStream in) throws IOException {
        int read;
        PacketBuffer bb = new PacketBuffer(Unpooled.buffer());
        while ((read = in.read()) != -1) {
            bb.writeByte(read);
        }
        return bb.func_150793_b();
    }

    static {
        String current;
        ArrayList<String> types = new ArrayList<String>();
        String invalidTypeName = "INVALID[";
        int i = 0;
        while (!(current = NBTTypes.func_229710_a_((int)i).func_225648_a_()).contains("INVALID[")) {
            types.add(current);
            ++i;
        }
        NBT_TYPES = types.toArray(new String[0]);
    }
}

