/*
 * Decompiled with CFR 0.152.
 */
package malte0811.nbtedit.nbt;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Queue;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import malte0811.nbtedit.api.INBTEditingProvider;
import malte0811.nbtedit.api.ObjectType;
import malte0811.nbtedit.nbt.EditPosKey;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class VanillaNBTProvider
implements INBTEditingProvider {
    private static final Queue<Consumer<CompoundNBT>> RECEIVERS = new ArrayDeque<Consumer<CompoundNBT>>();

    private void generateDiff(CompoundNBT curr, CompoundNBT old, Consumer<String> remove, CompoundNBT add) {
        HashSet keys = new HashSet(curr.func_150296_c());
        keys.addAll(old.func_150296_c());
        for (String key : keys) {
            if (curr.func_74764_b(key)) {
                if (old.func_74764_b(key)) {
                    INBT oldTag = old.func_74781_a(key);
                    INBT newTag = curr.func_74781_a(key);
                    assert (oldTag != null && newTag != null);
                    if (oldTag.func_74732_a() != newTag.func_74732_a()) {
                        add.func_218657_a(key, newTag);
                        continue;
                    }
                    byte i = oldTag.func_74732_a();
                    if (i == 10) {
                        CompoundNBT subDiff = new CompoundNBT();
                        this.generateDiff((CompoundNBT)newTag, (CompoundNBT)oldTag, k -> remove.accept(key + "." + k), subDiff);
                        if (subDiff.isEmpty()) continue;
                        add.func_218657_a(key, (INBT)subDiff);
                        continue;
                    }
                    if (oldTag.equals(newTag)) continue;
                    add.func_218657_a(key, newTag);
                    continue;
                }
                add.func_218657_a(key, curr.func_74781_a(key));
                continue;
            }
            remove.accept("\"" + key + "\"");
        }
    }

    @Override
    public void setNBT(EditPosKey k, CompoundNBT newNbt, CompoundNBT lastKnown) {
        CompoundNBT added = new CompoundNBT();
        String type = k.type == ObjectType.TILEENTITY ? "block " + k.tilePos.func_177958_n() + " " + k.tilePos.func_177956_o() + " " + k.tilePos.func_177952_p() : "entity";
        String mergeCommand = "/data merge " + type + " ";
        String removeCommand = "/data remove " + type + " ";
        this.generateDiff(newNbt, lastKnown, rem -> Minecraft.func_71410_x().field_71439_g.func_71165_d(removeCommand + rem), added);
        if (!added.isEmpty()) {
            Minecraft.func_71410_x().field_71439_g.func_71165_d(mergeCommand + added);
        }
    }

    @Override
    public void requestNBT(EditPosKey k, @Nonnull Consumer<CompoundNBT> out) {
        RECEIVERS.offer(out);
        switch (k.type) {
            case TILEENTITY: {
                Minecraft.func_71410_x().field_71439_g.func_71165_d("/data get block " + k.tilePos.func_177958_n() + " " + k.tilePos.func_177956_o() + " " + k.tilePos.func_177952_p());
                break;
            }
            case ENTITY: {
                Minecraft.func_71410_x().field_71439_g.func_71165_d("/data get entity " + k.entity);
            }
        }
    }

    @Override
    public boolean supportsType(ObjectType type) {
        return type == ObjectType.ENTITY || type == ObjectType.TILEENTITY;
    }

    private static String getText(ITextComponent source) {
        StringBuilder ret = new StringBuilder(source.func_150261_e());
        for (ITextComponent sibling : source.func_150253_a()) {
            ret.append(VanillaNBTProvider.getText(sibling));
        }
        return ret.toString();
    }

    @SubscribeEvent
    public static void clientChatEvent(ClientChatReceivedEvent ev) {
    }
}

