/*
 * Decompiled with CFR 0.152.
 */
package malte0811.nbtedit.network;

import java.util.function.Supplier;
import malte0811.nbtedit.NBTEdit;
import malte0811.nbtedit.nbt.EditPosKey;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageNBTSync {
    private EditPosKey pos;
    private CompoundNBT value;

    public MessageNBTSync(EditPosKey k, CompoundNBT val) {
        this.pos = k;
        this.value = val;
    }

    public MessageNBTSync(PacketBuffer buf) {
        this.pos = EditPosKey.fromBytes(buf);
        if (buf.readBoolean()) {
            this.value = buf.func_150793_b();
        }
    }

    public void toBytes(PacketBuffer buf) {
        this.pos.toBytes(buf);
        buf.writeBoolean(this.value != null);
        if (this.value != null) {
            buf.func_150786_a(this.value);
        }
    }

    public void onMessage(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> NBTEdit.proxy.cache(this.pos, this.value));
        ctx.get().setPacketHandled(true);
    }
}

