/*
 * Decompiled with CFR 0.152.
 */
package malte0811.nbtedit.network;

import java.util.function.Supplier;
import malte0811.nbtedit.NBTEdit;
import malte0811.nbtedit.nbt.EditPosKey;
import malte0811.nbtedit.util.Utils;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessagePushNBT {
    private EditPosKey pos;
    private CompoundNBT value;

    public MessagePushNBT(EditPosKey k, CompoundNBT val) {
        this.pos = k;
        this.value = val;
    }

    public MessagePushNBT(PacketBuffer buf) {
        this.pos = EditPosKey.fromBytes(buf);
        this.value = buf.func_150793_b();
    }

    public void toBytes(PacketBuffer buf) {
        this.pos.toBytes(buf);
        buf.func_150786_a(this.value);
    }

    public void onMessage(Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ServerPlayerEntity player = ctx.getSender();
        if (player != null) {
            ctx.enqueueWork(() -> {
                if (player.func_211513_k(2)) {
                    Utils.setNBTAtPos(this.pos, this.value, player.field_71133_b);
                } else {
                    NBTEdit.logger.error("Player " + player.func_200200_C_() + " tried to push NBT data to the server but isn't permitted to do so!");
                }
            });
        }
        ctx.setPacketHandled(true);
    }
}

