/*
 * Decompiled with CFR 0.152.
 */
package malte0811.nbtedit.network;

import java.util.function.Supplier;
import malte0811.nbtedit.NBTEdit;
import malte0811.nbtedit.nbt.EditPosKey;
import malte0811.nbtedit.network.MessageNBTSync;
import malte0811.nbtedit.util.Utils;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageRequestNBT {
    private EditPosKey pos;

    public MessageRequestNBT(EditPosKey e) {
        this.pos = e;
    }

    public MessageRequestNBT(PacketBuffer buf) {
        this.pos = EditPosKey.fromBytes(buf);
    }

    public void toBytes(PacketBuffer buf) {
        this.pos.toBytes(buf);
    }

    public void onMessage(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayerEntity player = ctx.get().getSender();
        if (player == null) {
            return;
        }
        MinecraftServer server = player.field_71133_b;
        ctx.get().enqueueWork(() -> {
            if (player.func_211513_k(2)) {
                CompoundNBT val = Utils.getNBTForPos(this.pos, server);
                NBTEdit.packetHandler.reply((Object)new MessageNBTSync(this.pos, val), (NetworkEvent.Context)ctx.get());
            } else {
                NBTEdit.logger.error("Player " + player.func_200200_C_() + " tried to request NBT data from the server but isn't permitted to do so!");
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

