/*
 * Decompiled with CFR 0.152.
 */
package malte0811.nbtedit.util;

import java.util.List;
import java.util.Optional;
import malte0811.nbtedit.NBTEdit;
import malte0811.nbtedit.nbt.EditPosKey;
import malte0811.nbtedit.network.MessageBlockUpdate;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public final class Utils {
    public static RayTraceResult rayTrace(Entity entity) {
        double d0 = 10.0;
        Vector3d eyePos = entity.func_213303_ch().func_72441_c(0.0, (double)entity.func_70047_e(), 0.0);
        Vector3d Vector3d1 = entity.func_70676_i(1.0f);
        Vector3d Vector3d2 = eyePos.func_72441_c(Vector3d1.field_72450_a * d0, Vector3d1.field_72448_b * d0, Vector3d1.field_72449_c * d0);
        BlockRayTraceResult block = entity.field_70170_p.func_217299_a(new RayTraceContext(eyePos, Vector3d2, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, entity));
        double d1 = block.func_216346_c() == RayTraceResult.Type.BLOCK ? block.func_216347_e().func_72438_d(eyePos) : Double.MAX_VALUE;
        Vector3d lookVec = entity.func_70676_i(1.0f);
        Vector3d maxRay = eyePos.func_72441_c(lookVec.field_72450_a * d0, lookVec.field_72448_b * d0, lookVec.field_72449_c * d0);
        Entity pointedEntity = null;
        Vector3d target = null;
        float f = 1.0f;
        List list = entity.field_70170_p.func_175674_a(entity, entity.func_174813_aQ().func_72321_a(lookVec.field_72450_a * d0, lookVec.field_72448_b * d0, lookVec.field_72449_c * d0).func_186662_g((double)f), EntityPredicates.field_180132_d.and(Entity::func_70067_L));
        double d2 = d1;
        for (Entity e : list) {
            Vector3d hitVec;
            double d3;
            float f1 = e.func_70111_Y();
            AxisAlignedBB axisalignedbb = e.func_174813_aQ().func_186662_g((double)f1);
            Optional hit = axisalignedbb.func_216365_b(eyePos, maxRay);
            if (axisalignedbb.func_72318_a(eyePos)) {
                if (!(d2 >= 0.0)) continue;
                pointedEntity = e;
                target = hit.orElse(eyePos);
                d2 = 0.0;
                continue;
            }
            if (!hit.isPresent() || !((d3 = eyePos.func_72438_d(hitVec = (Vector3d)hit.get())) < d2) && d2 != 0.0) continue;
            if (e == entity.func_184187_bx() && !entity.canRiderInteract()) {
                if (d2 != 0.0) continue;
                pointedEntity = e;
                target = hitVec;
                continue;
            }
            pointedEntity = e;
            target = hitVec;
            d2 = d3;
        }
        if (pointedEntity == null || eyePos.func_72438_d(target) > d1) {
            return block;
        }
        return new EntityRayTraceResult(pointedEntity);
    }

    public static CompoundNBT getNBTForPos(EditPosKey k, MinecraftServer server) {
        ServerWorld world = server.func_71218_a(k.dim);
        if (world == null) {
            return null;
        }
        switch (k.type) {
            case ENTITY: {
                Entity e = world.func_217461_a(k.entity);
                if (e == null) break;
                CompoundNBT ret = new CompoundNBT();
                e.func_184198_c(ret);
                return ret;
            }
            case TILEENTITY: {
                TileEntity te = world.func_175625_s(k.tilePos);
                if (te == null) break;
                return te.serializeNBT();
            }
            case HAND: {
                ServerPlayerEntity player = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(k.player);
                if (player == null) {
                    return null;
                }
                ItemStack stack = player.func_184586_b(k.hand);
                if (stack.func_190926_b()) break;
                return stack.serializeNBT().func_74737_b();
            }
        }
        return null;
    }

    public static void setNBTAtPos(EditPosKey k, CompoundNBT newNbt, MinecraftServer server) {
        ServerWorld world = server.func_71218_a(k.dim);
        if (world != null) {
            switch (k.type) {
                case ENTITY: {
                    Entity e = world.func_217461_a(k.entity);
                    if (e == null) break;
                    e.func_70020_e(newNbt);
                    break;
                }
                case TILEENTITY: {
                    TileEntity te = world.func_175625_s(k.tilePos);
                    if (te == null) break;
                    BlockState state = world.func_180495_p(k.tilePos);
                    te.func_230337_a_(state, newNbt);
                    te.func_70296_d();
                    BlockState newState = world.func_180495_p(k.tilePos);
                    world.func_184138_a(k.tilePos, state, state, 3);
                    world.func_195593_d(k.tilePos, newState.func_177230_c());
                    NBTEdit.packetHandler.send(PacketDistributor.TRACKING_CHUNK.with(() -> world.func_175726_f(k.tilePos)), (Object)new MessageBlockUpdate(k.tilePos));
                    break;
                }
                case HAND: {
                    ServerPlayerEntity player = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(k.player);
                    ItemStack stack = ItemStack.func_199557_a((CompoundNBT)newNbt);
                    player.func_184611_a(k.hand, stack);
                }
            }
        }
    }
}

