/*
 * Decompiled with CFR 0.152.
 */
package noppes.vc.blocks;

import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import noppes.vc.EntityChairMount;
import noppes.vc.blocks.VCBlockStateProperties;
import noppes.vc.blocks.tiles.TileChair;

public class BlockChair
extends ContainerBlock {
    public static final IntegerProperty ROTATION = VCBlockStateProperties.ROTATION_0_7;
    public static final VoxelShape AABB = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB((double)0.1f, 0.0, (double)0.1f, (double)0.9f, 0.5, (double)0.9f));
    private final Block material;

    public BlockChair(Block block) {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)block).func_226896_b_());
        this.material = block;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{ROTATION});
    }

    public void func_180633_a(World level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        int rot = MathHelper.func_76128_c((double)((double)(entity.field_70177_z / 45.0f) + 0.5)) & 7;
        level.func_180501_a(pos, (BlockState)state.func_206870_a((Property)ROTATION, (Comparable)Integer.valueOf(rot)), 2);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader level, BlockPos pos, ISelectionContext context) {
        return AABB;
    }

    public boolean func_196266_a(BlockState p_196266_1_, IBlockReader p_196266_2_, BlockPos p_196266_3_, PathType p_196266_4_) {
        return false;
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new TileChair().setMaterial(this.material);
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        return BlockChair.MountBlock(level, pos, player);
    }

    public static ActionResultType MountBlock(World level, BlockPos pos, PlayerEntity player) {
        if (level.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        List list = level.func_217357_a(Entity.class, new AxisAlignedBB(pos));
        for (Entity entity : list) {
            if (!(entity instanceof EntityChairMount)) continue;
            return ActionResultType.PASS;
        }
        EntityChairMount mount = new EntityChairMount(level);
        mount.func_70107_b((float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        level.func_217376_c((Entity)mount);
        if (!mount.field_70128_L) {
            player.func_184205_a((Entity)mount, true);
        }
        return ActionResultType.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String func_149739_a() {
        return "block.variedcommodities.chair";
    }
}

