/*
 * Decompiled with CFR 0.152.
 */
package noppes.vc.blocks;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import noppes.vc.VCBlocks;
import noppes.vc.blocks.BlockBasicLightable;
import noppes.vc.blocks.VCBlockStateProperties;
import noppes.vc.blocks.tiles.TileLamp;

public class BlockLamp
extends BlockBasicLightable {
    public static final VoxelShape AABB_NORMAL = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB((double)0.3f, 0.0, (double)0.3f, (double)0.7f, (double)0.6f, (double)0.7f));
    public static final VoxelShape AABB0 = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB((double)0.3f, (double)0.2f, (double)0.3f, (double)0.7f, (double)0.7f, (double)0.7f));
    public static final VoxelShape AABB1 = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB((double)0.3f, (double)0.2f, 0.5, (double)0.7f, (double)0.7f, (double)0.9f));
    public static final VoxelShape AABB2 = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB((double)0.3f, (double)0.2f, (double)0.1f, (double)0.7f, (double)0.7f, 0.5));
    public static final VoxelShape AABB3 = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.5, (double)0.2f, (double)0.3f, (double)0.9f, (double)0.7f, (double)0.7f));
    public static final VoxelShape AABB4 = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB((double)0.1f, (double)0.2f, (double)0.3f, 0.5, (double)0.7f, (double)0.7f));
    public static final IntegerProperty ROTATION = VCBlockStateProperties.ROTATION_0_7;

    public BlockLamp(boolean lit) {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150339_S).func_226896_b_(), lit);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader level, BlockPos pos, ISelectionContext context) {
        int rotation = (Integer)state.func_177229_b((Property)ROTATION);
        int type = (Integer)state.func_177229_b((Property)TYPE);
        if (type == 2) {
            if (rotation == 0) {
                return AABB1;
            }
            if (rotation == 4) {
                return AABB2;
            }
            if (rotation == 6) {
                return AABB3;
            }
            if (rotation == 2) {
                return AABB4;
            }
            return AABB0;
        }
        return AABB_NORMAL;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{ROTATION});
    }

    public void func_180633_a(World level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        int rot = MathHelper.func_76128_c((double)((double)(entity.field_70177_z / 45.0f) + 0.5)) & 7;
        level.func_180501_a(pos, (BlockState)state.func_206870_a((Property)ROTATION, (Comparable)Integer.valueOf(rot)), 2);
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new TileLamp();
    }

    @Override
    public Block unlitBlock() {
        return VCBlocks.lamp_unlit;
    }

    @Override
    public Block litBlock() {
        return VCBlocks.lamp;
    }
}

