/*
 * Decompiled with CFR 0.152.
 */
package noppes.vc.blocks;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import noppes.vc.blocks.BlockBasicTrigger;
import noppes.vc.blocks.VCBlockStateProperties;
import noppes.vc.blocks.tiles.TileBasicContainer;
import noppes.vc.blocks.tiles.TilePedestal;

public class BlockPedestal
extends BlockBasicTrigger {
    public static final VoxelShape AABB1 = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, (double)0.2f, 1.0, 0.5, (double)0.8f));
    public static final VoxelShape AABB2 = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB((double)0.2f, 0.0, 0.0, (double)0.8f, 0.5, 1.0));
    public static final IntegerProperty ROTATION = VCBlockStateProperties.ROTATION_0_7;
    private final Block material;

    public BlockPedestal(Block block) {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)block).func_226896_b_());
        this.material = block;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{ROTATION});
    }

    public void func_180633_a(World level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        int rot = MathHelper.func_76128_c((double)((double)(entity.field_70177_z / 45.0f) + 0.5)) & 7;
        level.func_180501_a(pos, (BlockState)state.func_206870_a((Property)ROTATION, (Comparable)Integer.valueOf(rot)), 2);
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        if (level.field_72995_K || hand != Hand.MAIN_HAND) {
            return ActionResultType.SUCCESS;
        }
        TilePedestal tile = (TilePedestal)level.func_175625_s(pos);
        ItemStack item = player.field_71071_by.func_70448_g();
        ItemStack weapon = tile.func_70301_a(0);
        if (item.func_190926_b() && !weapon.func_190926_b()) {
            tile.func_70299_a(0, ItemStack.field_190927_a);
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, weapon);
            tile.func_70296_d();
            level.func_184138_a(pos, state, state, 3);
            this.updateSurrounding(level, pos);
        } else {
            if (item.func_190926_b() || !(item.func_77973_b() instanceof SwordItem)) {
                return ActionResultType.SUCCESS;
            }
            if (!item.func_190926_b() && weapon.func_190926_b()) {
                tile.func_70299_a(0, item);
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                tile.func_70296_d();
                level.func_184138_a(pos, state, state, 3);
                this.updateSurrounding(level, pos);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader level, BlockPos pos, ISelectionContext context) {
        if ((Integer)state.func_177229_b((Property)ROTATION) % 2 == 0) {
            return AABB1;
        }
        return AABB2;
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new TilePedestal().setMaterial(this.material);
    }

    public void func_196243_a(BlockState state, World level, BlockPos pos, BlockState newState, boolean isMoving) {
        TileBasicContainer tile = (TileBasicContainer)level.func_175625_s(pos);
        if (tile == null) {
            return;
        }
        tile.dropItems(level, pos);
        level.func_175666_e(pos, state.func_177230_c());
        super.func_196243_a(state, level, pos, newState, isMoving);
    }

    @OnlyIn(value=Dist.CLIENT)
    public String func_149739_a() {
        return "block.variedcommodities.pedestal";
    }
}

