/*
 * Decompiled with CFR 0.152.
 */
package noppes.vc.items;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import noppes.vc.EntityProjectile;
import noppes.vc.VCEntities;
import noppes.vc.VCTabs;
import noppes.vc.VCWeapons;
import noppes.vc.client.VCSounds;
import noppes.vc.enchants.VCEnchant;
import noppes.vc.items.ItemBasic;

public class ItemGun
extends ItemBasic {
    private IItemTier material;

    public ItemGun(IItemTier material) {
        super(new Item.Properties().func_200915_b(material.func_200926_a()).func_200916_a(VCTabs.WEAPONS));
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public void func_77615_a(final ItemStack stack, World worldObj, LivingEntity entity, int par4) {
        if (worldObj.field_72995_K) {
            return;
        }
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            if (!this.hasBullet(player, stack)) {
                ItemGun.playSound((LivingEntity)player, VCSounds.GUN_EMPTY, 1.0f, 1.0f);
                return;
            }
            int ticks = this.func_77626_a(stack) - par4;
            if (ticks < 10) {
                return;
            }
            stack.func_190918_g(1);
            if (!player.field_71075_bZ.field_75098_d && !this.hasInfinite(stack)) {
                this.consumeItem(player, VCWeapons.bullet);
            }
        }
        float damage = (this.material.func_200929_c() + 1.0f) / 2.0f + 5.0f;
        damage += damage * (float)VCEnchant.getLevel(VCEnchant.Damage, stack) * 0.5f;
        EntityProjectile projectile = new EntityProjectile(VCEntities.Projectile, worldObj, entity, new ItemStack((IItemProvider)VCWeapons.bullet));
        projectile.damage = damage;
        projectile.callback = new EntityProjectile.IProjectileCallback(){

            @Override
            public boolean onImpact(EntityProjectile entityProjectile, BlockPos pos, Entity entity) {
                int poison;
                if (entity == null || !(entity instanceof LivingEntity)) {
                    return false;
                }
                LivingEntity living = (LivingEntity)entity;
                int confusion = VCEnchant.getLevel(VCEnchant.Confusion, stack);
                if (confusion > 0 && living.func_70681_au().nextInt(4) < confusion) {
                    living.func_195064_c(new EffectInstance(Effects.field_76431_k, 100));
                }
                if ((poison = VCEnchant.getLevel(VCEnchant.Poison, stack)) > 0 && living.func_70681_au().nextInt(4) < poison) {
                    living.func_195064_c(new EffectInstance(Effects.field_76436_u, 100));
                }
                return false;
            }
        };
        projectile.setSpeed(40);
        projectile.shoot(this.material.func_200929_c() + 1.0f);
        ItemGun.playSound(entity, VCSounds.GUN_PISTAL_SHOT, 1.0f, field_77697_d.nextFloat() * 0.3f + 0.8f);
        worldObj.func_217376_c((Entity)projectile);
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        int ticks = this.func_77626_a(stack) - count;
        if (ticks == 8 && !player.field_70170_p.field_72995_K) {
            ItemGun.playSound(player, VCSounds.GUN_PISTAL_TRIGGER, 1.0f, 1.0f / (player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World level, PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        player.func_184598_c(hand);
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    private boolean hasBullet(PlayerEntity player, ItemStack stack) {
        if (player.field_71075_bZ.field_75098_d || this.hasInfinite(stack)) {
            return true;
        }
        return this.hasItem(player, VCWeapons.bullet);
    }

    public boolean hasInfinite(ItemStack stack) {
        return VCEnchant.getLevel(VCEnchant.Infinite, stack) > 0;
    }

    public int getItemEnchantability(ItemStack item) {
        return this.material.func_200927_e();
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }
}

