/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.network;

import com.mojang.authlib.GameProfile;
import java.util.function.BiConsumer;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.IEntitySerializer;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.builder.blockentity.OutfitMakerBlockEntity;
import moe.plushie.armourers_workshop.builder.menu.OutfitMakerMenu;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.init.ModPermissions;
import moe.plushie.armourers_workshop.utils.BlockUtils;
import moe.plushie.armourers_workshop.utils.DataAccessor;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class UpdateOutfitMakerPacket
extends CustomPacket {
    private final BlockPos pos;
    private final Field field;
    private final Object fieldValue;

    public UpdateOutfitMakerPacket(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.field = (Field)buffer.func_179257_a(Field.class);
        this.fieldValue = this.field.accessor.read(buffer);
    }

    public UpdateOutfitMakerPacket(OutfitMakerBlockEntity entity, Field field, Object value) {
        this.pos = entity.func_174877_v();
        this.field = field;
        this.fieldValue = value;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        buffer.func_179249_a((Enum)this.field);
        this.field.accessor.write(buffer, this.fieldValue);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayerEntity player) {
        BlockUtils.performBatch(() -> this.accept2(packetHandler, player));
    }

    private void accept2(IServerPacketHandler packetHandler, ServerPlayerEntity player) {
        switch (this.field) {
            case ITEM_CRAFTING: {
                if (!ModPermissions.OUTFIT_MAKER_MAKE.accept((PlayerEntity)player)) {
                    return;
                }
                if (!(player.field_71070_bA instanceof OutfitMakerMenu)) break;
                CompoundNBT nbt = (CompoundNBT)this.fieldValue;
                GameProfile profile = DataSerializers.readGameProfile(nbt);
                ((OutfitMakerMenu)player.field_71070_bA).saveArmourItem((PlayerEntity)player, profile);
                break;
            }
            case ITEM_NAME: 
            case ITEM_FLAVOUR: {
                TileEntity entity = player.func_71121_q().func_175625_s(this.pos);
                if (!(entity instanceof OutfitMakerBlockEntity)) break;
                this.field.accessor.set((OutfitMakerBlockEntity)entity, this.fieldValue);
                break;
            }
        }
    }

    public static enum Field implements DataAccessor.Provider<OutfitMakerBlockEntity>
    {
        ITEM_NAME(OutfitMakerBlockEntity::getItemName, OutfitMakerBlockEntity::setItemName, DataSerializers.STRING),
        ITEM_FLAVOUR(OutfitMakerBlockEntity::getItemFlavour, OutfitMakerBlockEntity::setItemFlavour, DataSerializers.STRING),
        ITEM_CRAFTING(null, null, DataSerializers.COMPOUND_TAG);

        private final DataAccessor<OutfitMakerBlockEntity, Object> accessor;

        private <T> Field(Function<OutfitMakerBlockEntity, T> supplier, BiConsumer<OutfitMakerBlockEntity, T> applier, IEntitySerializer<T> dataSerializer) {
            this.accessor = DataAccessor.erased(dataSerializer, supplier, applier);
        }

        @Override
        public DataAccessor<OutfitMakerBlockEntity, Object> getAccessor() {
            return this.accessor;
        }
    }
}

