/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.armature;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.armature.IJoint;
import moe.plushie.armourers_workshop.api.armature.IJointTransform;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.common.IEntityTypeProvider;
import moe.plushie.armourers_workshop.api.data.IDataPackObject;
import moe.plushie.armourers_workshop.core.armature.ArmatureModifier;
import moe.plushie.armourers_workshop.core.armature.Armatures;
import moe.plushie.armourers_workshop.core.armature.JointTransformBuilder;
import moe.plushie.armourers_workshop.core.armature.core.AfterTransformModifier;
import moe.plushie.armourers_workshop.core.armature.core.AllayBodyJointModifier;
import moe.plushie.armourers_workshop.core.armature.core.AllayHeadJointModifier;
import moe.plushie.armourers_workshop.core.armature.core.AllayWingJointModifier;
import moe.plushie.armourers_workshop.core.armature.core.DefaultBabyJointModifier;
import moe.plushie.armourers_workshop.core.armature.core.DefaultSkirtJointModifier;
import moe.plushie.armourers_workshop.core.armature.core.FlatWingJointModifier;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.util.ResourceLocation;

public abstract class ArmatureBuilder {
    private static final ImmutableMap<String, ArmatureModifier> FIXED_MODIFIERS = ImmutableMap.builder().put((Object)"armourers_workshop:baby_head_apt", (Object)new DefaultBabyJointModifier()).put((Object)"armourers_workshop:body_to_skirt", (Object)new DefaultSkirtJointModifier()).put((Object)"armourers_workshop:body_to_flat_wing", (Object)new FlatWingJointModifier()).put((Object)"armourers_workshop:apply_ally_head", (Object)new AllayHeadJointModifier()).put((Object)"armourers_workshop:apply_ally_body", (Object)new AllayBodyJointModifier()).put((Object)"armourers_workshop:apply_ally_wing", (Object)new AllayWingJointModifier()).build();
    private static final ImmutableMap<String, Function<IDataPackObject, ArmatureModifier>> PARAMETERIZED_MODIFIERS = ImmutableMap.builder().build();
    protected ResourceLocation parent;
    protected final ResourceLocation name;
    protected final ArrayList<String> models = new ArrayList();
    protected final ArrayList<IEntityTypeProvider<?>> entities = new ArrayList();
    protected final HashMap<IJoint, Collection<ArmatureModifier>> jointModifiers = new HashMap();
    protected final HashMap<IJoint, Collection<ArmatureModifier>> transformModifiers = new HashMap();

    public ArmatureBuilder(ResourceLocation name) {
        this.name = name;
        Armatures.init();
    }

    public void load(Collection<ArmatureBuilder> builders) {
        builders.forEach(builder -> {
            this.jointModifiers.putAll(builder.jointModifiers);
            this.transformModifiers.putAll(builder.transformModifiers);
            this.entities.clear();
            this.entities.addAll(builder.entities);
            this.models.addAll(builder.models);
        });
    }

    public void load(IDataPackObject object) {
        object.get("joint").entrySet().forEach(it -> {
            IJoint joint = Armatures.BIPPED.searchJointByName((String)it.getKey());
            if (joint != null) {
                this.jointModifiers.put(joint, this._parseModelModifiers((IDataPackObject)it.getValue()));
            }
        });
        object.get("transform").ifPresent(it -> {
            it.get("translate").entrySet().forEach(it2 -> this._parseTranslateModifiers((String)it2.getKey(), (IDataPackObject)it2.getValue()));
            it.get("scale").entrySet().forEach(it2 -> this._parseScaleModifiers((String)it2.getKey(), (IDataPackObject)it2.getValue()));
            it.get("rotate").entrySet().forEach(it2 -> this._parseRotateModifiers((String)it2.getKey(), (IDataPackObject)it2.getValue()));
        });
        object.get("models").allValues().forEach(it -> this.models.add(it.stringValue()));
        object.get("entities").allValues().forEach(it -> this.entities.add(IEntityTypeProvider.of(it.stringValue())));
        object.get("parent").ifPresent(it -> {
            this.parent = new ResourceLocation(it.stringValue());
        });
    }

    public IJointTransform[] build(IModel model) {
        HashMap<IJoint, Collection> modifiers = new HashMap<IJoint, Collection>();
        this.jointModifiers.forEach((joint, modifiers1) -> modifiers.computeIfAbsent((IJoint)joint, k -> new ArrayList()).addAll(modifiers1));
        this.transformModifiers.forEach((joint, modifiers1) -> modifiers.computeIfAbsent((IJoint)joint, k -> new ArrayList()).addAll(modifiers1));
        JointTransformBuilder builder = JointTransformBuilder.of(Armatures.BIPPED);
        modifiers.forEach((joint, modifiers1) -> builder.put((IJoint)joint, this.buildTransform((IJoint)joint, model, (Collection<ArmatureModifier>)modifiers1)));
        return builder.build();
    }

    public IJointTransform buildTransform(IJoint joint, IModel model, Collection<ArmatureModifier> modifiers) {
        IJointTransform transform = IJointTransform.NONE;
        for (ArmatureModifier modifier : modifiers) {
            transform = modifier.apply(joint, model, transform);
        }
        return transform;
    }

    public abstract Collection<ArmatureModifier> getTargets(IDataPackObject var1);

    public ArrayList<String> getModels() {
        return this.models;
    }

    public List<IEntityTypeProvider<?>> getEntities() {
        return this.entities;
    }

    public ResourceLocation getParent() {
        return this.parent;
    }

    public ResourceLocation getName() {
        return this.name;
    }

    private Collection<ArmatureModifier> _parseModelModifiers(IDataPackObject object) {
        switch (object.type()) {
            case STRING: {
                return this.getTargets(object);
            }
            case DICTIONARY: {
                ArrayList<ArmatureModifier> modifiers = new ArrayList<ArmatureModifier>();
                modifiers.addAll(this.getTargets(object));
                modifiers.addAll(this._parseTransformModifiers(object, AfterTransformModifier::new));
                modifiers.addAll(this._parseModifiers(object.get("modifier")));
                return modifiers;
            }
        }
        return Collections.emptyList();
    }

    private Collection<ArmatureModifier> _parseModifiers(IDataPackObject object) {
        switch (object.type()) {
            case ARRAY: {
                ArrayList<ArmatureModifier> modifiers = new ArrayList<ArmatureModifier>();
                object.allValues().forEach(it -> {
                    ArmatureModifier modifier = (ArmatureModifier)FIXED_MODIFIERS.get((Object)it.stringValue());
                    if (modifier != null) {
                        modifiers.add(modifier);
                    }
                });
                return modifiers;
            }
            case DICTIONARY: {
                ArrayList<ArmatureModifier> modifiers = new ArrayList<ArmatureModifier>();
                object.entrySet().forEach(it -> {
                    Function builder = (Function)PARAMETERIZED_MODIFIERS.get(it.getKey());
                    if (builder != null) {
                        modifiers.add((ArmatureModifier)builder.apply((IDataPackObject)it.getValue()));
                        return;
                    }
                    ArmatureModifier modifier = (ArmatureModifier)FIXED_MODIFIERS.get(it.getKey());
                    if (modifier != null) {
                        modifiers.add(modifier);
                    }
                });
                return modifiers;
            }
        }
        return Collections.emptyList();
    }

    private Collection<ArmatureModifier> _parseTransformModifiers(IDataPackObject object, TransformBuilder builder) {
        Vector3f translate = this._parseVector(object.get("translate"), Vector3f.ZERO);
        Vector3f scale = this._parseVector(object.get("scale"), Vector3f.ONE);
        Vector3f rotate = this._parseVector(object.get("rotate"), Vector3f.ZERO);
        if (translate.equals(Vector3f.ZERO) && scale.equals(Vector3f.ONE) && rotate.equals(Vector3f.ZERO)) {
            return Collections.emptyList();
        }
        return Collections.singleton(builder.apply(translate, scale, rotate));
    }

    private Vector3f _parseVector(IDataPackObject object, Vector3f defaultValue) {
        switch (object.type()) {
            case ARRAY: {
                if (object.size() != 3) break;
                float f1 = object.at(0).floatValue();
                float f2 = object.at(1).floatValue();
                float f3 = object.at(2).floatValue();
                return new Vector3f(f1, f2, f3);
            }
            case DICTIONARY: {
                float f1 = object.get("x").floatValue();
                float f2 = object.get("y").floatValue();
                float f3 = object.get("z").floatValue();
                return new Vector3f(f1, f2, f3);
            }
        }
        return defaultValue;
    }

    private void _parseTranslateModifiers(String name, IDataPackObject object) {
        Vector3f value = this._parseVector(object, Vector3f.ZERO);
        if (value.equals(Vector3f.ZERO)) {
            return;
        }
        this._addTransformModifier(name, new AfterTransformModifier(value, Vector3f.ONE, Vector3f.ZERO));
    }

    private void _parseRotateModifiers(String name, IDataPackObject object) {
        Vector3f value = this._parseVector(object, Vector3f.ZERO);
        if (value.equals(Vector3f.ZERO)) {
            return;
        }
        this._addTransformModifier(name, new AfterTransformModifier(Vector3f.ZERO, Vector3f.ONE, value));
    }

    private void _parseScaleModifiers(String name, IDataPackObject object) {
        Vector3f value = this._parseVector(object, Vector3f.ONE);
        if (value.equals(Vector3f.ONE)) {
            return;
        }
        this._addTransformModifier(name, new AfterTransformModifier(Vector3f.ZERO, value, Vector3f.ZERO));
    }

    private void _addTransformModifier(String name, ArmatureModifier modifier) {
        Collection<IJoint> joints;
        if (name.equals("") || name.equals("*")) {
            joints = Armatures.BIPPED.allJoints();
        } else {
            IJoint joint = Armatures.BIPPED.searchJointByName(name);
            if (joint == null) {
                return;
            }
            joints = Collections.singleton(joint);
        }
        for (IJoint joint : joints) {
            this.transformModifiers.computeIfAbsent(joint, k -> new ArrayList()).add(modifier);
        }
    }

    private static interface TransformBuilder {
        public ArmatureModifier apply(Vector3f var1, Vector3f var2, Vector3f var3);
    }
}

