/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.armature;

import java.util.HashMap;
import java.util.Optional;
import moe.plushie.armourers_workshop.api.armature.IJointTransform;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.core.armature.ArmatureManager;
import moe.plushie.armourers_workshop.init.platform.SkinModifierManager;
import moe.plushie.armourers_workshop.utils.DataStorageKey;
import net.minecraft.entity.EntityType;

public class JointTransformModifier {
    public static final DataStorageKey<JointTransformModifier> DEFAULT = DataStorageKey.of("default", JointTransformModifier.class, () -> new JointTransformModifier(SkinModifierManager.DEFAULT));
    public static final DataStorageKey<JointTransformModifier> EPICFIGHT = DataStorageKey.of("epicfight", JointTransformModifier.class, () -> new JointTransformModifier(SkinModifierManager.EPICFIGHT));
    private final ArmatureManager armatureManager;
    private final HashMap<EntityType<?>, Optional<IJointTransform[]>> transforms = new HashMap();
    private int version;

    public JointTransformModifier(ArmatureManager armatureManager) {
        this.armatureManager = armatureManager;
    }

    public IJointTransform[] getTransforms(EntityType<?> entityType, IModel model) {
        if (this.version != this.armatureManager.getVersion()) {
            this.version = this.armatureManager.getVersion();
            this.transforms.clear();
        }
        return this.transforms.computeIfAbsent(entityType, k -> Optional.ofNullable(this.armatureManager.getTransforms(entityType, model))).orElse(null);
    }
}

