/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.wardrobe;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UILabel;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.client.gui.wardrobe.SkinWardrobeBaseSetting;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.network.UpdateWardrobePacket;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinWardrobeLocationSetting
extends SkinWardrobeBaseSetting {
    private final float[] steps = new float[]{1.0f, 0.125f, 0.0625f};
    private final SkinWardrobe wardrobe;
    private final Entity entity;

    public SkinWardrobeLocationSetting(SkinWardrobe wardrobe, Entity entity) {
        super("wardrobe.man_offsets");
        this.wardrobe = wardrobe;
        this.entity = entity;
        this.setup();
    }

    private void setup() {
        int j;
        int i;
        this.setupLabel(146, 29, "X");
        this.setupLabel(146, 49, "Y");
        this.setupLabel(146, 69, "Z");
        int x = 83;
        int y = 25;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.setupButton(x + i * 20, y + j * 20, 208, 80, j, -this.steps[i], "button.sub." + -(i - 3));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.setupButton(x + 77 + i * 20, y + j * 20, 208, 96, j, this.steps[3 - i - 1], "button.add." + (i + 1));
            }
        }
    }

    private void setupLabel(int x, int y, String text) {
        UILabel label = new UILabel(new CGRect(x, y, 10.0f, 9.0f));
        label.setText(new NSString(text));
        this.addSubview(label);
    }

    private void setupButton(int x, int y, int u, int v, int axis, float step, String key) {
        UIButton button = new UIButton(new CGRect(x, y, 16.0f, 16.0f));
        button.setBackgroundImage(ModTextures.defaultButtonImage(u, v), 7);
        button.setTooltip(this.getDisplayText(key, new Object[0]));
        button.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, (self, e) -> self.updateValue(axis, step));
        this.addSubview(button);
    }

    private void updateValue(int axis, float step) {
        MannequinEntity entity = ObjectUtils.safeCast(this.entity, MannequinEntity.class);
        if (entity == null) {
            return;
        }
        Vector3d pos = entity.func_213303_ch();
        double[] xyz = new double[]{pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c()};
        xyz[axis] = xyz[axis] + (double)step;
        pos = new Vector3d(xyz[0], xyz[1], xyz[2]);
        UpdateWardrobePacket packet = UpdateWardrobePacket.field(this.wardrobe, UpdateWardrobePacket.Field.MANNEQUIN_POSITION, pos);
        NetworkManager.sendToServer(packet);
    }
}

