/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data.transform;

import java.util.ArrayList;
import java.util.Collection;
import moe.plushie.armourers_workshop.api.action.ICanRotation;
import moe.plushie.armourers_workshop.api.math.IPoseStack;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.api.skin.ISkinTransform;
import moe.plushie.armourers_workshop.core.data.transform.SkinWingsTransform;
import moe.plushie.armourers_workshop.core.skin.SkinMarker;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import net.minecraft.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class SkinPartTransform
implements ISkinTransform {
    private final ArrayList<ISkinTransform> transforms = new ArrayList();

    public SkinPartTransform(SkinPart part, ISkinTransform quadsTransform) {
        ISkinTransform partTransform;
        ISkinTransform wingsTransform;
        if (quadsTransform != null) {
            this.transforms.add(quadsTransform);
        }
        if ((wingsTransform = this.getWingsTransform(part)) != null) {
            this.transforms.add(wingsTransform);
        }
        if ((partTransform = part.getTransform()) != null) {
            this.transforms.add(partTransform);
        }
    }

    public void setup(float partialTicks, @Nullable Entity entity) {
        for (ISkinTransform transform : this.transforms) {
            if (!(transform instanceof SkinWingsTransform)) continue;
            ((SkinWingsTransform)transform).setup(partialTicks, entity);
        }
    }

    private ISkinTransform getWingsTransform(SkinPart part) {
        ISkinPartType partType = part.getType();
        if (!(partType instanceof ICanRotation)) {
            return null;
        }
        Collection<SkinMarker> markers = part.getMarkers();
        if (markers == null || markers.size() == 0) {
            return null;
        }
        return new SkinWingsTransform(partType, part.getProperties(), markers.iterator().next());
    }

    @Override
    public void pre(IPoseStack poseStack) {
        for (ISkinTransform transform : this.transforms) {
            transform.pre(poseStack);
        }
    }

    @Override
    public void post(IPoseStack poseStack) {
        for (ISkinTransform transform : this.transforms) {
            transform.post(poseStack);
        }
    }
}

