/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.holiday;

import java.util.Calendar;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;

public class Holiday {
    protected final String name;
    protected final Calendar startDate;
    protected final Calendar endDate;
    protected IHandler handler;
    protected int tintColor1 = -13421773;
    protected int tintColor2 = -1;
    protected boolean enabled = true;

    public Holiday(String name, Calendar startDate, Calendar endDate) {
        this.name = name;
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public String getName() {
        return this.name;
    }

    public Calendar getStartDate() {
        return this.startDate;
    }

    public Calendar getEndDate() {
        return this.endDate;
    }

    public IHandler getHandler() {
        return this.handler;
    }

    public void setHandler(IHandler handler) {
        this.handler = handler;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isHolidayActive() {
        if (this.enabled) {
            Calendar current = Calendar.getInstance();
            return current.after(this.startDate) & current.before(this.endDate);
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Holiday holiday = (Holiday)o;
        return this.name.equals(holiday.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static interface IHandler {
        public ItemStack getGift(PlayerEntity var1);

        default public int getBackgroundColor() {
            return 0xFFFFFF;
        }

        default public int getForegroundColor() {
            return 0x333333;
        }
    }
}

