/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.holiday;

import extensions.net.minecraft.world.level.storage.DimensionDataStorage.DataProvider;
import java.util.Calendar;
import java.util.HashSet;
import moe.plushie.armourers_workshop.compatibility.core.AbstractSavedData;
import moe.plushie.armourers_workshop.core.holiday.Holiday;
import moe.plushie.armourers_workshop.init.ModLog;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.server.MinecraftServer;

public class HolidayTracker
extends AbstractSavedData {
    private final Calendar calendar = Calendar.getInstance();
    private final HashSet<String> logs = new HashSet();

    public static HolidayTracker of(MinecraftServer server) {
        return DataProvider.computeIfAbsent(server.func_241755_D_().func_217481_x(), HolidayTracker::new, 0, "HolidayTracker");
    }

    public void add(PlayerEntity player, Holiday holiday) {
        ModLog.info("give a {} gift sack for the {}", holiday.getName(), player.func_195047_I_());
        this.logs.add(this.getKey(player, holiday));
        this.setDirty();
    }

    public void remove(PlayerEntity player, Holiday holiday) {
        ModLog.info("take a {} gift sack for the {}", holiday.getName(), player.func_195047_I_());
        this.logs.remove(this.getKey(player, holiday));
        this.setDirty();
    }

    public boolean has(PlayerEntity player, Holiday holiday) {
        return this.logs.contains(this.getKey(player, holiday));
    }

    @Override
    public void load(CompoundNBT tag) {
        this.logs.clear();
        String prefix = this.calendar.get(1) + ":";
        ListNBT listNBT = tag.func_150295_c("Logs", 8);
        int size = listNBT.size();
        for (int i = 0; i < size; ++i) {
            String log = listNBT.func_150307_f(i);
            if (!log.startsWith(prefix)) continue;
            this.logs.add(log);
        }
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt) {
        String prefix = this.calendar.get(1) + ":";
        ListNBT listNBT = new ListNBT();
        for (String log : this.logs) {
            if (!log.startsWith(prefix)) continue;
            listNBT.add((Object)StringNBT.func_229705_a_((String)log));
        }
        nbt.func_218657_a("Logs", (INBT)listNBT);
        return nbt;
    }

    private String getKey(PlayerEntity player, Holiday holiday) {
        return this.calendar.get(1) + ":" + holiday.getName() + ":" + player.func_189512_bd();
    }
}

