/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.item;

import java.util.List;
import moe.plushie.armourers_workshop.api.common.IEntityType;
import moe.plushie.armourers_workshop.core.data.MannequinHitResult;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.item.FlavouredItem;
import moe.plushie.armourers_workshop.core.texture.PlayerTextureDescriptor;
import moe.plushie.armourers_workshop.init.ModEntityTypes;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.utils.TranslateUtils;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class MannequinItem
extends FlavouredItem {
    public MannequinItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack of(@Nullable PlayerEntity player, float scale) {
        ItemStack itemStack = new ItemStack((IItemProvider)ModItems.MANNEQUIN.get());
        CompoundNBT entityTag = new CompoundNBT();
        if (scale != 1.0f) {
            entityTag.func_74776_a("Scale", scale);
        }
        if (player != null) {
            PlayerTextureDescriptor descriptor = new PlayerTextureDescriptor(player.func_146103_bH());
            entityTag.func_218657_a("Texture", (INBT)descriptor.serializeNBT());
        }
        if (entityTag.func_186856_d() != 0) {
            CompoundNBT nbt = itemStack.func_196082_o();
            nbt.func_218657_a("EntityTag", (INBT)entityTag);
        }
        return itemStack;
    }

    public static boolean isSmall(ItemStack itemStack) {
        CompoundNBT entityTag = itemStack.func_179543_a("EntityTag");
        if (entityTag != null) {
            return entityTag.func_74767_n("Small");
        }
        return false;
    }

    public static void setScale(ItemStack itemStack, float scale) {
        CompoundNBT entityTag = itemStack.func_190925_c("EntityTag");
        entityTag.func_74776_a("Scale", scale);
    }

    public static float getScale(ItemStack itemStack) {
        CompoundNBT entityTag = itemStack.func_179543_a("EntityTag");
        if (entityTag == null || !entityTag.func_150297_b("Scale", 5)) {
            return 1.0f;
        }
        return entityTag.func_74760_g("Scale");
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_221531_n() != Hand.MAIN_HAND) {
            return ActionResultType.FAIL;
        }
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.FAIL;
        }
        World level = context.func_195991_k();
        Vector3f origin = new Vector3f((float)player.func_226277_ct_(), (float)player.func_226278_cu_(), (float)player.func_226281_cx_());
        MannequinHitResult rayTraceResult = MannequinHitResult.test(player, origin, context.func_221532_j(), context.func_195995_a());
        ItemStack itemStack = context.func_195996_i();
        if (level instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)level;
            MannequinEntity entity = (MannequinEntity)((IEntityType)ModEntityTypes.MANNEQUIN.get()).create(serverWorld, rayTraceResult.func_216350_a(), itemStack.func_77978_p(), SpawnReason.SPAWN_EGG);
            if (entity == null) {
                return ActionResultType.FAIL;
            }
            Vector3d clickedLocation = rayTraceResult.func_216347_e();
            entity.func_70080_a(clickedLocation.func_82615_a(), clickedLocation.func_82617_b(), clickedLocation.func_82616_c(), 0.0f, 0.0f);
            entity.func_181013_g(rayTraceResult.getRotation());
            level.func_217376_c((Entity)entity);
            level.func_184148_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), SoundEvents.field_187710_m, SoundCategory.BLOCKS, 0.75f, 0.8f);
            itemStack.func_190918_g(1);
            return ActionResultType.func_233537_a_((boolean)level.func_201670_d());
        }
        return ActionResultType.FAIL;
    }

    public String func_77667_c(ItemStack itemStack) {
        float scale = MannequinItem.getScale(itemStack);
        if (scale <= 0.5f) {
            return super.func_77667_c(itemStack) + ".small";
        }
        if (scale >= 2.0f) {
            return super.func_77667_c(itemStack) + ".big";
        }
        return super.func_77667_c(itemStack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World level, List<ITextComponent> tooltips, ITooltipFlag flag) {
        super.func_77624_a(itemStack, level, tooltips, flag);
        PlayerTextureDescriptor descriptor = PlayerTextureDescriptor.of(itemStack);
        if (descriptor.getName() != null) {
            tooltips.add((ITextComponent)TranslateUtils.subtitle("item.armourers_workshop.rollover.user", descriptor.getName()));
        }
        if (descriptor.getURL() != null) {
            tooltips.add((ITextComponent)TranslateUtils.subtitle("item.armourers_workshop.rollover.url", descriptor.getURL()));
        }
    }
}

