/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.utils.SkinFileStreamUtils;
import moe.plushie.armourers_workshop.utils.StreamUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;

public class ResponseSkinPacket
extends CustomPacket {
    private final String identifier;
    private final Mode mode;
    private final boolean compress;
    private final Exception exp;
    private final Skin skin;

    public ResponseSkinPacket(String identifier, Skin skin, Exception exp) {
        this.identifier = identifier;
        this.exp = exp;
        this.skin = skin;
        this.mode = skin != null ? Mode.STREAM : Mode.EXCEPTION;
        this.compress = ModConfig.Common.enableServerCompressesSkins;
    }

    public ResponseSkinPacket(PacketBuffer buffer) {
        this.identifier = buffer.func_150789_c(Short.MAX_VALUE);
        this.mode = (Mode)buffer.func_179257_a(Mode.class);
        this.compress = buffer.readBoolean();
        this.exp = this.readException(buffer);
        this.skin = this.readSkinStream(buffer);
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_180714_a(this.identifier);
        buffer.func_179249_a((Enum)this.mode);
        buffer.writeBoolean(this.compress);
        this.writeException(buffer, this.exp);
        this.writeSkinStream(buffer, this.skin);
    }

    @Override
    public void accept(IClientPacketHandler packetHandler, PlayerEntity player) {
        SkinLoader.getInstance().addSkin(this.identifier, this.skin, this.exp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Exception readException(PacketBuffer buffer) {
        Exception exception;
        if (this.mode != Mode.EXCEPTION) {
            return null;
        }
        InputStream inputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            inputStream = this.createInputStream(buffer);
            objectInputStream = new ObjectInputStream(inputStream);
            exception = (Exception)objectInputStream.readObject();
        }
        catch (Exception exception2) {
            Exception exception3;
            try {
                exception3 = exception2;
            }
            catch (Throwable throwable) {
                StreamUtils.closeQuietly(objectInputStream, inputStream);
                throw throwable;
            }
            StreamUtils.closeQuietly(objectInputStream, inputStream);
            return exception3;
        }
        StreamUtils.closeQuietly(objectInputStream, inputStream);
        return exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeException(PacketBuffer buffer, Exception exception) {
        if (this.mode != Mode.EXCEPTION) {
            return;
        }
        OutputStream outputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            outputStream = this.createOutputStream(buffer);
            objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(exception);
        }
        catch (Exception exception1) {
            try {
                exception1.printStackTrace();
            }
            catch (Throwable throwable) {
                StreamUtils.closeQuietly(objectOutputStream, outputStream);
                throw throwable;
            }
            StreamUtils.closeQuietly(objectOutputStream, outputStream);
        }
        StreamUtils.closeQuietly(objectOutputStream, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Skin readSkinStream(PacketBuffer buffer) {
        Skin skin;
        if (this.mode != Mode.STREAM) {
            return null;
        }
        InputStream inputStream = null;
        try {
            inputStream = this.createInputStream(buffer);
            skin = SkinFileStreamUtils.loadSkinFromStream(inputStream);
        }
        catch (Exception exception) {
            try {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                StreamUtils.closeQuietly(inputStream);
                throw throwable;
            }
            StreamUtils.closeQuietly(inputStream);
            return null;
        }
        StreamUtils.closeQuietly(inputStream);
        return skin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSkinStream(PacketBuffer buffer, Skin skin) {
        if (this.mode != Mode.STREAM) {
            return;
        }
        OutputStream outputStream = null;
        try {
            outputStream = this.createOutputStream(buffer);
            SkinFileStreamUtils.saveSkinToStream(outputStream, skin);
        }
        catch (Exception exception) {
            try {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                StreamUtils.closeQuietly(outputStream);
                throw throwable;
            }
            StreamUtils.closeQuietly(outputStream);
        }
        StreamUtils.closeQuietly(outputStream);
    }

    private InputStream createInputStream(PacketBuffer buffer) throws Exception {
        ByteBufInputStream inputStream = new ByteBufInputStream((ByteBuf)buffer);
        if (this.compress) {
            return new GZIPInputStream((InputStream)inputStream);
        }
        return inputStream;
    }

    private OutputStream createOutputStream(PacketBuffer buffer) throws Exception {
        ByteBufOutputStream outputStream = new ByteBufOutputStream((ByteBuf)buffer);
        if (this.compress) {
            return new GZIPOutputStream((OutputStream)outputStream);
        }
        return outputStream;
    }

    public static enum Mode {
        EXCEPTION,
        STREAM;

    }
}

