/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.registry;

import moe.plushie.armourers_workshop.core.registry.ModRegistry;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.core.skin.part.advanced.action.SkinActionRotate;
import moe.plushie.armourers_workshop.core.skin.part.advanced.trigger.SkinTriggerAlways;
import moe.plushie.armourers_workshop.core.skin.part.advanced.value.SkinValueHealthPercentage;
import moe.plushie.armourers_workshop.core.skin.part.advanced.value.SkinValueInWater;
import moe.plushie.armourers_workshop.core.skin.part.advanced.value.SkinValueRaining;
import moe.plushie.armourers_workshop.core.skin.part.advanced.value.SkinValueSneaking;
import moe.plushie.armourers_workshop.core.skin.part.advanced.value.SkinValueTime;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;

public class AdvancedSkinRegistry {
    private final ModRegistry<AdvancedSkinTrigger> registrySkinTriggers = new ModRegistry("Skin Trigger Registry");
    private final ModRegistry<AdvancedSkinAction> registrySkinActions = new ModRegistry("Skin Action Registry");
    private final ModRegistry<AdvancedSkinValue> registrySkinValues = new ModRegistry("Skin Value Registry");

    public AdvancedSkinRegistry() {
        this.register();
    }

    private void register() {
        this.registrySkinTriggers.register(new SkinTriggerAlways());
        this.registrySkinActions.register(new SkinActionRotate());
        this.registrySkinValues.register(new SkinValueHealthPercentage());
        this.registrySkinValues.register(new SkinValueInWater());
        this.registrySkinValues.register(new SkinValueSneaking());
        this.registrySkinValues.register(new SkinValueTime());
        this.registrySkinValues.register(new SkinValueRaining());
    }

    public static abstract class AdvancedSkinMathValue
    extends ModRegistry.RegistryItem {
        public AdvancedSkinMathValue(String name) {
            super(name);
        }

        public abstract float getValue(World var1, Entity var2, Skin var3, float ... var4);

        public abstract String[] getInputs();
    }

    public static abstract class AdvancedSkinValue
    extends ModRegistry.RegistryItem {
        public AdvancedSkinValue(String name) {
            super(name);
        }

        public abstract float getValue(World var1, Entity var2, Skin var3, SkinPart var4);
    }

    public static abstract class AdvancedSkinAction
    extends ModRegistry.RegistryItem {
        public AdvancedSkinAction(String name) {
            super(name);
        }

        public abstract void trigger(World var1, Entity var2, Skin var3, float ... var4);

        public abstract String[] getInputs();
    }

    public static abstract class AdvancedSkinTrigger
    extends ModRegistry.RegistryItem {
        public AdvancedSkinTrigger(String name) {
            super(name);
        }

        public abstract boolean canTrigger(World var1, Entity var2, Skin var3, SkinPart var4);
    }
}

