/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.document;

import java.util.LinkedHashMap;
import java.util.Stack;
import moe.plushie.armourers_workshop.core.network.UpdateSkinDocumentPacket;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentListener;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentNode;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentType;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;

public class SkinDocumentSynchronizer
implements SkinDocumentListener {
    private boolean isApplying = false;
    private boolean isCapturing = false;
    private CompoundNBT capturedPropertiesValues;
    private CompoundNBT capturedSettingValues;
    private final LinkedHashMap<String, CompoundNBT> capturedNodeValues = new LinkedHashMap();
    private final Stack<Boolean> capturedStates = new Stack();
    private final TileEntity blockEntity;

    public SkinDocumentSynchronizer(TileEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    @Override
    public void documentDidChangeType(SkinDocumentType type) {
        this.post(new UpdateSkinDocumentPacket.ChangeTypeAction(type));
    }

    @Override
    public void documentDidChangeSettings(CompoundNBT tag) {
        if (this.isCapturing) {
            if (this.capturedSettingValues != null) {
                this.capturedSettingValues.func_197643_a(tag);
            } else {
                this.capturedSettingValues = tag;
            }
            return;
        }
        this.post(new UpdateSkinDocumentPacket.UpdateSettingsAction(tag));
    }

    @Override
    public void documentDidChangeProperties(CompoundNBT tag) {
        if (this.isCapturing) {
            if (this.capturedPropertiesValues != null) {
                this.capturedPropertiesValues.func_197643_a(tag);
            } else {
                this.capturedPropertiesValues = tag;
            }
            return;
        }
        this.post(new UpdateSkinDocumentPacket.UpdatePropertiesAction(tag));
    }

    @Override
    public void documentDidInsertNode(SkinDocumentNode node, SkinDocumentNode target, int index) {
        this.post(new UpdateSkinDocumentPacket.InsertNodeAction(node.getId(), index, target.serializeNBT()));
    }

    @Override
    public void documentDidUpdateNode(SkinDocumentNode node, CompoundNBT tag) {
        if (this.isCapturing) {
            this.capturedNodeValues.computeIfAbsent(node.getId(), it -> tag).func_197643_a(tag);
            return;
        }
        this.post(new UpdateSkinDocumentPacket.UpdateNodeAction(node.getId(), tag));
    }

    @Override
    public void documentDidRemoveNode(SkinDocumentNode node) {
        this.post(new UpdateSkinDocumentPacket.RemoveNodeAction(node.getId()));
    }

    @Override
    public void documentDidMoveNode(SkinDocumentNode node, SkinDocumentNode target, int index) {
        this.post(new UpdateSkinDocumentPacket.MoveNodeAction(node.getId(), target.getId(), index));
    }

    @Override
    public void documentWillBeginEditing() {
        this.isApplying = true;
    }

    @Override
    public void documentDidEndEditing() {
        this.isApplying = false;
    }

    public void beginCapture() {
        this.capturedStates.push(this.isCapturing);
        this.isCapturing = true;
    }

    public void endCapture() {
        this.isCapturing = this.capturedStates.pop();
        if (this.isCapturing) {
            return;
        }
        if (this.capturedPropertiesValues != null) {
            this.documentDidChangeProperties(this.capturedPropertiesValues);
            this.capturedPropertiesValues = null;
        }
        if (this.capturedSettingValues != null) {
            this.documentDidChangeSettings(this.capturedSettingValues);
            this.capturedSettingValues = null;
        }
        this.capturedNodeValues.forEach((id, tag) -> this.post(new UpdateSkinDocumentPacket.UpdateNodeAction((String)id, (CompoundNBT)tag)));
        this.capturedNodeValues.clear();
    }

    private void post(UpdateSkinDocumentPacket.Action action) {
        if (this.isApplying) {
            return;
        }
        NetworkManager.sendToServer(new UpdateSkinDocumentPacket(this.blockEntity, action));
    }
}

