/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.coder.v2;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.api.common.ITextureKey;
import moe.plushie.armourers_workshop.api.common.ITextureProvider;
import moe.plushie.armourers_workshop.api.skin.ISkinCube;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkPaletteData;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.coder.ChunkCubeEncoder;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.math.Vector2f;
import moe.plushie.armourers_workshop.utils.texture.TextureBox;
import net.minecraft.util.Direction;
import org.apache.commons.lang3.tuple.Pair;

public class ChunkCubeEncoderV2
extends ChunkCubeEncoder {
    private ISkinCube cube;
    private final SortedMap startValues = new SortedMap();
    private final SortedMap endValues = new SortedMap();

    @Override
    public int begin(ISkinCube cube) {
        for (Direction dir : Direction.values()) {
            ITextureKey value = cube.getTexture(dir);
            if (value == null) continue;
            ITextureProvider provider = value.getProvider();
            TextureBox.Entry entry = ObjectUtils.safeCast(value, TextureBox.Entry.class);
            if (entry != null) {
                this.startValues.put(entry.getParent(), provider, 128);
                continue;
            }
            float u = value.getU();
            float v = value.getV();
            float s = value.getWidth();
            float t = value.getHeight();
            this.startValues.put(new Vector2f(u, v), provider, 1 << dir.func_176745_a());
            this.endValues.put(new Vector2f(u + s, v + t), provider, 1 << dir.func_176745_a());
        }
        this.cube = cube;
        return this.startValues.size() + this.endValues.size();
    }

    @Override
    public void end(ChunkPaletteData palette, ChunkOutputStream stream) throws IOException {
        stream.writeRectangle3f(this.cube.getShape());
        stream.writeTransformf(this.cube.getTransform());
        for (Map.Entry entry : Iterables.concat(this.startValues.entrySet(), this.endValues.entrySet())) {
            stream.writeByte((Integer)entry.getValue());
            stream.writeVariable(palette.writeTexture((Vector2f)((Pair)entry.getKey()).getLeft(), (ITextureProvider)((Pair)entry.getKey()).getRight()));
        }
        this.startValues.clear();
        this.endValues.clear();
        this.cube = null;
    }

    public static class SortedMap
    extends LinkedHashMap<Pair<Vector2f, ITextureProvider>, Integer> {
        public void put(Vector2f pos, ITextureProvider provider, int flag) {
            Pair index = Pair.of((Object)pos, (Object)provider);
            int face = this.getOrDefault(index, 0);
            this.put(index, face |= flag);
        }
    }
}

