/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import moe.plushie.armourers_workshop.api.data.IDataPackObject;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.utils.StreamUtils;
import net.minecraft.util.Util;

public class ModOptions {
    private static final ModOptions INSTANCE = new ModOptions();
    private final File contentPath;
    private final LinkedHashMap<String, IDataPackObject> values = new LinkedHashMap();

    private ModOptions() {
        this.contentPath = new File(EnvironmentManager.getRootDirectory(), "options.json");
        try {
            if (this.contentPath.exists()) {
                this.load();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static ModOptions getInstance() {
        return INSTANCE;
    }

    public void putString(String key, String value) {
        this.values.put(key, IDataPackObject.of((JsonElement)new JsonPrimitive(value)));
        this.setChanged();
    }

    public String getString(String key) {
        IDataPackObject obj = this.values.get(key);
        if (obj != null) {
            return obj.stringValue();
        }
        return null;
    }

    public void putInt(String key, int value) {
        this.values.put(key, IDataPackObject.of((JsonElement)new JsonPrimitive((Number)value)));
        this.setChanged();
    }

    public int getInt(String key) {
        IDataPackObject obj = this.values.get(key);
        if (obj != null) {
            return obj.intValue();
        }
        return 0;
    }

    public void putBoolean(String key, boolean value) {
        this.values.put(key, IDataPackObject.of((JsonElement)new JsonPrimitive(Boolean.valueOf(value))));
        this.setChanged();
    }

    public boolean getBoolean(String key) {
        IDataPackObject obj = this.values.get(key);
        if (obj != null) {
            return obj.boolValue();
        }
        return false;
    }

    private void load() throws IOException {
        IDataPackObject object = StreamUtils.fromPackObject(new FileInputStream(this.contentPath));
        if (object == null) {
            return;
        }
        object.entrySet().forEach(it -> this.values.put((String)it.getKey(), (IDataPackObject)it.getValue()));
    }

    private void save() {
        try {
            IDataPackObject packObject = IDataPackObject.of((JsonElement)new JsonObject());
            this.values.forEach(packObject::set);
            StreamUtils.writePackObject(packObject, new FileOutputStream(this.contentPath));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setChanged() {
        Util.func_215072_e().execute(this::save);
    }
}

